/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.transport.http.bridge.filter;

import java.net.URI;
import java.net.URLDecoder;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.mina.core.filterchain.IoFilter;
import org.apache.mina.core.filterchain.IoFilterChain;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.core.write.WriteRequest;
import org.apache.mina.filter.codec.ProtocolDecoderException;
import org.apache.mina.filter.codec.ProtocolEncoderException;
import org.kaazing.gateway.transport.http.HttpAcceptFilter;
import org.kaazing.gateway.transport.http.HttpAcceptSession;
import org.kaazing.gateway.transport.http.HttpConnectSession;
import org.kaazing.gateway.transport.http.HttpCookie;
import org.kaazing.gateway.transport.http.HttpMethod;
import org.kaazing.gateway.transport.http.HttpSession;
import org.kaazing.gateway.transport.http.HttpStatus;
import org.kaazing.gateway.transport.http.HttpVersion;
import org.kaazing.gateway.transport.http.bridge.HttpHeaderNameComparator;
import org.kaazing.gateway.transport.http.bridge.HttpRequestMessage;
import org.kaazing.gateway.transport.http.bridge.HttpResponseMessage;
import org.kaazing.gateway.transport.http.bridge.filter.HttpContentMessageInjectionFilter;
import org.kaazing.gateway.transport.http.bridge.filter.HttpFilterAdapter;

public class HttpxeProtocolFilter
extends HttpFilterAdapter<IoSession> {
    private static final String CONTENT_TYPE_TEXT_PLAIN_CHARSET_UTF_8 = "text/plain;charset=UTF-8";
    private static final String CONTENT_TYPE_APPLICATION_OCTET_STREAM = "application/octet-stream";
    private static final String CONTENT_TYPE_APPLICATION_X_MESSAGE_HTTP = "application/x-message-http";
    private static final String CONTENT_TYPE_TEXT_PLAIN = "text/plain";
    private static final String CONTENT_TYPE_PREFIX_TEXT = "text/";
    private static final SortedSet<String> RESTRICTED_ENVELOPE_HEADERS;
    private static final Collection<String> ASCII_COMPATIBLE;
    private final Mode mode;

    public HttpxeProtocolFilter(boolean client) {
        this.mode = client ? Mode.CLIENT : Mode.SERVER;
    }

    @Override
    protected void filterWriteHttpRequest(IoFilter.NextFilter nextFilter, IoSession session, WriteRequest writeRequest, HttpRequestMessage httpRequest) throws Exception {
        switch (this.mode) {
            case CLIENT: {
                HttpConnectSession httpSession = (HttpConnectSession)session;
                this.filterWriteAndInjectHttpRequest(nextFilter, httpSession, writeRequest, httpRequest);
                break;
            }
            default: {
                super.filterWriteHttpRequest(nextFilter, session, writeRequest, httpRequest);
            }
        }
    }

    @Override
    protected void httpRequestReceived(IoFilter.NextFilter nextFilter, IoSession session, HttpRequestMessage httpRequest) throws Exception {
        switch (this.mode) {
            case SERVER: {
                HttpAcceptSession httpSession = (HttpAcceptSession)session;
                this.receiveAndExtractHttpRequest(nextFilter, httpSession, httpRequest);
                break;
            }
            default: {
                super.httpRequestReceived(nextFilter, session, httpRequest);
            }
        }
    }

    @Override
    protected void filterWriteHttpResponse(IoFilter.NextFilter nextFilter, IoSession session, WriteRequest writeRequest, HttpResponseMessage httpResponse) throws Exception {
        switch (this.mode) {
            case SERVER: {
                HttpAcceptSession httpSession = (HttpAcceptSession)session;
                this.filterWriteAndInjectHttpResponse(nextFilter, httpSession, writeRequest, httpResponse);
                break;
            }
            default: {
                super.filterWriteHttpResponse(nextFilter, session, writeRequest, httpResponse);
            }
        }
    }

    @Override
    protected void httpResponseReceived(IoFilter.NextFilter nextFilter, IoSession session, HttpResponseMessage httpResponse) throws Exception {
        switch (this.mode) {
            case CLIENT: {
                HttpSession httpSession = (HttpSession)session;
                this.receiveAndExtractHttpResponse(nextFilter, httpSession, httpResponse);
                break;
            }
            default: {
                super.httpResponseReceived(nextFilter, session, httpResponse);
            }
        }
    }

    private void filterWriteAndInjectHttpRequest(IoFilter.NextFilter nextFilter, HttpConnectSession session, WriteRequest writeRequest, HttpRequestMessage httpRequest) throws Exception {
        HttpVersion version = httpRequest.getVersion();
        session.setVersion(version);
        session.setMethod(HttpMethod.POST);
        URI requestURI = httpRequest.getRequestURI();
        session.setRequestURI(requestURI);
        String contentType = httpRequest.getHeader("Content-Type");
        String newContentType = this.calculateContentType(contentType);
        session.setWriteHeader("Content-Type", newContentType);
        Iterator<String> iterator = httpRequest.iterateHeaderNames();
        block4: while (iterator.hasNext()) {
            String headerName = iterator.next();
            switch (headerName.charAt(0)) {
                case 'A': 
                case 'a': {
                    if (!"Authorization".equalsIgnoreCase(headerName)) break;
                    continue block4;
                }
                case 'C': 
                case 'c': {
                    if ("Content-Length".equalsIgnoreCase(headerName)) {
                        IoFilterChain filterChain = session.getFilterChain();
                        filterChain.addFirst(HttpAcceptFilter.CONTENT_LENGTH_ADJUSTMENT.filterName(), HttpAcceptFilter.CONTENT_LENGTH_ADJUSTMENT.filter());
                        break;
                    }
                    if (!"Content-Type".equalsIgnoreCase(headerName)) break;
                    continue block4;
                }
            }
            String headerValue = httpRequest.getHeader(headerName);
            session.setWriteHeader(headerName, headerValue);
            iterator.remove();
        }
        if (httpRequest.hasCookies()) {
            Set<HttpCookie> writeCookies = session.getWriteCookies();
            Iterator<HttpCookie> iterator2 = httpRequest.iterateCookies();
            while (iterator2.hasNext()) {
                HttpCookie cookie = iterator2.next();
                writeCookies.add(cookie);
                iterator2.remove();
            }
        }
        nextFilter.filterWrite((IoSession)session, writeRequest);
    }

    private void receiveAndExtractHttpRequest(IoFilter.NextFilter nextFilter, HttpAcceptSession session, HttpRequestMessage httpRequest) throws Exception {
        httpRequest.setContentLengthImplicit(true);
        if (session.getVersion() != httpRequest.getVersion()) {
            throw new ProtocolDecoderException("HTTP version mismatch");
        }
        if (session.getMethod() != HttpMethod.POST) {
            throw new ProtocolDecoderException("Unexpected HTTP method");
        }
        if (!URLDecoder.decode(session.getRequestURI().toString(), "UTF-8").equals(URLDecoder.decode(httpRequest.getRequestURI().toString(), "UTF-8"))) {
            throw new ProtocolDecoderException("HTTP request URI mismatch");
        }
        String contentType = session.getReadHeader("Content-Type");
        if (contentType == null) {
            throw new ProtocolDecoderException("Expected HTTP content-type");
        }
        if (!CONTENT_TYPE_APPLICATION_X_MESSAGE_HTTP.equals(contentType)) {
            throw new ProtocolDecoderException("Unexpected HTTP content-type");
        }
        for (String headerName : httpRequest.getHeaderNames()) {
            if (!RESTRICTED_ENVELOPE_HEADERS.contains(headerName)) continue;
            throw new ProtocolDecoderException("Unsupported HTTP header(s)");
        }
        block9: for (String readHeaderName : session.getReadHeaderNames()) {
            List<String> readHeaderValues;
            switch (readHeaderName.charAt(0)) {
                case 'A': 
                case 'a': {
                    if (!"Authorization".equalsIgnoreCase(readHeaderName)) break;
                    continue block9;
                }
                case 'C': 
                case 'c': {
                    if ("Content-Length".equalsIgnoreCase(readHeaderName)) {
                        switch (httpRequest.getMethod()) {
                            case GET: 
                            case HEAD: {
                                continue block9;
                            }
                        }
                        if (httpRequest.hasHeader(readHeaderName)) continue block9;
                        long contentLength = Long.parseLong(session.getReadHeader(readHeaderName));
                        long newContentLength = contentLength - session.getReadBytes();
                        httpRequest.setHeader(readHeaderName, String.valueOf(newContentLength));
                        continue block9;
                    }
                    if (!"Content-Type".equalsIgnoreCase(readHeaderName)) break;
                    continue block9;
                }
                case 'X': 
                case 'x': {
                    if (!"X-Next-Protocol".equalsIgnoreCase(readHeaderName)) break;
                    continue block9;
                }
            }
            if ((readHeaderValues = session.getReadHeaders(readHeaderName)) == null || readHeaderValues.isEmpty()) continue;
            for (String headerValue : readHeaderValues) {
                httpRequest.addHeader(readHeaderName, headerValue);
            }
        }
        for (HttpCookie readCookie : session.getReadCookies()) {
            httpRequest.addCookie(readCookie);
        }
        nextFilter.messageReceived((IoSession)session, (Object)httpRequest);
    }

    /*
     * Enabled aggressive block sorting
     */
    private HttpResponseMessage filterWriteAndInjectHttpResponse(IoFilter.NextFilter nextFilter, HttpAcceptSession session, WriteRequest writeRequest, HttpResponseMessage httpResponse) throws ProtocolEncoderException {
        httpResponse.setContentLengthImplicit(true);
        httpResponse.setBlockPadding(false);
        HttpVersion version = httpResponse.getVersion();
        session.setVersion(version);
        HttpStatus status = httpResponse.getStatus();
        switch (status) {
            case CLIENT_NOT_FOUND: {
                session.setStatus(status);
                if (!httpResponse.hasReason()) break;
                session.setReason(httpResponse.getReason());
                break;
            }
            default: {
                session.setStatus(HttpStatus.SUCCESS_OK);
            }
        }
        boolean adjustContentLength = httpResponse.hasHeader("Content-Length") || httpResponse.isComplete() && !"gzip".equals(httpResponse.getHeader("Content-Encoding")) && !"chunked".equals(httpResponse.getHeader("Transfer-Encoding"));
        Iterator<String> iterator = httpResponse.iterateHeaderNames();
        block31: while (iterator.hasNext()) {
            String headerName = iterator.next();
            if (headerName.length() > 0) {
                block3 : switch (headerName.charAt(0)) {
                    case 'A': 
                    case 'a': {
                        if (headerName.length() <= 21) continue block31;
                        switch (headerName.charAt(21)) {
                            case 'C': 
                            case 'c': {
                                if (!"Access-Control-Allow-Credentials".equalsIgnoreCase(headerName)) break;
                                break block3;
                            }
                            case 'H': 
                            case 'h': {
                                if (!"Access-Control-Allow-Headers".equalsIgnoreCase(headerName)) break;
                                break block3;
                            }
                            case 'O': 
                            case 'o': {
                                if ("Access-Control-Allow-Origin".equalsIgnoreCase(headerName)) break block3;
                            }
                        }
                        continue block31;
                    }
                    case 'C': 
                    case 'c': {
                        if (headerName.length() <= 1) continue block31;
                        block19 : switch (headerName.charAt(1)) {
                            case 'A': 
                            case 'a': {
                                if (!"Cache-Control".equalsIgnoreCase(headerName)) break;
                                break block3;
                            }
                            case 'O': 
                            case 'o': {
                                if (headerName.length() <= 3) break;
                                switch (headerName.charAt(3)) {
                                    case 'N': 
                                    case 'n': {
                                        if (!"Connection".equalsIgnoreCase(headerName)) break block19;
                                        break block3;
                                    }
                                    case 'T': 
                                    case 't': {
                                        if ("Content-Length".equalsIgnoreCase(headerName) || "Content-Encoding".equalsIgnoreCase(headerName)) break block3;
                                        if (!"Content-Type".equalsIgnoreCase(headerName)) break block19;
                                    }
                                }
                            }
                        }
                        continue block31;
                    }
                    case 'D': 
                    case 'd': {
                        if (!"Date".equalsIgnoreCase(headerName)) continue block31;
                        break;
                    }
                    case 'E': 
                    case 'e': {
                        if (!"ETag".equalsIgnoreCase(headerName)) continue block31;
                        break;
                    }
                    case 'L': 
                    case 'l': {
                        if (!"Last-Modified".equalsIgnoreCase(headerName)) continue block31;
                        break;
                    }
                    case 'P': 
                    case 'p': {
                        if (!"Pragma".equalsIgnoreCase(headerName)) continue block31;
                        break;
                    }
                    case 'S': 
                    case 's': {
                        if (headerName.length() <= 2) continue block31;
                        switch (headerName.charAt(2)) {
                            case 'R': 
                            case 'r': {
                                if (!"Server".equalsIgnoreCase(headerName)) break;
                                break block3;
                            }
                            case 'T': 
                            case 't': {
                                if ("Set-Cookie".equalsIgnoreCase(headerName)) break block3;
                            }
                        }
                        continue block31;
                    }
                    case 'T': 
                    case 't': {
                        if (!"Transfer-Encoding".equalsIgnoreCase(headerName)) continue block31;
                        break;
                    }
                    case 'X': 
                    case 'x': {
                        if (!"X-Content-Type-Options".equalsIgnoreCase(headerName)) continue block31;
                        break;
                    }
                    default: {
                        continue block31;
                    }
                }
            }
            List<String> headerValues = httpResponse.getHeaderValues(headerName);
            session.setWriteHeaders(headerName, headerValues);
            iterator.remove();
        }
        if (session.getStatus() == HttpStatus.SUCCESS_OK && httpResponse.getStatus() != HttpStatus.SUCCESS_OK && session.getWriteHeader("Cache-Control") == null) {
            session.setWriteHeader("Cache-Control", "no-cache");
        }
        if (httpResponse.hasCookies()) {
            Set<HttpCookie> writeCookies = session.getWriteCookies();
            Iterator<HttpCookie> iterator2 = httpResponse.iterateCookies();
            while (iterator2.hasNext()) {
                HttpCookie cookie = iterator2.next();
                writeCookies.add(cookie);
                iterator2.remove();
            }
        }
        if (adjustContentLength) {
            IoFilterChain filterChain = session.getFilterChain();
            filterChain.addFirst(HttpAcceptFilter.CONTENT_LENGTH_ADJUSTMENT.filterName(), HttpAcceptFilter.CONTENT_LENGTH_ADJUSTMENT.filter());
        }
        String contentType = httpResponse.getHeader("Content-Type");
        if (HttpContentMessageInjectionFilter.contentAutomaticallyInjectable(httpResponse.getStatus())) {
            contentType = null;
        }
        String newContentType = this.calculateContentType(contentType);
        session.setWriteHeader("Content-Type", newContentType);
        nextFilter.filterWrite((IoSession)session, writeRequest);
        return httpResponse;
    }

    private void receiveAndExtractHttpResponse(IoFilter.NextFilter nextFilter, HttpSession session, HttpResponseMessage httpResponse) throws Exception {
        if (session.getVersion() != httpResponse.getVersion()) {
            throw new ProtocolDecoderException("HTTP version mismatch");
        }
        switch (session.getStatus()) {
            case SUCCESS_OK: {
                break;
            }
            default: {
                throw new ProtocolDecoderException("HTTP status mismatch");
            }
        }
        block7: for (String readHeaderName : session.getReadHeaderNames()) {
            switch (readHeaderName.charAt(0)) {
                case 'C': 
                case 'c': {
                    if ("Content-Length".equalsIgnoreCase(readHeaderName)) {
                        if (httpResponse.hasHeader(readHeaderName)) continue block7;
                        long contentLength = Long.parseLong(session.getReadHeader(readHeaderName));
                        long newContentLength = contentLength - session.getReadBytes();
                        httpResponse.setHeader(readHeaderName, String.valueOf(newContentLength));
                        continue block7;
                    }
                    if (!"Content-Type".equalsIgnoreCase(readHeaderName)) break;
                    String contentType = session.getReadHeader("Content-Type");
                    String innerContentType = httpResponse.getHeader("Content-Type");
                    if (innerContentType == null) continue block7;
                    if (innerContentType.startsWith(CONTENT_TYPE_PREFIX_TEXT)) {
                        int charsetAt = innerContentType.indexOf(59);
                        if (charsetAt == -1) {
                            if (CONTENT_TYPE_TEXT_PLAIN.equals(contentType)) continue block7;
                            throw new ProtocolDecoderException("Inconsistent HTTP content-type");
                        }
                        String charset = innerContentType.substring(charsetAt + 1);
                        if (!ASCII_COMPATIBLE.contains(charset.toLowerCase())) {
                            throw new ProtocolEncoderException("HTTP enveloping not compatible with charset: " + charset);
                        }
                        if (String.format("%s;%s", CONTENT_TYPE_TEXT_PLAIN, charset).equals(contentType)) continue block7;
                        throw new ProtocolDecoderException("Inconsistent HTTP content-type");
                    }
                    if (innerContentType.equals(contentType)) continue block7;
                    throw new ProtocolDecoderException("Inconsistent HTTP content-type");
                }
                case 'W': 
                case 'w': {
                    if (!"WWW-Authenticate".equalsIgnoreCase(readHeaderName)) break;
                    continue block7;
                }
            }
            String readHeaderValue = session.getReadHeader(readHeaderName);
            httpResponse.setHeader(readHeaderName, readHeaderValue);
        }
        for (HttpCookie readCookie : session.getReadCookies()) {
            httpResponse.addCookie(readCookie);
        }
        nextFilter.messageReceived((IoSession)session, (Object)httpResponse);
    }

    private String calculateContentType(String contentType) throws ProtocolEncoderException {
        if (contentType == null) {
            return CONTENT_TYPE_TEXT_PLAIN_CHARSET_UTF_8;
        }
        if (contentType.startsWith(CONTENT_TYPE_PREFIX_TEXT)) {
            int charsetAt = contentType.indexOf(59);
            if (charsetAt != -1) {
                String charsetName = contentType.substring(charsetAt + 1).trim();
                if (!ASCII_COMPATIBLE.contains(charsetName.toLowerCase())) {
                    throw new ProtocolEncoderException("HTTP enveloping not compatible with charset: " + charsetName);
                }
                return String.format("%s;%s", CONTENT_TYPE_TEXT_PLAIN, charsetName);
            }
            return CONTENT_TYPE_TEXT_PLAIN;
        }
        return CONTENT_TYPE_APPLICATION_OCTET_STREAM;
    }

    static {
        TreeSet<String> restrictedEnvelopeHeaders = new TreeSet<String>(HttpHeaderNameComparator.INSTANCE);
        restrictedEnvelopeHeaders.addAll(Arrays.asList("Accept-Charset", "Accept-Encoding", "Access-Control-Request-Headers", "Access-Control-Request-Method", "Connection", "Cookie", "Cookie2", "Date", "DNT", "Expect", "Host", "Keep-Alive", "Origin", "Referer", "TE", "Trailer", "Transfer-Encoding", "Upgrade", "User-Agent", "Via"));
        RESTRICTED_ENVELOPE_HEADERS = restrictedEnvelopeHeaders;
        ASCII_COMPATIBLE = Arrays.asList("charset=ascii", "charset=utf-8", "charset=windows-1252");
    }

    private static enum Mode {
        CLIENT,
        SERVER;

    }
}

