/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.transport.http.bridge.filter;

import org.apache.mina.core.buffer.IoBuffer;
import org.apache.mina.filter.codec.ProtocolDecoderException;
import org.apache.mina.filter.codec.ProtocolDecoderOutput;
import org.apache.mina.filter.codec.statemachine.DecodingState;
import org.kaazing.gateway.transport.http.bridge.HttpContentMessage;
import org.kaazing.mina.core.buffer.IoBufferEx;

final class MaximumLengthDecodingState
implements DecodingState {
    private long remaining;

    MaximumLengthDecodingState(long maximumLength) {
        this.remaining = maximumLength;
    }

    public DecodingState decode(IoBuffer in, ProtocolDecoderOutput out) throws Exception {
        IoBufferEx inEx = (IoBufferEx)in;
        int length = inEx.remaining();
        if (this.remaining > (long)length) {
            this.remaining -= (long)length;
            IoBufferEx slice = inEx.getSlice(length);
            HttpContentMessage httpContent = new HttpContentMessage(slice, false);
            out.write((Object)httpContent);
            return this;
        }
        if (this.remaining > 0L) {
            int remainingAsInt = (int)this.remaining;
            IoBufferEx slice = inEx.getSlice(remainingAsInt);
            this.remaining = 0L;
            HttpContentMessage httpContent = new HttpContentMessage(slice, true);
            out.write((Object)httpContent);
            return this.finishDecode(out);
        }
        throw new ProtocolDecoderException("Content length exceeded: " + in.getHexDump());
    }

    public DecodingState finishDecode(ProtocolDecoderOutput out) throws Exception {
        return null;
    }
}

