/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.transport.http.resource;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentHashMap;
import org.kaazing.gateway.transport.http.resource.HttpDynamicResource;
import org.kaazing.gateway.transport.http.resource.HttpDynamicResourceFactorySpi;

public abstract class HttpDynamicResourceFactory {
    public static HttpDynamicResourceFactory newHttpDynamicResourceFactory() {
        return HttpDynamicResourceFactory.newHttpDynamicResourceFactory(Thread.currentThread().getContextClassLoader());
    }

    public static HttpDynamicResourceFactory newHttpDynamicResourceFactory(ClassLoader classLoader) {
        ServiceLoader<HttpDynamicResourceFactorySpi> loader = HttpDynamicResourceFactory.loadHttpDynamicResourceFactorySpi(classLoader);
        ConcurrentHashMap<String, HttpDynamicResourceFactorySpi> dynamicResourceFactories = new ConcurrentHashMap<String, HttpDynamicResourceFactorySpi>();
        for (HttpDynamicResourceFactorySpi dynamicResourceFactorySpi : loader) {
            Collection<String> resourceNames = dynamicResourceFactorySpi.getResourceNames();
            for (String resourceName : resourceNames) {
                HttpDynamicResourceFactorySpi oldDynamicResourceFactorySpi = dynamicResourceFactories.putIfAbsent(resourceName, dynamicResourceFactorySpi);
                if (oldDynamicResourceFactorySpi == null) continue;
                throw new RuntimeException(String.format("Duplicate resouce name dynamic resource factory: %s", resourceName));
            }
        }
        return new HttpDynamicResourceFactoryImpl(dynamicResourceFactories);
    }

    public abstract Collection<String> getResourceNames();

    public abstract HttpDynamicResource newHttpDynamicResource(String var1);

    private HttpDynamicResourceFactory() {
    }

    private static ServiceLoader<HttpDynamicResourceFactorySpi> loadHttpDynamicResourceFactorySpi(ClassLoader classLoader) {
        Class<HttpDynamicResourceFactorySpi> service = HttpDynamicResourceFactorySpi.class;
        return classLoader != null ? ServiceLoader.load(service, classLoader) : ServiceLoader.load(service);
    }

    private static final class HttpDynamicResourceFactoryImpl
    extends HttpDynamicResourceFactory {
        private final Map<String, HttpDynamicResourceFactorySpi> dynamicResourceFactories;

        @Override
        public Collection<String> getResourceNames() {
            return this.dynamicResourceFactories.keySet();
        }

        @Override
        public HttpDynamicResource newHttpDynamicResource(String resourceName) {
            HttpDynamicResourceFactorySpi dynamicResourceFactory = this.findDynamicResourceFactorySpi(resourceName);
            return dynamicResourceFactory.newDynamicResource(resourceName);
        }

        private HttpDynamicResourceFactoryImpl(Map<String, HttpDynamicResourceFactorySpi> dynamicResourceFactories) {
            this.dynamicResourceFactories = Collections.unmodifiableMap(dynamicResourceFactories);
        }

        private HttpDynamicResourceFactorySpi findDynamicResourceFactorySpi(String resourceName) {
            if (resourceName == null) {
                throw new NullPointerException("resourceName");
            }
            HttpDynamicResourceFactorySpi dynanmicResourceFactory = this.dynamicResourceFactories.get(resourceName);
            if (dynanmicResourceFactory == null) {
                throw new IllegalArgumentException(String.format("Unable to load resource '%s': No appropriate dynamic resource factory found", resourceName));
            }
            return dynanmicResourceFactory;
        }
    }
}

