/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.transport.http.resource.impl;

import java.io.IOException;
import java.net.URI;
import java.net.URLEncoder;
import java.nio.ByteBuffer;
import java.nio.charset.CharsetEncoder;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import org.apache.mina.core.future.WriteFuture;
import org.jboss.netty.util.CharsetUtil;
import org.kaazing.gateway.resource.address.ResourceAddress;
import org.kaazing.gateway.resource.address.http.GatewayHttpOriginSecurity;
import org.kaazing.gateway.resource.address.http.HttpResourceAddress;
import org.kaazing.gateway.resource.address.uri.URIUtils;
import org.kaazing.gateway.security.CrossSiteConstraintContext;
import org.kaazing.gateway.transport.http.HttpAcceptSession;
import org.kaazing.gateway.transport.http.HttpStatus;
import org.kaazing.gateway.transport.http.resource.HttpDynamicResource;
import org.kaazing.mina.core.buffer.IoBufferAllocatorEx;
import org.kaazing.mina.core.buffer.IoBufferEx;
import org.kaazing.mina.netty.util.threadlocal.VicariousThreadLocal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HttpClientAccessPolicyXml
extends HttpDynamicResource {
    private static final URI NULL_ORIGIN = URI.create("null");
    private final ThreadLocal<ConcurrentMap<String, CachedResult>> cacheByAuthorityRef = new VicariousThreadLocal<ConcurrentMap<String, CachedResult>>(){

        protected ConcurrentMap<String, CachedResult> initialValue() {
            return new ConcurrentHashMap<String, CachedResult>();
        }
    };
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpClientAccessPolicyXml.class);

    @Override
    public void writeFile(HttpAcceptSession httpSession) throws IOException {
        CharsetEncoder utf8Encoder = CharsetUtil.UTF_8.newEncoder();
        ResourceAddress localAddress = httpSession.getLocalAddress();
        URI requestURI = localAddress.getResource();
        String requestAuthority = requestURI.getAuthority();
        ConcurrentMap<String, CachedResult> cacheByAuthority = this.cacheByAuthorityRef.get();
        CachedResult cache = (CachedResult)cacheByAuthority.get(requestAuthority);
        if (cache != null) {
            cache.writeFile(httpSession);
            return;
        }
        GatewayHttpOriginSecurity gatewayHttpOriginSecurity = (GatewayHttpOriginSecurity)localAddress.getOption(HttpResourceAddress.GATEWAY_ORIGIN_SECURITY);
        List listOfAcceptConstraintsByURI = gatewayHttpOriginSecurity.getAuthorityToSetOfAcceptConstraintsByURI();
        Integer minimumMaximumAge = null;
        IoBufferAllocatorEx bufferAllocator = httpSession.getBufferAllocator();
        IoBufferEx buf = bufferAllocator.wrap(ByteBuffer.allocate(10240), 2).setAutoExpander(bufferAllocator);
        buf.putString((CharSequence)"<?xml version=\"1.0\" encoding=\"utf-8\"?>\n", utf8Encoder);
        buf.putString((CharSequence)"<access-policy>\n", utf8Encoder);
        buf.putString((CharSequence)"<cross-domain-access>\n", utf8Encoder);
        boolean createdPolicy = false;
        HashSet<String> alreadyVisited = new HashSet<String>();
        for (Map servicesAcceptsToCrossSiteConstraints : listOfAcceptConstraintsByURI) {
            for (Map.Entry acceptToConstraints : servicesAcceptsToCrossSiteConstraints.entrySet()) {
                String acceptURI = (String)acceptToConstraints.getKey();
                if (!URIUtils.getAuthority((String)acceptURI).equals(requestAuthority)) continue;
                for (Map.Entry urlToConstraint : ((Map)acceptToConstraints.getValue()).entrySet()) {
                    String allowMethods;
                    String allowOrigin;
                    String allowHeaders;
                    CrossSiteConstraintContext constraint = (CrossSiteConstraintContext)urlToConstraint.getValue();
                    String urlOfConstraint = (String)urlToConstraint.getKey();
                    if (urlOfConstraint.equals(requestURI.toString())) continue;
                    Integer maximumAge = constraint.getMaximumAge();
                    if (maximumAge != null) {
                        minimumMaximumAge = minimumMaximumAge == null ? maximumAge : Integer.valueOf(Math.min(maximumAge, minimumMaximumAge));
                    }
                    String acceptURIPath = URIUtils.getPath((String)acceptURI);
                    String sourceOrigin = constraint.getAllowOrigin();
                    String idString = String.format("%s%s%s%s%s", sourceOrigin, allowHeaders = constraint.getAllowHeaders(), allowOrigin = constraint.getAllowOrigin(), allowMethods = constraint.getAllowMethods(), acceptURIPath);
                    if (alreadyVisited.contains(idString)) continue;
                    alreadyVisited.add(idString);
                    createdPolicy = true;
                    buf.putString((CharSequence)"<policy>\n", utf8Encoder);
                    buf.putString((CharSequence)"<allow-from http-request-headers=\"", utf8Encoder);
                    buf.putString((CharSequence)"Authorization,", utf8Encoder);
                    buf.putString((CharSequence)"X-WebSocket-Extensions,", utf8Encoder);
                    buf.putString((CharSequence)"X-WebSocket-Version,", utf8Encoder);
                    buf.putString((CharSequence)"X-Origin,", utf8Encoder);
                    buf.putString((CharSequence)"X-Accept-Commands,", utf8Encoder);
                    buf.putString((CharSequence)"X-Sequence-No,", utf8Encoder);
                    URI sourceOriginURI = "*".equals(sourceOrigin) ? NULL_ORIGIN : URI.create(URLEncoder.encode(sourceOrigin, "UTF-8"));
                    String originHeader = String.format("X-Origin-%s", sourceOriginURI.toASCIIString());
                    buf.putString((CharSequence)originHeader, utf8Encoder);
                    if (allowHeaders != null) {
                        buf.putString((CharSequence)("," + allowHeaders), utf8Encoder);
                    }
                    buf.putString((CharSequence)"\">\n", utf8Encoder);
                    if ("*".equals(allowOrigin)) {
                        buf.putString((CharSequence)"<domain uri=\"http://*\"/>\n", utf8Encoder);
                        buf.putString((CharSequence)"<domain uri=\"https://*\"/>\n", utf8Encoder);
                        buf.putString((CharSequence)"<domain uri=\"file:///\"/>\n", utf8Encoder);
                    } else {
                        buf.putString((CharSequence)("<domain uri=\"" + allowOrigin + "\"/>\n"), utf8Encoder);
                    }
                    buf.putString((CharSequence)"</allow-from>\n", utf8Encoder);
                    buf.putString((CharSequence)"<grant-to>\n", utf8Encoder);
                    if (allowMethods != null) {
                        String[] allowedMethods;
                        for (String allowedMethod : allowedMethods = allowMethods.toLowerCase().split(",")) {
                            buf.putString((CharSequence)("<resource path=\"/;" + allowedMethod), utf8Encoder);
                            buf.putString((CharSequence)acceptURIPath, utf8Encoder);
                            buf.putString((CharSequence)"\" include-subpaths=\"true\"/>\n", utf8Encoder);
                        }
                    }
                    buf.putString((CharSequence)"</grant-to>\n", utf8Encoder);
                    buf.putString((CharSequence)"</policy>\n", utf8Encoder);
                }
            }
        }
        buf.putString((CharSequence)"</cross-domain-access>\n", utf8Encoder);
        buf.putString((CharSequence)"</access-policy>\n", utf8Encoder);
        buf.flip();
        if (createdPolicy) {
            if (minimumMaximumAge != null) {
                httpSession.setWriteHeader("Max-Age", String.valueOf(minimumMaximumAge));
            }
            httpSession.setWriteHeader("Content-Length", String.valueOf(buf.remaining()));
            ValidResult candidateResult = new ValidResult(minimumMaximumAge, buf);
            CachedResult result = cacheByAuthority.putIfAbsent(requestAuthority, candidateResult);
            if (result == null) {
                result = candidateResult;
            }
            result.writeFile(httpSession);
        } else {
            cacheByAuthority.put(requestAuthority, new InvalidResult());
            httpSession.setStatus(HttpStatus.CLIENT_NOT_FOUND);
            httpSession.close(true);
        }
    }

    private static class InvalidResult
    implements CachedResult {
        private InvalidResult() {
        }

        @Override
        public void writeFile(HttpAcceptSession httpSession) {
            httpSession.setStatus(HttpStatus.CLIENT_NOT_FOUND);
            httpSession.close(true);
        }
    }

    private static class ValidResult
    implements CachedResult {
        private final IoBufferEx result;
        private final Integer maxAge;

        public ValidResult(Integer maxAge, IoBufferEx result) {
            this.maxAge = maxAge;
            this.result = result;
        }

        @Override
        public void writeFile(HttpAcceptSession httpSession) {
            block3: {
                if (this.maxAge != null) {
                    httpSession.setWriteHeader("Max-Age", String.valueOf(this.maxAge));
                }
                httpSession.setWriteHeader("Content-Length", String.valueOf(this.result.remaining()));
                WriteFuture f = httpSession.write(this.result.duplicate());
                try {
                    f.await(10L, TimeUnit.SECONDS);
                }
                catch (InterruptedException e) {
                    if (!LOGGER.isWarnEnabled()) break block3;
                    LOGGER.warn(String.format("Write future in %s never fired", HttpClientAccessPolicyXml.class));
                }
            }
            httpSession.close(true);
        }
    }

    private static interface CachedResult {
        public void writeFile(HttpAcceptSession var1);
    }
}

