/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.transport.http.resource.impl;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import org.kaazing.gateway.resource.address.ResourceAddress;
import org.kaazing.gateway.resource.address.http.HttpResourceAddress;
import org.kaazing.gateway.transport.http.HttpAcceptSession;
import org.kaazing.gateway.transport.http.HttpUtils;
import org.kaazing.gateway.transport.http.resource.HttpDynamicResource;
import org.kaazing.gateway.util.file.FileUtils;

public final class HttpInjectedDynamicResource
extends HttpDynamicResource {
    private static final Map<String, String> EMPTY_WRITE_HEADERS = Collections.emptyMap();
    private final long startTime;
    private final String resourcePath;
    private final Map<String, String> writeHeaders;

    @Override
    public void writeFile(HttpAcceptSession httpSession) throws IOException {
        File cacheFile;
        File bridgeFile;
        String contentType;
        if (!this.writeHeaders.isEmpty()) {
            for (String headerName : this.writeHeaders.keySet()) {
                String headerValue = this.writeHeaders.get(headerName);
                httpSession.addWriteHeader(headerName, headerValue);
            }
        }
        ResourceAddress localAddress = httpSession.getLocalAddress();
        File cacheDirectory = (File)localAddress.getOption(HttpResourceAddress.TEMP_DIRECTORY);
        String resolvedResourcePath = this.resourcePath;
        if (this.resourcePath.endsWith(".js")) {
            resolvedResourcePath = this.resourcePath.replaceFirst("\\.js$", ".html");
        }
        if ((contentType = HttpInjectedDynamicResource.getContentType(FileUtils.getFileExtension((File)(bridgeFile = this.supplyAsFile(cacheFile = new File(cacheDirectory, resolvedResourcePath), this.startTime))))) != null) {
            httpSession.setWriteHeader("Content-Type", contentType);
        }
        HttpUtils.writeIfModified(httpSession, bridgeFile);
    }

    HttpInjectedDynamicResource(String resourcePath) {
        this(resourcePath, EMPTY_WRITE_HEADERS);
    }

    HttpInjectedDynamicResource(String resourcePath, Map<String, String> writeHeaders) {
        this.resourcePath = resourcePath;
        this.writeHeaders = writeHeaders;
        this.startTime = System.currentTimeMillis();
    }

    private File supplyAsFile(File tempFile, long startTime) throws IOException {
        if (this.resourcePath.endsWith(".js")) {
            HttpUtils.supplyScriptAsHtml(tempFile, startTime, this.resourcePath);
        } else {
            HttpUtils.supplyFile(tempFile, startTime, this.resourcePath);
        }
        return tempFile;
    }

    private static String getContentType(String fileExtension) {
        if (fileExtension == null) {
            return null;
        }
        String contentType = null;
        if ("html".equals(fileExtension = fileExtension.toLowerCase())) {
            contentType = "text/html";
        } else if ("htm".equals(fileExtension)) {
            contentType = "text/html";
        } else if ("jar".equals(fileExtension)) {
            contentType = "application/java-archive";
        } else if ("js".equals(fileExtension)) {
            contentType = "text/javascript";
        } else if ("png".equals(fileExtension)) {
            contentType = "image/png";
        } else if ("gif".equals(fileExtension)) {
            contentType = "image/gif";
        } else if ("jpg".equals(fileExtension)) {
            contentType = "image/jpeg";
        } else if ("jpeg".equals(fileExtension)) {
            contentType = "image/jpeg";
        } else if ("css".equals(fileExtension)) {
            contentType = "text/css";
        } else if ("swf".equals(fileExtension)) {
            contentType = "application/x-shockwave-flash";
        } else if ("xap".equals(fileExtension)) {
            contentType = "application/x-silverlight-app";
        } else if ("htc".equals(fileExtension)) {
            contentType = "text/x-component";
        } else if ("jnlp".equals(fileExtension)) {
            contentType = "application/x-java-jnlp-file";
        } else if ("manifest".equals(fileExtension)) {
            contentType = "text/cache-manifest";
        } else if ("appcache".equals(fileExtension)) {
            contentType = "text/cache-manifest";
        } else if ("vtt".equals(fileExtension)) {
            contentType = "text/vtt";
        } else if ("aspx".equals(fileExtension)) {
            contentType = "text/html";
        } else if ("apk".equals(fileExtension)) {
            contentType = "application/vnd.android.package-archive";
        }
        return contentType;
    }
}

