/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.transport.http.resource.impl;

import java.io.InputStream;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.kaazing.gateway.transport.http.resource.HttpDynamicResource;
import org.kaazing.gateway.transport.http.resource.HttpDynamicResourceFactorySpi;
import org.kaazing.gateway.transport.http.resource.impl.HttpInjectedDynamicResource;

public final class HttpInjectedDynamicResourceFactorySpi
extends HttpDynamicResourceFactorySpi {
    private static final String CROSS_ORIGIN_POSTMESSAGE_CHILD = "xsc";
    private static final String CROSS_ORIGIN_POSTMESSAGE_PARENT = "xsp";
    private final Map<String, HttpDynamicResource> resourcesByName;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpInjectedDynamicResourceFactorySpi() {
        HashMap<String, HttpInjectedDynamicResource> resourcesByName = new HashMap<String, HttpInjectedDynamicResource>();
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        try {
            String resourcesPath = "META-INF/services/org/kaazing/gateway/server/resources";
            Enumeration<URL> resources = classLoader.getResources(resourcesPath);
            while (resources.hasMoreElements()) {
                URL resource = resources.nextElement();
                Properties properties = new Properties();
                try (InputStream stream = resource.openStream();){
                    properties.load(stream);
                    for (String resourceName : properties.stringPropertyNames()) {
                        String resourcePath = properties.getProperty(resourceName);
                        if (CROSS_ORIGIN_POSTMESSAGE_PARENT.equals(resourceName) || CROSS_ORIGIN_POSTMESSAGE_CHILD.equals(resourceName)) {
                            Map<String, String> writeHeaders = Collections.singletonMap("Cache-control", "private, must-revalidate");
                            resourcesByName.put(resourceName, new HttpInjectedDynamicResource(resourcePath, writeHeaders));
                            continue;
                        }
                        resourcesByName.put(resourceName, new HttpInjectedDynamicResource(resourcePath));
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.resourcesByName = Collections.unmodifiableMap(resourcesByName);
    }

    @Override
    public Collection<String> getResourceNames() {
        return this.resourcesByName.keySet();
    }

    @Override
    public HttpDynamicResource newDynamicResource(String resourceName) {
        return this.resourcesByName.get(resourceName);
    }
}

