/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.transport.http.security.auth;

import java.net.PasswordAuthentication;
import java.util.Arrays;
import java.util.Base64;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class WWWAuthChallenge {
    static final String TYPE_GROUP_NAME = "scheme";
    static final String REALM_GROUP_NAME = "realm";
    static final Pattern SCHEME_PATTERN = Pattern.compile(String.format("(?<%s>[a-zA-Z_]+) realm=\"(?<%s>[^\"]+)\".*", "scheme", "realm"));
    protected static final String[] SUPPORTED_SCHEMES = new String[]{"basic", "digest"};
    private final String challenge;
    private final String realm;
    private final String type;

    public WWWAuthChallenge(String challenge) {
        this.challenge = challenge;
        Matcher matcher = SCHEME_PATTERN.matcher(challenge);
        matcher.matches();
        this.realm = matcher.group(REALM_GROUP_NAME);
        this.type = matcher.group(TYPE_GROUP_NAME);
    }

    public String getChallenge() {
        return this.challenge;
    }

    public String getRealm() {
        return this.realm;
    }

    public String getScheme() {
        return this.type;
    }

    public static String[] getSupportedSchemes() {
        return SUPPORTED_SCHEMES;
    }

    public static String encodeAuthorizationHeader(String scheme, PasswordAuthentication value) {
        if (value == null) {
            return null;
        }
        if ("basic".equalsIgnoreCase(scheme)) {
            char[] pwd = value.getPassword();
            String encodedBytes = Base64.getEncoder().encodeToString((value.getUserName() + ":" + new String(pwd)).getBytes());
            Arrays.fill(pwd, ' ');
            return "Basic " + encodedBytes;
        }
        return null;
    }
}

