/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.transport.http.security.auth.challenge;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.kaazing.gateway.resource.address.http.HttpRealmInfo;
import org.kaazing.gateway.transport.http.bridge.HttpRequestMessage;
import org.kaazing.gateway.transport.http.bridge.HttpResponseMessage;
import org.kaazing.gateway.transport.http.security.auth.challenge.HttpChallengeFactory;

public class DispatchHttpChallengeFactory
implements HttpChallengeFactory {
    public static Map<String, HttpChallengeFactory> challengeFactoriesByAuthScheme = new ConcurrentHashMap<String, HttpChallengeFactory>(5);

    public static void clear() {
        challengeFactoriesByAuthScheme = new ConcurrentHashMap<String, HttpChallengeFactory>(5);
    }

    public void register(String authScheme, HttpChallengeFactory factory) {
        if (authScheme == null) {
            throw new NullPointerException("authScheme");
        }
        if (factory == null) {
            throw new NullPointerException("factory");
        }
        challengeFactoriesByAuthScheme.put(authScheme, factory);
    }

    @Override
    public HttpResponseMessage createChallenge(HttpRequestMessage httpRequestMessage, HttpRealmInfo realm, Object ... params) {
        if (httpRequestMessage == null || httpRequestMessage.getLocalAddress() == null) {
            throw new NullPointerException("Cannot issue challenge; httpRequestMessage not provided.");
        }
        String authScheme = realm.getChallengeScheme();
        HttpChallengeFactory factory = this.lookup(authScheme);
        if (factory == null) {
            throw new IllegalStateException("Cannot issue a challenge for authentication scheme: " + authScheme);
        }
        return factory.createChallenge(httpRequestMessage, realm, params);
    }

    public HttpChallengeFactory lookup(String authScheme) {
        if (authScheme == null) {
            return null;
        }
        HttpChallengeFactory result = challengeFactoriesByAuthScheme.get(authScheme);
        if (result == null) {
            if (authScheme.startsWith("Application ")) {
                authScheme = authScheme.replaceFirst("Application ", "");
            }
            result = challengeFactoriesByAuthScheme.get(authScheme);
        }
        return result;
    }
}

