/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.transport.http.security.auth.challenge;

import org.kaazing.gateway.resource.address.ResourceAddress;
import org.kaazing.gateway.resource.address.http.HttpRealmInfo;
import org.kaazing.gateway.transport.http.HttpStatus;
import org.kaazing.gateway.transport.http.bridge.HttpRequestMessage;
import org.kaazing.gateway.transport.http.bridge.HttpResponseMessage;
import org.kaazing.gateway.transport.http.security.auth.challenge.HttpChallengeFactory;

public abstract class HttpChallengeFactoryAdapter
implements HttpChallengeFactory {
    @Deprecated
    protected boolean isApplication(String authScheme) {
        return authScheme != null && authScheme.startsWith("Application ");
    }

    @Override
    public HttpResponseMessage createChallenge(HttpRequestMessage httpRequestMessage, HttpRealmInfo realm, Object ... params) {
        return this.createChallenge0(httpRequestMessage, realm, params);
    }

    private HttpResponseMessage createChallenge0(HttpRequestMessage httpRequestMessage, HttpRealmInfo realm, Object ... params) {
        HttpResponseMessage httpResponse = new HttpResponseMessage();
        httpResponse.setVersion(httpRequestMessage.getVersion());
        httpResponse.setStatus(HttpStatus.CLIENT_UNAUTHORIZED);
        String challenge = this.makeChallengeString(httpRequestMessage.getLocalAddress(), realm, params);
        httpResponse.setHeader("WWW-Authenticate", challenge);
        return httpResponse;
    }

    protected abstract String getAuthenticationScheme();

    protected String makeChallengeString(ResourceAddress address, HttpRealmInfo realm, Object ... params) {
        StringBuilder builder = new StringBuilder();
        String challengeScheme = realm.getChallengeScheme();
        if (this.isApplication(challengeScheme) && (address.getOption(ResourceAddress.NEXT_PROTOCOL) != null || !"http/1.1".equals(address.getTransport().getOption(ResourceAddress.NEXT_PROTOCOL)))) {
            builder.append("Application ");
        }
        builder.append(this.getAuthenticationScheme()).append(" realm=\"").append(realm.getDescription()).append("\"");
        if (params != null) {
            for (Object obj : params) {
                builder.append(" ").append(obj);
            }
        }
        return builder.toString();
    }
}

