/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.transport.http.security.auth.challenge;

import java.net.URI;
import org.kaazing.gateway.resource.address.ResourceAddress;
import org.kaazing.gateway.resource.address.http.HttpRealmInfo;
import org.kaazing.gateway.resource.address.http.HttpResourceAddress;
import org.kaazing.gateway.transport.http.security.auth.challenge.HttpChallengeFactoryAdapter;

public class NegotiateHttpChallengeFactory
extends HttpChallengeFactoryAdapter {
    @Override
    protected String getAuthenticationScheme() {
        return "Negotiate";
    }

    @Override
    protected String makeChallengeString(ResourceAddress address, HttpRealmInfo realm, Object ... params) {
        String challengeScheme = realm.getChallengeScheme();
        boolean application = this.isApplication(challengeScheme);
        String authConnectValue = (String)address.getOption(HttpResourceAddress.AUTHENTICATION_CONNECT);
        URI authConnect = authConnectValue == null ? null : URI.create(authConnectValue);
        String authIdentifier = (String)address.getOption(HttpResourceAddress.AUTHENTICATION_IDENTIFIER);
        StringBuilder builder = new StringBuilder();
        if (application) {
            builder.append("Application ");
        }
        builder.append(this.getAuthenticationScheme());
        String gssData = null;
        if (params != null && params.length == 1) {
            gssData = (String)params[0];
        }
        if (gssData != null) {
            builder.append(' ').append(gssData);
        } else if (application && authConnect != null) {
            builder.append(' ').append(authConnect);
            if (authIdentifier != null) {
                builder.append(' ').append(authIdentifier);
            }
        }
        return builder.toString();
    }
}

