/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.transport.http.security.auth.token;

import java.io.UnsupportedEncodingException;
import java.util.Set;
import org.kaazing.gateway.resource.address.http.HttpRealmInfo;
import org.kaazing.gateway.security.auth.token.DefaultAuthenticationToken;
import org.kaazing.gateway.server.spi.security.AuthenticationToken;
import org.kaazing.gateway.transport.http.HttpCookie;
import org.kaazing.gateway.transport.http.bridge.HttpRequestMessage;
import org.kaazing.gateway.transport.http.security.auth.token.AuthenticationTokenExtractor;

public class AbstractAuthenticationTokenExtractor
implements AuthenticationTokenExtractor {
    @Override
    public AuthenticationToken extract(HttpRequestMessage httpRequest, HttpRealmInfo realm) throws UnsupportedEncodingException {
        DefaultAuthenticationToken result = new DefaultAuthenticationToken();
        this.extractAuthorizationHeader(httpRequest, result);
        String[] httpHeaders = realm.getHeaderNames();
        String[] httpQueryParameters = realm.getParameterNames();
        String[] httpCookieNames = realm.getAuthenticationCookieNames();
        if (httpHeaders != null && httpHeaders.length > 0) {
            this.extractHttpHeaders(httpRequest, httpHeaders, result);
        }
        if (httpQueryParameters != null && httpQueryParameters.length > 0) {
            this.extractQueryParameters(httpRequest, httpQueryParameters, result);
        }
        if (httpCookieNames != null && httpCookieNames.length > 0) {
            this.extractCookies(httpRequest, httpCookieNames, result);
        }
        return result;
    }

    protected void extractHttpHeaders(HttpRequestMessage httpRequest, String[] httpHeaders, DefaultAuthenticationToken result) {
        for (String headerName : httpHeaders) {
            String value = httpRequest.getHeader(headerName);
            if (value == null) continue;
            if (result.get(headerName) != null) {
                throw new IllegalStateException("Cannot authenticate with multiple http header values for header name \"" + headerName + "\"");
            }
            result.add(headerName, value);
        }
    }

    protected void extractQueryParameters(HttpRequestMessage httpRequest, String[] httpQueryParameters, DefaultAuthenticationToken result) {
        for (String parameterName : httpQueryParameters) {
            String value = httpRequest.getParameter(parameterName);
            if (value == null) continue;
            if (result.get(parameterName) != null) {
                throw new IllegalStateException("Cannot authenticate with multiple http parameter values for parameter name \"" + parameterName + "\"");
            }
            result.add(parameterName, value);
        }
    }

    protected void extractCookies(HttpRequestMessage httpRequest, String[] httpCookieNames, DefaultAuthenticationToken result) {
        for (String cookieName : httpCookieNames) {
            Set<HttpCookie> cookies = httpRequest.getCookies();
            if (cookies == null) continue;
            for (HttpCookie cookie : cookies) {
                String value;
                if (cookieName == null || !cookieName.equals(cookie.getName()) || (value = cookie.getValue()) == null) continue;
                if (result.get(cookieName) != null) {
                    throw new IllegalStateException("Cannot authenticate with multiple http cookie values for cookie name \"" + cookieName + "\"");
                }
                result.add(cookieName, value);
            }
        }
    }

    private void extractAuthorizationHeader(HttpRequestMessage httpRequest, DefaultAuthenticationToken result) {
        if (httpRequest.hasHeader("Authorization")) {
            String authorization = httpRequest.getHeader("Authorization").trim();
            int idx = -1;
            for (int i = 0; i < authorization.length(); ++i) {
                if (!Character.isWhitespace(authorization.charAt(i))) continue;
                idx = i;
                break;
            }
            if (idx == -1) {
                result.setScheme(authorization);
            } else {
                String scheme = authorization.substring(0, idx);
                authorization = authorization.substring(idx + 1);
                result.setScheme(scheme);
                if (authorization.length() > 0) {
                    result.add(authorization);
                }
            }
        }
    }
}

