/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.transport.ssl;

import java.io.IOException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import javax.annotation.Resource;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import org.apache.mina.core.filterchain.IoFilter;
import org.apache.mina.core.filterchain.IoFilterChain;
import org.apache.mina.core.future.ConnectFuture;
import org.apache.mina.core.future.DefaultConnectFuture;
import org.apache.mina.core.future.IoFuture;
import org.apache.mina.core.future.IoFutureListener;
import org.apache.mina.core.service.IoHandler;
import org.apache.mina.core.service.TransportMetadata;
import org.apache.mina.core.session.IdleStatus;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.core.session.IoSessionInitializer;
import org.apache.mina.filter.ssl.SslContextFactory;
import org.kaazing.gateway.resource.address.ResourceAddress;
import org.kaazing.gateway.resource.address.ResourceAddressFactory;
import org.kaazing.gateway.resource.address.ssl.SslResourceAddress;
import org.kaazing.gateway.security.KeySelector;
import org.kaazing.gateway.security.SecurityContext;
import org.kaazing.gateway.transport.AbstractBridgeConnector;
import org.kaazing.gateway.transport.AbstractBridgeSession;
import org.kaazing.gateway.transport.BridgeConnector;
import org.kaazing.gateway.transport.BridgeServiceFactory;
import org.kaazing.gateway.transport.BridgeSession;
import org.kaazing.gateway.transport.BridgeSessionInitializerAdapter;
import org.kaazing.gateway.transport.DefaultIoSessionConfigEx;
import org.kaazing.gateway.transport.DefaultTransportMetadata;
import org.kaazing.gateway.transport.ExceptionLoggingFilter;
import org.kaazing.gateway.transport.IoHandlerAdapter;
import org.kaazing.gateway.transport.ObjectLoggingFilter;
import org.kaazing.gateway.transport.TransportKeySelector;
import org.kaazing.gateway.transport.TypedAttributeKey;
import org.kaazing.gateway.transport.ssl.SslAcceptor;
import org.kaazing.gateway.transport.ssl.SslConnectProcessor;
import org.kaazing.gateway.transport.ssl.SslProvider;
import org.kaazing.gateway.transport.ssl.SslSession;
import org.kaazing.gateway.transport.ssl.bridge.filter.SslCertificateSelectionFilter;
import org.kaazing.gateway.transport.ssl.bridge.filter.SslFilter;
import org.kaazing.gateway.transport.ssl.cert.VirtualHostKeySelector;
import org.kaazing.gateway.util.ssl.SslCipherSuites;
import org.kaazing.mina.core.service.IoProcessorEx;
import org.kaazing.mina.core.service.IoServiceEx;
import org.kaazing.mina.core.session.IoSessionConfigEx;
import org.kaazing.mina.core.session.IoSessionEx;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SslConnector
extends AbstractBridgeConnector<SslSession> {
    private static final TypedAttributeKey<Callable<SslSession>> SSL_SESSION_FACTORY_KEY = new TypedAttributeKey(SslConnector.class, "sslSessionFactory");
    private static final TypedAttributeKey<ConnectFuture> SSL_CONNECT_FUTURE_KEY = new TypedAttributeKey(SslConnector.class, "sslConnectFuture");
    private static final TypedAttributeKey<SslSession> SSL_SESSION_KEY = new TypedAttributeKey(SslConnector.class, "sslSession");
    private static final String CODEC_FILTER = "ssl#codec";
    private static final String CERTIFICATE_SELECTION_FILTER = "ssl#certificate_selection";
    private static final String FAULT_LOGGING_FILTER = "ssl#fault";
    private static final String TRACE_LOGGING_FILTER = "ssl#logging";
    private static final String LOGGER_NAME = String.format("transport.%s.connect", "ssl");
    private final Logger logger = LoggerFactory.getLogger((String)LOGGER_NAME);
    private BridgeServiceFactory bridgeServiceFactory;
    private SslContextFactory sslContextFactory;
    private SSLContext sslContext;
    private SslCertificateSelectionFilter certificateSelection;
    private ResourceAddressFactory resourceAddressFactory;
    private VirtualHostKeySelector vhostKeySelector;
    private IoHandler bridgeHandler = new IoHandlerAdapter<IoSessionEx>(){

        protected void doSessionOpened(IoSessionEx session) throws Exception {
            session.setAttribute((Object)SslFilter.USE_NOTIFICATION);
            IoFilterChain filterChain = session.getFilterChain();
            SslConnector.this.addBridgeFilters(filterChain);
        }

        protected void doSessionClosed(IoSessionEx session) throws Exception {
            SslSession sslSession;
            if (!session.isClosing()) {
                IoFilterChain filterChain = session.getFilterChain();
                SslConnector.this.removeBridgeFilters(filterChain);
            }
            if ((sslSession = (SslSession)((Object)SSL_SESSION_KEY.get((IoSession)session))) != null) {
                if (!sslSession.isClosing()) {
                    sslSession.reset(new IOException("Early termination of IO session").fillInStackTrace());
                }
            } else {
                ConnectFuture sslConnectFuture = (ConnectFuture)SSL_CONNECT_FUTURE_KEY.remove((IoSession)session);
                if (sslConnectFuture != null) {
                    sslConnectFuture.setException((Throwable)new Exception("SSL connection failed"));
                }
            }
        }

        protected void doMessageReceived(IoSessionEx session, Object message) throws Exception {
            if (message == SslFilter.SESSION_SECURED) {
                IoFilterChain filterChain = session.getFilterChain();
                SslConnector.this.removeFilter(filterChain, (IoFilter)SslConnector.this.certificateSelection);
                Callable sessionFactory = (Callable)SSL_SESSION_FACTORY_KEY.get((IoSession)session);
                SslSession sslSession = (SslSession)((Object)sessionFactory.call());
                session.setAttribute((Object)SSL_SESSION_KEY, (Object)sslSession);
            } else if (message == SslFilter.SESSION_UNSECURED) {
                SslSession sslSession = (SslSession)((Object)SSL_SESSION_KEY.get((IoSession)session));
                sslSession.close(false);
            } else {
                SslSession sslSession = (SslSession)((Object)SSL_SESSION_KEY.get((IoSession)session));
                IoFilterChain filterChain = sslSession.getFilterChain();
                filterChain.fireMessageReceived(message);
            }
        }

        protected void doExceptionCaught(IoSessionEx session, Throwable cause) throws Exception {
            if (SslConnector.this.logger.isDebugEnabled()) {
                String message = String.format("Error on SSL connection attempt: %s", cause);
                if (SslConnector.this.logger.isTraceEnabled()) {
                    SslConnector.this.logger.debug(message, cause);
                } else {
                    SslConnector.this.logger.debug(message);
                }
            }
            session.close(true);
            ConnectFuture sslConnectFuture = (ConnectFuture)SSL_CONNECT_FUTURE_KEY.remove((IoSession)session);
            if (sslConnectFuture != null) {
                sslConnectFuture.setException(cause);
            }
        }

        protected void doSessionIdle(IoSessionEx session, IdleStatus status) throws Exception {
            IoSession bridgeSession = (IoSession)session.getAttribute((Object)SSL_SESSION_KEY);
            bridgeSession.getFilterChain().fireSessionIdle(status);
        }
    };

    public SslConnector() {
        super((IoSessionConfigEx)new DefaultIoSessionConfigEx());
    }

    @Resource(name="resourceAddressFactory")
    public void setResourceAddressFactory(ResourceAddressFactory resourceAddressFactory) {
        this.resourceAddressFactory = resourceAddressFactory;
    }

    @Resource(name="bridgeServiceFactory")
    public void setBridgeServiceFactory(BridgeServiceFactory bridgeServiceFactory) {
        this.bridgeServiceFactory = bridgeServiceFactory;
    }

    @Resource(name="securityContext")
    public void setSecurityContext(SecurityContext securityContext) {
        this.vhostKeySelector = new VirtualHostKeySelector();
        try {
            this.vhostKeySelector.init(securityContext.getKeyStore(), securityContext.getKeyStorePassword());
        }
        catch (KeyStoreException e) {
            throw new RuntimeException(e);
        }
        try {
            this.sslContextFactory = new SslContextFactory();
            this.sslContextFactory.setTrustManagerFactoryKeyStore(securityContext.getTrustStore());
            char[] keyStorePassword = securityContext.getKeyStorePassword();
            this.sslContextFactory.setKeyManagerFactoryKeyStorePassword(keyStorePassword == null ? null : new String(keyStorePassword));
            this.sslContextFactory.setKeyManagerFactoryKeyStore(securityContext.getKeyStore());
            KeyManagerFactory kmf = KeyManagerFactory.getInstance("SslTransport", new SslProvider());
            this.sslContextFactory.setKeyManagerFactory(kmf);
            this.sslContextFactory.setServerSessionCacheSize(1);
        }
        catch (NoSuchAlgorithmException ne) {
            throw new RuntimeException(ne);
        }
    }

    public TransportMetadata getTransportMetadata() {
        return new DefaultTransportMetadata("ssl");
    }

    protected void init() {
        super.init();
        try {
            this.sslContext = this.sslContextFactory.newInstance();
        }
        catch (Exception e) {
            this.logger.error("Exception while creating SSL context: ", (Throwable)e);
        }
        this.certificateSelection = new SslCertificateSelectionFilter(true);
    }

    protected IoProcessorEx<SslSession> initProcessor() {
        return new SslConnectProcessor();
    }

    public void addBridgeFilters(IoFilterChain filterChain) {
        if (this.logger.isTraceEnabled()) {
            filterChain.addFirst(TRACE_LOGGING_FILTER, (IoFilter)new ObjectLoggingFilter(this.logger, "ssl#%s"));
        } else if (this.logger.isDebugEnabled()) {
            filterChain.addFirst(FAULT_LOGGING_FILTER, (IoFilter)new ExceptionLoggingFilter(this.logger, "ssl#%s"));
        }
        IoSession session = filterChain.getSession();
        ResourceAddress address = (ResourceAddress)SslAcceptor.SSL_RESOURCE_ADDRESS.remove(session);
        if (address != null) {
            boolean encryption = (Boolean)address.getOption(SslResourceAddress.ENCRYPTION_ENABLED);
            if (encryption) {
                SslFilter sslFilter = new SslFilter(this.sslContext, true, this.logger);
                sslFilter.setUseClientMode(true);
                boolean wantClientAuth = (Boolean)address.getOption(SslResourceAddress.WANT_CLIENT_AUTH);
                boolean needClientAuth = (Boolean)address.getOption(SslResourceAddress.NEED_CLIENT_AUTH);
                List<String> unresolvedCipherNames = this.toCipherList((String[])address.getOption(SslResourceAddress.CIPHERS));
                List resolvedCipherNames = SslCipherSuites.resolve(unresolvedCipherNames);
                String[] enabledCipherSuites = resolvedCipherNames.toArray(new String[resolvedCipherNames.size()]);
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace(String.format("Configured SSL/TLS ciphersuites:\n  %s", this.toCipherString(this.toCipherList(enabledCipherSuites))));
                }
                sslFilter.setWantClientAuth(wantClientAuth);
                sslFilter.setNeedClientAuth(needClientAuth);
                sslFilter.setEnabledCipherSuites(enabledCipherSuites);
                sslFilter.setEnabledProtocols((String[])address.getOption(SslResourceAddress.PROTOCOLS));
                filterChain.addFirst(CERTIFICATE_SELECTION_FILTER, (IoFilter)this.certificateSelection);
                filterChain.addAfter(CERTIFICATE_SELECTION_FILTER, CODEC_FILTER, (IoFilter)sslFilter);
            } else {
                try {
                    Callable sessionFactory = (Callable)SSL_SESSION_FACTORY_KEY.get(session);
                    SslSession sslSession = (SslSession)((Object)sessionFactory.call());
                    session.setAttribute(SSL_SESSION_KEY, (Object)sslSession);
                }
                catch (Exception ex) {
                    throw new RuntimeException(ex);
                }
            }
        }
    }

    private List<String> toCipherList(String[] names) {
        if (names == null || names.length == 0) {
            return null;
        }
        ArrayList<String> list = new ArrayList<String>(names.length);
        Collections.addAll(list, names);
        return list;
    }

    private String toCipherString(List<String> names) {
        if (names == null || names.size() == 0) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (String name : names) {
            sb.append("  ").append(name).append("\n");
        }
        String cipherString = sb.toString().trim();
        return cipherString;
    }

    public void removeBridgeFilters(IoFilterChain filterChain) {
        this.removeFilter(filterChain, CODEC_FILTER);
        this.removeFilter(filterChain, CERTIFICATE_SELECTION_FILTER);
    }

    protected boolean canConnect(String transportName) {
        return transportName.equals("ssl");
    }

    protected <T extends ConnectFuture> ConnectFuture connectInternal(final ResourceAddress connectAddress, IoHandler handler, IoSessionInitializer<T> initializer) {
        boolean isSSLEncryptionEnabled = (Boolean)connectAddress.getOption(SslResourceAddress.ENCRYPTION_ENABLED);
        if (isSSLEncryptionEnabled) {
            try {
                Object keySelector = (KeySelector)connectAddress.getOption(SslResourceAddress.KEY_SELECTOR);
                if (keySelector == null) {
                    keySelector = this.vhostKeySelector;
                }
                TransportKeySelector transportKeySelector = (TransportKeySelector)TransportKeySelector.class.cast(keySelector);
                this.certificateSelection.setKeySelector(transportKeySelector);
                transportKeySelector.connect(connectAddress);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        final DefaultConnectFuture sslConnectFuture = new DefaultConnectFuture();
        IoFutureListener<ConnectFuture> parentConnectListener = new IoFutureListener<ConnectFuture>(){

            public void operationComplete(ConnectFuture future) {
                if (!future.isConnected()) {
                    sslConnectFuture.setException(future.getException());
                }
            }
        };
        final IoSessionInitializer<ConnectFuture> parentInitializer = this.createParentInitializer(connectAddress, handler, initializer, sslConnectFuture);
        BridgeSessionInitializerAdapter wrapperInitializer = new BridgeSessionInitializerAdapter<T>(){

            public void initializeSession(IoSession session, T future) {
                SslAcceptor.SSL_RESOURCE_ADDRESS.set(session, (Object)connectAddress);
                if (parentInitializer != null) {
                    parentInitializer.initializeSession(session, future);
                }
            }
        };
        BridgeConnector connector = this.bridgeServiceFactory.newBridgeConnector(connectAddress.getTransport());
        connector.connect(connectAddress.getTransport(), this.bridgeHandler, (IoSessionInitializer)wrapperInitializer).addListener((IoFutureListener)parentConnectListener);
        return sslConnectFuture;
    }

    private <T extends ConnectFuture> IoSessionInitializer<ConnectFuture> createParentInitializer(final ResourceAddress connectAddress, final IoHandler handler, final IoSessionInitializer<T> initializer, final DefaultConnectFuture sslConnectFuture) {
        return new IoSessionInitializer<ConnectFuture>(){

            public void initializeSession(final IoSession parent, ConnectFuture future) {
                final IoSessionInitializer bridgeSessionInitializer = new IoSessionInitializer<T>(){

                    public void initializeSession(IoSession bridgeSession, T future) {
                        ((AbstractBridgeSession)bridgeSession).setHandler(handler);
                        if (initializer != null) {
                            initializer.initializeSession(bridgeSession, future);
                        }
                    }
                };
                Callable<SslSession> sslSessionFactory = new Callable<SslSession>(){

                    @Override
                    public SslSession call() throws Exception {
                        Callable<SslSession> bridgeSessionFactory = new Callable<SslSession>(){

                            @Override
                            public SslSession call() throws Exception {
                                ResourceAddress localAddress = SslConnector.this.resourceAddressFactory.newResourceAddress(connectAddress, (ResourceAddress)BridgeSession.LOCAL_ADDRESS.get(parent));
                                IoSessionEx parentEx = (IoSessionEx)parent;
                                return new SslSession((IoServiceEx)SslConnector.this, (IoProcessorEx<SslSession>)SslConnector.this.getProcessor(), localAddress, connectAddress, parentEx);
                            }
                        };
                        return (SslSession)SslConnector.this.newSession(bridgeSessionInitializer, (IoFuture)sslConnectFuture, bridgeSessionFactory);
                    }
                };
                SSL_SESSION_FACTORY_KEY.set(parent, (Object)sslSessionFactory);
                SSL_CONNECT_FUTURE_KEY.set(parent, (Object)sslConnectFuture);
            }
        };
    }
}

