/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.transport.ssl;

import java.security.InvalidAlgorithmParameterException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.KeyManagerFactorySpi;
import javax.net.ssl.ManagerFactoryParameters;
import javax.net.ssl.X509KeyManager;
import org.kaazing.gateway.transport.ssl.SslKeyManager;

public class SslKeyManagerFactorySpi
extends KeyManagerFactorySpi {
    private KeyManager[] sslKeyManagers;

    @Override
    protected void engineInit(KeyStore keyStore, char[] password) throws NoSuchAlgorithmException, UnrecoverableKeyException, KeyStoreException {
        String algorithm = KeyManagerFactory.getDefaultAlgorithm();
        KeyManagerFactory defaultKmf = KeyManagerFactory.getInstance(algorithm);
        defaultKmf.init(keyStore, password);
        KeyManager[] keyManagers = defaultKmf.getKeyManagers();
        this.sslKeyManagers = new KeyManager[keyManagers.length];
        for (int i = 0; i < keyManagers.length; ++i) {
            this.sslKeyManagers[i] = new SslKeyManager((X509KeyManager)keyManagers[i]);
        }
    }

    @Override
    protected void engineInit(ManagerFactoryParameters params) throws InvalidAlgorithmParameterException {
        throw new InvalidAlgorithmParameterException("Not implemented");
    }

    @Override
    protected KeyManager[] engineGetKeyManagers() {
        return this.sslKeyManagers;
    }
}

