/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.transport.ssl.bridge.filter;

import java.util.Collection;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentSkipListMap;
import org.apache.mina.core.filterchain.IoFilter;
import org.apache.mina.core.filterchain.IoFilterAdapter;
import org.apache.mina.core.session.IoSession;
import org.kaazing.gateway.resource.address.Comparators;
import org.kaazing.gateway.resource.address.ResourceAddress;
import org.kaazing.gateway.transport.TransportKeySelector;
import org.kaazing.gateway.transport.ssl.cert.DefaultKeySelector;
import org.kaazing.mina.netty.util.threadlocal.VicariousThreadLocal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SslCertificateSelectionFilter
extends IoFilterAdapter {
    private static final Logger LOGGER = LoggerFactory.getLogger(SslCertificateSelectionFilter.class);
    private static final ThreadLocal<AvailableCertInfo> availClientCertInfo = new VicariousThreadLocal<AvailableCertInfo>(){

        protected AvailableCertInfo initialValue() {
            return new AvailableCertInfo();
        }
    };
    private static final ThreadLocal<AvailableCertInfo> availServerCertInfo = new VicariousThreadLocal<AvailableCertInfo>(){

        protected AvailableCertInfo initialValue() {
            return new AvailableCertInfo();
        }
    };
    private TransportKeySelector keySelector = new DefaultKeySelector();
    private boolean clientMode = false;

    public SslCertificateSelectionFilter(boolean clientMode) {
        this.clientMode = clientMode;
    }

    public static Collection<String> getAvailableClientCertAliases() {
        AvailableCertInfo clientInfo = availClientCertInfo.get();
        if (clientInfo == null) {
            return null;
        }
        ConcurrentMap<ResourceAddress, Collection<String>> certAliases = clientInfo.getCertAliases();
        if (certAliases == null || certAliases.isEmpty()) {
            return null;
        }
        return (Collection)certAliases.get(clientInfo.getCertAliasesKey());
    }

    public static Collection<String> getAvailableServerCertAliases() {
        AvailableCertInfo serverInfo = availServerCertInfo.get();
        if (serverInfo == null) {
            return null;
        }
        ConcurrentMap<ResourceAddress, Collection<String>> certAliases = serverInfo.getCertAliases();
        if (certAliases == null || certAliases.isEmpty()) {
            return null;
        }
        return (Collection)certAliases.get(serverInfo.getCertAliasesKey());
    }

    public static void setAvailableCertAliases(ResourceAddress key, Collection<String> aliases, boolean clientMode) {
        AvailableCertInfo certInfo = null;
        certInfo = clientMode ? availClientCertInfo.get() : availServerCertInfo.get();
        if (key != null && aliases != null) {
            certInfo.setCertAliasesKey(key);
            certInfo.getCertAliases().put(key, aliases);
        }
    }

    public static IoSession getCurrentSession(boolean client) {
        AvailableCertInfo certInfo = null;
        certInfo = client ? availClientCertInfo.get() : availServerCertInfo.get();
        return certInfo.getSession();
    }

    public static void setCurrentSession(IoSession session, boolean client) {
        AvailableCertInfo certInfo = null;
        certInfo = client ? availClientCertInfo.get() : availServerCertInfo.get();
        certInfo.setSession(session);
    }

    public boolean getClientMode() {
        return this.clientMode;
    }

    public void setKeySelector(TransportKeySelector keySelector) {
        this.keySelector = keySelector;
    }

    public void messageReceived(IoFilter.NextFilter nextFilter, IoSession session, Object message) throws Exception {
        SslCertificateSelectionFilter.setCurrentSession(session, this.clientMode);
        try {
            ResourceAddress availableAliasesKey = this.keySelector.getAvailableCertAliasesKey(this.clientMode);
            Collection availableAliases = this.keySelector.getAvailableCertAliases(this.clientMode);
            if (this.clientMode) {
                SslCertificateSelectionFilter.setAvailableCertAliases(availableAliasesKey, availableAliases, this.clientMode);
            } else {
                if (availableAliases == null) {
                    String msg = "Available certificate aliases is null for " + availableAliasesKey;
                    LOGGER.warn(msg);
                } else if (availableAliases.isEmpty()) {
                    String msg = "Certificate not available for SSL connection on " + availableAliasesKey;
                    LOGGER.warn(msg);
                }
                SslCertificateSelectionFilter.setAvailableCertAliases(availableAliasesKey, availableAliases, this.clientMode);
            }
            super.messageReceived(nextFilter, session, message);
        }
        catch (Exception e) {
            LOGGER.warn(String.format("Unable to determine certificate aliases: %s", e), (Throwable)e);
            throw e;
        }
        finally {
            SslCertificateSelectionFilter.setCurrentSession(null, this.clientMode);
        }
    }

    private static class AvailableCertInfo {
        private IoSession session;
        private ResourceAddress certAliasesKey;
        private ConcurrentMap<ResourceAddress, Collection<String>> certAliases = new ConcurrentSkipListMap<ResourceAddress, Collection<String>>(Comparators.compareResourceOriginAndProtocolStack());

        public IoSession getSession() {
            return this.session;
        }

        public void setSession(IoSession session) {
            this.session = session;
        }

        public ResourceAddress getCertAliasesKey() {
            return this.certAliasesKey;
        }

        public void setCertAliasesKey(ResourceAddress certAliasesKey) {
            this.certAliasesKey = certAliasesKey;
        }

        public ConcurrentMap<ResourceAddress, Collection<String>> getCertAliases() {
            return this.certAliases;
        }
    }
}

