/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.transport.ssl.bridge.filter;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.mina.core.filterchain.IoFilter;
import org.apache.mina.core.filterchain.IoFilterAdapter;
import org.apache.mina.core.filterchain.IoFilterChain;
import org.apache.mina.core.session.IoSession;
import org.kaazing.gateway.resource.address.ResourceAddress;
import org.kaazing.gateway.resource.address.ssl.SslResourceAddress;
import org.kaazing.gateway.transport.TypedAttributeKey;
import org.kaazing.gateway.transport.ssl.SslAcceptor;
import org.kaazing.gateway.transport.ssl.bridge.filter.SslFilter;
import org.kaazing.gateway.transport.ssl.bridge.filter.SslVersion;
import org.kaazing.gateway.util.ssl.SslCipherSuites;
import org.slf4j.Logger;

public class SslCipherSelectionFilter
extends IoFilterAdapter {
    static final TypedAttributeKey<SslVersion> SSL_PROTOCOL_VERSION = new TypedAttributeKey(SslCipherSelectionFilter.class, "sslProtocolVersion");
    static final TypedAttributeKey<List<String>> SSL_APPLET_CIPHERS = new TypedAttributeKey(SslCipherSelectionFilter.class, "sslAppletCiphers");
    static final String RC4_SHA = "SSL_RSA_WITH_RC4_128_SHA";
    static final String RC4_MD5 = "SSL_RSA_WITH_RC4_128_MD5";
    private final String filterName;
    private final String parentFilterName;
    private final SslFilter parentFilter;
    private final Logger logger;

    public SslCipherSelectionFilter(String filterName, String parentFilterName, SslFilter parentFilter, Logger logger) {
        this.filterName = filterName;
        this.parentFilterName = parentFilterName;
        this.parentFilter = parentFilter;
        this.logger = logger;
    }

    private void selectCiphers(IoSession session) throws Exception {
        ResourceAddress address = (ResourceAddress)SslAcceptor.SSL_RESOURCE_ADDRESS.get(session);
        if (address == null) {
            SSL_PROTOCOL_VERSION.remove(session);
            SSL_APPLET_CIPHERS.remove(session);
            return;
        }
        String[] ciphers = (String[])address.getOption(SslResourceAddress.CIPHERS);
        List enabledCiphers = SslCipherSuites.resolve(this.toCipherList(ciphers));
        boolean enabledRC4SHA = enabledCiphers.contains(RC4_SHA);
        boolean enabledRC4MD5 = enabledCiphers.contains(RC4_MD5);
        if (!enabledRC4SHA && !enabledRC4MD5) {
            SSL_PROTOCOL_VERSION.remove(session);
            SSL_APPLET_CIPHERS.remove(session);
            return;
        }
        SslVersion protocolVersion = (SslVersion)((Object)SSL_PROTOCOL_VERSION.remove(session));
        if (this.logger.isTraceEnabled()) {
            this.logger.trace(String.format("ClientHello is requesting protocol version %s", new Object[]{protocolVersion}));
        }
        if (protocolVersion == null) {
            SSL_APPLET_CIPHERS.remove(session);
            return;
        }
        if (!protocolVersion.equals((Object)SslVersion.SSL_3_0) && !protocolVersion.equals((Object)SslVersion.TLS_1_0)) {
            SSL_APPLET_CIPHERS.remove(session);
            return;
        }
        List appletCiphers = (List)SSL_APPLET_CIPHERS.remove(session);
        if (appletCiphers == null) {
            return;
        }
        if (this.logger.isTraceEnabled()) {
            this.logger.trace(String.format("ClientHello supported blessed applet ciphers: %s", appletCiphers));
        }
        String[] newCiphers = appletCiphers.toArray(new String[appletCiphers.size()]);
        this.parentFilter.setEnabledCipherSuites(newCiphers);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void messageReceived(IoFilter.NextFilter nextFilter, IoSession session, Object message) throws Exception {
        try {
            session.suspendRead();
            this.selectCiphers(session);
            IoFilterChain filterChain = session.getFilterChain();
            filterChain.addAfter(this.filterName, this.parentFilterName, (IoFilter)this.parentFilter);
            filterChain.remove("ssl#client_hello_codec");
            filterChain.remove((IoFilter)this);
            super.messageReceived(nextFilter, session, message);
        }
        finally {
            session.resumeRead();
        }
    }

    private List<String> toCipherList(String[] names) {
        if (names == null || names.length == 0) {
            return null;
        }
        ArrayList<String> list = new ArrayList<String>(names.length);
        Collections.addAll(list, names);
        return list;
    }
}

