/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.transport.ssl.bridge.filter;

import java.util.ArrayList;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.filter.codec.ProtocolDecoderOutput;
import org.kaazing.gateway.transport.ssl.bridge.filter.SslCipherSelectionFilter;
import org.kaazing.gateway.transport.ssl.bridge.filter.SslVersion;
import org.kaazing.mina.core.buffer.IoBufferAllocatorEx;
import org.kaazing.mina.core.buffer.IoBufferEx;
import org.kaazing.mina.filter.codec.CumulativeProtocolDecoderEx;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SslClientHelloDecoder
extends CumulativeProtocolDecoderEx {
    private static final String LOGGER_NAME = "transport.ssl.codec#client_hello";
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"transport.ssl.codec#client_hello");
    private static final int RC4_MD5_HEX = 4;
    private static final int RC4_SHA_HEX = 5;
    private static final short HANDSHAKE_CONTENT_TYPE = 22;
    private static final short CLIENTHELLO_MESSAGE_TYPE = 1;
    private static final short SSLV2_CLIENTHELLO = 128;
    private static final int SSLV2_RC4_MD5_HEX = 65664;

    public SslClientHelloDecoder(IoBufferAllocatorEx<?> allocator) {
        super(allocator);
    }

    protected boolean doDecode(IoSession session, IoBufferEx original, ProtocolDecoderOutput out) throws Exception {
        short messageType;
        short contentType;
        if (original.remaining() < 5) {
            return false;
        }
        IoBufferEx dup = original.duplicate();
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace(String.format("Received SSL message: %s", original.duplicate()));
        }
        if ((contentType = dup.getUnsigned()) == 22) {
            dup.skip(2);
            int recordSize = dup.getUnsignedShort();
            if (original.remaining() < 5 + recordSize) {
                return false;
            }
        } else if (contentType == 128) {
            short len = dup.getUnsigned();
            int recordSize = (contentType & 0x7F) << 8 | len;
            if (original.remaining() < 2 + recordSize) {
                return false;
            }
        } else {
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace(String.format("SSL record content type %d is not a Handshake record, ignoring", contentType));
            }
            out.write((Object)original.getSlice(original.remaining()));
            return true;
        }
        if ((messageType = dup.getUnsigned()) != 1) {
            out.write((Object)original.getSlice(original.remaining()));
            return true;
        }
        ArrayList<String> appletCiphers = new ArrayList<String>(2);
        if (contentType == 22) {
            dup.skip(3);
            SslVersion version = SslVersion.decode(dup.getUnsignedShort());
            SslCipherSelectionFilter.SSL_PROTOCOL_VERSION.set(session, (Object)version);
            dup.skip(32);
            short sessionIDSize = dup.getUnsigned();
            dup.skip((int)sessionIDSize);
            int cipherSuiteSize = dup.getUnsignedShort();
            int cipherSuiteCount = cipherSuiteSize / 2;
            for (int i = 0; i < cipherSuiteCount; ++i) {
                int cipher = dup.getUnsignedShort();
                if (cipher == 5) {
                    appletCiphers.add("SSL_RSA_WITH_RC4_128_SHA");
                    continue;
                }
                if (cipher != 4) continue;
                appletCiphers.add("SSL_RSA_WITH_RC4_128_MD5");
            }
        } else {
            SslVersion version = SslVersion.decode(dup.getUnsignedShort());
            SslCipherSelectionFilter.SSL_PROTOCOL_VERSION.set(session, (Object)version);
            short msb = dup.getUnsigned();
            short lsb = dup.getUnsigned();
            int cipherSuiteSize = msb << 8 | lsb;
            dup.skip(2);
            dup.skip(2);
            int cipherSuiteCount = cipherSuiteSize / 3;
            for (int i = 0; i < cipherSuiteCount; ++i) {
                int cipherKind = dup.getUnsignedMediumInt();
                if (cipherKind != 65664) continue;
                appletCiphers.add("SSL_RSA_WITH_RC4_128_MD5");
            }
        }
        if (appletCiphers.size() > 0) {
            SslCipherSelectionFilter.SSL_APPLET_CIPHERS.set(session, appletCiphers);
        }
        out.write((Object)original.getSlice(original.remaining()));
        return true;
    }
}

