/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.transport.ssl.bridge.filter;

import java.util.ArrayList;
import java.util.List;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLSession;
import org.apache.mina.core.buffer.IoBuffer;
import org.apache.mina.core.filterchain.IoFilter;
import org.apache.mina.core.filterchain.IoFilterAdapter;
import org.apache.mina.core.filterchain.IoFilterChain;
import org.apache.mina.core.future.DefaultWriteFuture;
import org.apache.mina.core.future.IoFuture;
import org.apache.mina.core.future.IoFutureListener;
import org.apache.mina.core.future.WriteFuture;
import org.apache.mina.core.session.AttributeKey;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.core.write.WriteRequest;
import org.apache.mina.core.write.WriteRequestWrapper;
import org.apache.mina.core.write.WriteToClosedSessionException;
import org.kaazing.gateway.transport.ssl.bridge.filter.SslCertificateSelectionFilter;
import org.kaazing.gateway.transport.ssl.bridge.filter.SslHandler;
import org.kaazing.mina.core.session.AbstractIoSessionEx;
import org.kaazing.mina.core.session.IoSessionEx;
import org.slf4j.Logger;

public class SslFilter
extends IoFilterAdapter {
    public static final AttributeKey SSL_SESSION = new AttributeKey(SslFilter.class, "session");
    public static final AttributeKey DISABLE_ENCRYPTION_ONCE = new AttributeKey(SslFilter.class, "disableOnce");
    public static final AttributeKey USE_NOTIFICATION = new AttributeKey(SslFilter.class, "useNotification");
    public static final AttributeKey PEER_ADDRESS = new AttributeKey(SslFilter.class, "peerAddress");
    public static final SslFilterMessage SESSION_SECURED = new SslFilterMessage("SESSION_SECURED");
    public static final SslFilterMessage SESSION_UNSECURED = new SslFilterMessage("SESSION_UNSECURED");
    private static final AttributeKey NEXT_FILTER = new AttributeKey(SslFilter.class, "nextFilter");
    private static final AttributeKey SSL_HANDLER = new AttributeKey(SslFilter.class, "handler");
    private final SSLContext sslContext;
    private final boolean autoStart;
    private final Logger logger;
    private static final boolean START_HANDSHAKE = true;
    private boolean client;
    private boolean needClientAuth;
    private boolean wantClientAuth;
    private String[] enabledCipherSuites;
    private String[] enabledProtocols;

    public SslFilter(SSLContext sslContext, Logger logger) {
        this(sslContext, true, logger);
    }

    public SslFilter(SSLContext sslContext, boolean autoStart, Logger logger) {
        if (sslContext == null) {
            throw new NullPointerException("sslContext");
        }
        this.sslContext = sslContext;
        this.autoStart = autoStart;
        this.logger = logger;
    }

    public SSLSession getSslSession(IoSession session) {
        return (SSLSession)session.getAttribute((Object)SSL_SESSION);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean startSsl(IoSession session) throws SSLException {
        boolean started;
        SslHandler handler;
        SslHandler sslHandler = handler = this.getSslSessionHandler(session);
        synchronized (sslHandler) {
            if (handler.isOutboundDone()) {
                IoFilter.NextFilter nextFilter = (IoFilter.NextFilter)session.getAttribute((Object)NEXT_FILTER);
                handler.destroy();
                handler.init();
                handler.handshake(nextFilter);
                started = true;
            } else {
                started = false;
            }
        }
        handler.flushScheduledEvents();
        return started;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSslStarted(IoSession session) {
        SslHandler handler = (SslHandler)session.getAttribute((Object)SSL_HANDLER);
        if (handler == null) {
            return false;
        }
        SslHandler sslHandler = handler;
        synchronized (sslHandler) {
            return !handler.isOutboundDone();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WriteFuture stopSsl(IoSession session) throws SSLException {
        WriteFuture future;
        SslHandler handler = this.getSslSessionHandler(session);
        IoFilter.NextFilter nextFilter = (IoFilter.NextFilter)session.getAttribute((Object)NEXT_FILTER);
        SslHandler sslHandler = handler;
        synchronized (sslHandler) {
            future = this.initiateClosure(nextFilter, session);
        }
        handler.flushScheduledEvents();
        return future;
    }

    public boolean isUseClientMode() {
        return this.client;
    }

    public void setUseClientMode(boolean clientMode) {
        this.client = clientMode;
    }

    public boolean isNeedClientAuth() {
        return this.needClientAuth;
    }

    public void setNeedClientAuth(boolean needClientAuth) {
        this.needClientAuth = needClientAuth;
    }

    public boolean isWantClientAuth() {
        return this.wantClientAuth;
    }

    public void setWantClientAuth(boolean wantClientAuth) {
        this.wantClientAuth = wantClientAuth;
    }

    public String[] getEnabledCipherSuites() {
        return this.enabledCipherSuites;
    }

    public void setEnabledCipherSuites(String[] cipherSuites) {
        this.enabledCipherSuites = cipherSuites;
    }

    public String[] getEnabledProtocols() {
        return this.enabledProtocols;
    }

    public void setEnabledProtocols(String[] protocols) {
        this.enabledProtocols = protocols;
    }

    public void onPreAdd(IoFilterChain parent, String name, IoFilter.NextFilter nextFilter) throws SSLException {
        if (parent.contains(SslFilter.class)) {
            throw new IllegalStateException("Only one " + SslFilter.class.getName() + " is permitted.");
        }
        IoSession session = parent.getSession();
        session.setAttribute((Object)NEXT_FILTER, (Object)nextFilter);
        SslHandler handler = new SslHandler(this, this.sslContext, (IoSessionEx)session, this.logger);
        session.setAttribute((Object)SSL_HANDLER, (Object)handler);
    }

    public void onPostAdd(IoFilterChain parent, String name, IoFilter.NextFilter nextFilter) throws SSLException {
        if (this.autoStart) {
            this.initiateHandshake(nextFilter, parent.getSession());
        }
    }

    public void onPreRemove(IoFilterChain parent, String name, IoFilter.NextFilter nextFilter) throws SSLException {
        IoSession session = parent.getSession();
        this.stopSsl(session);
        session.removeAttribute((Object)NEXT_FILTER);
        session.removeAttribute((Object)SSL_HANDLER);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sessionClosed(IoFilter.NextFilter nextFilter, IoSession session) throws SSLException {
        SslHandler handler = this.getSslSessionHandler(session);
        try {
            SslHandler sslHandler = handler;
            synchronized (sslHandler) {
                handler.destroy();
            }
            handler.flushScheduledEvents();
        }
        finally {
            nextFilter.sessionClosed(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void messageReceived(IoFilter.NextFilter nextFilter, IoSession session, Object message) throws SSLException {
        SslHandler handler;
        SslHandler sslHandler = handler = this.getSslSessionHandler(session);
        synchronized (sslHandler) {
            if (!this.isSslStarted(session) && handler.isInboundDone()) {
                handler.scheduleMessageReceived(nextFilter, message);
            } else {
                IoBuffer buf = (IoBuffer)message;
                try {
                    SslCertificateSelectionFilter.setCurrentSession(session, this.isUseClientMode());
                    handler.messageReceived(nextFilter, buf.buf());
                    SslCertificateSelectionFilter.setCurrentSession(null, this.isUseClientMode());
                    this.handleSslData(nextFilter, handler);
                    if (handler.isInboundDone()) {
                        if (handler.isOutboundDone()) {
                            handler.destroy();
                        } else {
                            this.initiateClosure(nextFilter, session);
                        }
                        if (buf.hasRemaining()) {
                            handler.scheduleMessageReceived(nextFilter, buf);
                        }
                    }
                }
                catch (SSLException ssle2) {
                    SSLHandshakeException ssle2;
                    if (!handler.isHandshakeComplete()) {
                        SSLHandshakeException newSsle = new SSLHandshakeException("SSL handshake failed.");
                        newSsle.initCause(ssle2);
                        ssle2 = newSsle;
                    }
                    throw ssle2;
                }
                finally {
                    SslCertificateSelectionFilter.setCurrentSession(null, this.isUseClientMode());
                }
            }
        }
        handler.flushScheduledEvents();
    }

    public void messageSent(IoFilter.NextFilter nextFilter, IoSession session, WriteRequest writeRequest) {
        if (writeRequest instanceof EncryptedWriteRequest) {
            EncryptedWriteRequest wrappedRequest = (EncryptedWriteRequest)writeRequest;
            nextFilter.messageSent(session, wrappedRequest.getParentRequest());
        } else if (writeRequest == AbstractIoSessionEx.REGISTERED_EVENT) {
            session.setAttribute((Object)NEXT_FILTER, (Object)nextFilter);
        }
    }

    public void exceptionCaught(IoFilter.NextFilter nextFilter, IoSession session, Throwable cause) throws Exception {
        if (cause instanceof WriteToClosedSessionException) {
            WriteToClosedSessionException e = (WriteToClosedSessionException)cause;
            List failedRequests = e.getRequests();
            boolean containsCloseNotify = false;
            for (WriteRequest r : failedRequests) {
                if (!this.isCloseNotify(r.getMessage())) continue;
                containsCloseNotify = true;
                break;
            }
            if (containsCloseNotify) {
                if (failedRequests.size() == 1) {
                    return;
                }
                ArrayList<WriteRequest> newFailedRequests = new ArrayList<WriteRequest>(failedRequests.size() - 1);
                for (WriteRequest r : failedRequests) {
                    if (this.isCloseNotify(r.getMessage())) continue;
                    newFailedRequests.add(r);
                }
                if (newFailedRequests.isEmpty()) {
                    return;
                }
                cause = new WriteToClosedSessionException(newFailedRequests, cause.getMessage(), cause.getCause());
            }
        }
        nextFilter.exceptionCaught(session, cause);
    }

    private boolean isCloseNotify(Object message) {
        if (!(message instanceof IoBuffer)) {
            return false;
        }
        IoBuffer buf = (IoBuffer)message;
        int offset = buf.position();
        return buf.remaining() == 23 && buf.get(offset + 0) == 21 && buf.get(offset + 1) == 3 && buf.get(offset + 2) == 1 && buf.get(offset + 3) == 0 && buf.get(offset + 4) == 18;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void filterWrite(IoFilter.NextFilter nextFilter, IoSession session, WriteRequest writeRequest) throws SSLException {
        SslHandler handler;
        boolean needsFlush = true;
        SslHandler sslHandler = handler = this.getSslSessionHandler(session);
        synchronized (sslHandler) {
            if (!this.isSslStarted(session)) {
                handler.scheduleFilterWrite(nextFilter, writeRequest);
            } else if (session.containsAttribute((Object)DISABLE_ENCRYPTION_ONCE)) {
                session.removeAttribute((Object)DISABLE_ENCRYPTION_ONCE);
                handler.scheduleFilterWrite(nextFilter, writeRequest);
            } else {
                IoBuffer buf = (IoBuffer)writeRequest.getMessage();
                if (handler.isWritingEncryptedData()) {
                    handler.scheduleFilterWrite(nextFilter, writeRequest);
                } else if (handler.isHandshakeComplete()) {
                    int pos = buf.position();
                    handler.encrypt(buf.buf());
                    buf.position(pos);
                    IoBuffer encryptedBuffer = handler.fetchOutNetBuffer();
                    handler.scheduleFilterWrite(nextFilter, (WriteRequest)new EncryptedWriteRequest(writeRequest, encryptedBuffer));
                } else {
                    if (session.isConnected()) {
                        handler.schedulePreHandshakeWriteRequest(nextFilter, writeRequest);
                    }
                    needsFlush = false;
                }
            }
        }
        if (needsFlush) {
            handler.flushScheduledEvents();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void filterClose(final IoFilter.NextFilter nextFilter, final IoSession session) throws SSLException {
        SslHandler handler = (SslHandler)session.getAttribute((Object)SSL_HANDLER);
        if (handler == null) {
            nextFilter.filterClose(session);
            return;
        }
        WriteFuture future = null;
        try {
            SslHandler sslHandler = handler;
            synchronized (sslHandler) {
                if (this.isSslStarted(session)) {
                    future = this.initiateClosure(nextFilter, session);
                    future.addListener((IoFutureListener)new IoFutureListener<IoFuture>(){

                        public void operationComplete(IoFuture future) {
                            nextFilter.filterClose(session);
                        }
                    });
                }
            }
            handler.flushScheduledEvents();
        }
        finally {
            if (future == null) {
                nextFilter.filterClose(session);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initiateHandshake(IoFilter.NextFilter nextFilter, IoSession session) throws SSLException {
        SslHandler handler;
        SslHandler sslHandler = handler = this.getSslSessionHandler(session);
        synchronized (sslHandler) {
            handler.handshake(nextFilter);
        }
        handler.flushScheduledEvents();
    }

    private WriteFuture initiateClosure(IoFilter.NextFilter nextFilter, IoSession session) throws SSLException {
        SslHandler handler = this.getSslSessionHandler(session);
        if (!handler.closeOutbound()) {
            return DefaultWriteFuture.newNotWrittenFuture((IoSession)session, (Throwable)new IllegalStateException("SSL session is shut down already."));
        }
        WriteFuture future = handler.writeNetBuffer(nextFilter);
        if (future == null) {
            future = DefaultWriteFuture.newWrittenFuture((IoSession)session);
        }
        if (handler.isInboundDone()) {
            handler.destroy();
        }
        if (session.containsAttribute((Object)USE_NOTIFICATION)) {
            handler.scheduleMessageReceived(nextFilter, SESSION_UNSECURED);
        }
        return future;
    }

    private void handleSslData(IoFilter.NextFilter nextFilter, SslHandler handler) throws SSLException {
        if (handler.isHandshakeComplete()) {
            handler.flushPreHandshakeEvents();
        }
        handler.writeNetBuffer(nextFilter);
        this.handleAppDataRead(nextFilter, handler);
    }

    private void handleAppDataRead(IoFilter.NextFilter nextFilter, SslHandler handler) {
        IoBuffer readBuffer = handler.fetchAppBuffer();
        if (readBuffer.hasRemaining()) {
            handler.scheduleMessageReceived(nextFilter, readBuffer);
        }
    }

    private SslHandler getSslSessionHandler(IoSession session) {
        SslHandler handler = (SslHandler)session.getAttribute((Object)SSL_HANDLER);
        if (handler == null) {
            throw new IllegalStateException();
        }
        if (handler.getParent() != this) {
            throw new IllegalArgumentException("Not managed by this filter.");
        }
        return handler;
    }

    private static class EncryptedWriteRequest
    extends WriteRequestWrapper {
        private final IoBuffer encryptedMessage;

        private EncryptedWriteRequest(WriteRequest writeRequest, IoBuffer encryptedMessage) {
            super(writeRequest);
            this.encryptedMessage = encryptedMessage;
        }

        public Object getMessage() {
            return this.encryptedMessage;
        }
    }

    public static class SslFilterMessage {
        private final String name;

        private SslFilterMessage(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

