/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.transport.ssl.bridge.filter;

import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLSession;
import org.apache.mina.core.buffer.IoBuffer;
import org.apache.mina.core.filterchain.IoFilter;
import org.apache.mina.core.filterchain.IoFilterEvent;
import org.apache.mina.core.future.WriteFuture;
import org.apache.mina.core.session.IoEventType;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.core.write.WriteRequest;
import org.apache.mina.util.CircularQueue;
import org.kaazing.gateway.transport.ssl.bridge.filter.SslFilter;
import org.kaazing.mina.core.buffer.IoBufferAllocatorEx;
import org.kaazing.mina.core.buffer.IoBufferEx;
import org.kaazing.mina.core.future.DefaultWriteFutureEx;
import org.kaazing.mina.core.future.WriteFutureEx;
import org.kaazing.mina.core.session.IoSessionEx;
import org.kaazing.mina.core.write.DefaultWriteRequestEx;
import org.slf4j.Logger;

class SslHandler {
    private final SslFilter parent;
    private final SSLContext sslContext;
    private final IoSessionEx session;
    private final Queue<IoFilterEvent> preHandshakeEventQueue = new CircularQueue();
    private final Queue<IoFilterEvent> filterWriteEventQueue = new ConcurrentLinkedQueue<IoFilterEvent>();
    private final Queue<IoFilterEvent> messageReceivedEventQueue = new ConcurrentLinkedQueue<IoFilterEvent>();
    private final AtomicInteger messageReceivedEventQueueConcurrentGuard = new AtomicInteger(0);
    private final Logger logger;
    private SSLEngine sslEngine;
    private IoBufferEx inNetBuffer;
    private IoBufferEx outNetBuffer;
    private IoBufferEx appBuffer;
    private final IoBufferEx emptyBuffer;
    private SSLEngineResult.HandshakeStatus handshakeStatus;
    private boolean initialHandshakeComplete;
    private boolean handshakeComplete;
    private boolean writingEncryptedData;
    private final IoBufferAllocatorEx<?> allocator;

    public SslHandler(SslFilter parent, SSLContext sslContext, IoSessionEx session, Logger logger) throws SSLException {
        this.parent = parent;
        this.session = session;
        this.sslContext = sslContext;
        this.logger = logger;
        this.allocator = session.getBufferAllocator();
        this.emptyBuffer = this.allocator.wrap(this.allocator.allocate(0));
        this.init();
    }

    public void init() throws SSLException {
        String[] protocols;
        String[] enabledCipherSuites;
        if (this.sslEngine != null) {
            return;
        }
        InetSocketAddress peer = (InetSocketAddress)this.session.getAttribute((Object)SslFilter.PEER_ADDRESS);
        this.sslEngine = peer == null ? this.sslContext.createSSLEngine() : this.sslContext.createSSLEngine(peer.getHostName(), peer.getPort());
        this.sslEngine.setUseClientMode(this.parent.isUseClientMode());
        if (this.parent.isWantClientAuth()) {
            this.sslEngine.setWantClientAuth(true);
        }
        if (this.parent.isNeedClientAuth()) {
            this.sslEngine.setNeedClientAuth(true);
        }
        if (this.logger.isTraceEnabled()) {
            List<String> supportedCiphers = this.toCipherList(this.sslEngine.getSupportedCipherSuites());
            if (supportedCiphers != null) {
                this.logger.trace(String.format("Supported SSL/TLS ciphersuites:\n  %s", this.toCipherString(supportedCiphers)));
            } else {
                this.logger.trace(String.format("Supported SSL/TLS ciphersuites: none", new Object[0]));
            }
            List<String> enabledCiphers = this.toCipherList(this.sslEngine.getEnabledCipherSuites());
            if (enabledCiphers != null) {
                this.logger.trace(String.format("Default enabled SSL/TLS ciphersuites:\n  %s", this.toCipherString(enabledCiphers)));
            } else {
                this.logger.trace(String.format("Enabled SSL/TLS ciphersuites: none", new Object[0]));
            }
            if (this.sslEngine.getWantClientAuth() || this.sslEngine.getNeedClientAuth()) {
                this.logger.trace(String.format("Client certificate verification %s", this.sslEngine.getNeedClientAuth() ? "REQUIRED" : "requested"));
            }
        }
        if ((enabledCipherSuites = this.parent.getEnabledCipherSuites()) != null) {
            List<String> supportedCiphers = this.toCipherList(this.sslEngine.getSupportedCipherSuites());
            List<String> configuredCiphers = this.toCipherList(enabledCipherSuites);
            configuredCiphers.retainAll(supportedCiphers);
            if (this.logger.isTraceEnabled()) {
                this.logger.trace(String.format("SSL/TLS ciphersuites in use:\n  %s", this.toCipherString(configuredCiphers)));
            }
            String[] enabledCiphers = configuredCiphers.toArray(new String[configuredCiphers.size()]);
            this.sslEngine.setEnabledCipherSuites(enabledCiphers);
        }
        if ((protocols = this.parent.getEnabledProtocols()) == null || protocols.length == 0) {
            protocols = this.removeSslProtocols(this.sslEngine.getSupportedProtocols());
        } else {
            boolean sslv3Enabled = this.isSslv3Enabled(protocols);
            if (sslv3Enabled && this.logger.isWarnEnabled()) {
                this.logger.warn(String.format("SSLv3 protocol is enabled. SSLv3 known to have vulnerabilities", new Object[0]));
            }
        }
        if (this.logger.isTraceEnabled()) {
            this.logger.trace(String.format("SSL/TLS enabled protocols are: %s", Arrays.asList(protocols)));
        }
        this.sslEngine.setEnabledProtocols(protocols);
        this.sslEngine.beginHandshake();
        this.handshakeStatus = this.sslEngine.getHandshakeStatus();
        this.handshakeComplete = false;
        this.initialHandshakeComplete = false;
        this.writingEncryptedData = false;
    }

    public void destroy() {
        if (this.sslEngine == null) {
            return;
        }
        this.sslEngine.closeOutbound();
        if (this.outNetBuffer != null) {
            this.outNetBuffer.capacity(this.sslEngine.getSession().getPacketBufferSize(), this.allocator);
        } else {
            this.createOutNetBuffer(0);
        }
        try {
            do {
                this.outNetBuffer.clear();
            } while (this.sslEngine.wrap(this.emptyBuffer.buf(), this.outNetBuffer.buf()).bytesProduced() > 0);
        }
        catch (SSLException sSLException) {
        }
        finally {
            this.destroyOutNetBuffer();
        }
        this.sslEngine = null;
        this.preHandshakeEventQueue.clear();
    }

    private void destroyOutNetBuffer() {
        this.outNetBuffer.free();
        this.outNetBuffer = null;
    }

    public SslFilter getParent() {
        return this.parent;
    }

    public IoSession getSession() {
        return this.session;
    }

    public boolean isWritingEncryptedData() {
        return this.writingEncryptedData;
    }

    public boolean isHandshakeComplete() {
        return this.handshakeComplete;
    }

    public boolean isInboundDone() {
        return this.sslEngine == null || this.sslEngine.isInboundDone();
    }

    public boolean isOutboundDone() {
        return this.sslEngine == null || this.sslEngine.isOutboundDone();
    }

    public boolean needToCompleteHandshake() {
        return this.handshakeStatus == SSLEngineResult.HandshakeStatus.NEED_WRAP && !this.isInboundDone();
    }

    public void schedulePreHandshakeWriteRequest(IoFilter.NextFilter nextFilter, WriteRequest writeRequest) {
        this.preHandshakeEventQueue.add(new IoFilterEvent(nextFilter, IoEventType.WRITE, (IoSession)this.session, (Object)writeRequest));
    }

    public void flushPreHandshakeEvents() throws SSLException {
        IoFilterEvent scheduledWrite;
        while ((scheduledWrite = this.preHandshakeEventQueue.poll()) != null) {
            this.parent.filterWrite(scheduledWrite.getNextFilter(), (IoSession)this.session, (WriteRequest)scheduledWrite.getParameter());
        }
    }

    public void scheduleFilterWrite(IoFilter.NextFilter nextFilter, WriteRequest writeRequest) {
        this.filterWriteEventQueue.add(new IoFilterEvent(nextFilter, IoEventType.WRITE, (IoSession)this.session, (Object)writeRequest));
    }

    public void scheduleMessageReceived(IoFilter.NextFilter nextFilter, Object message) {
        this.messageReceivedEventQueue.add(new IoFilterEvent(nextFilter, IoEventType.MESSAGE_RECEIVED, (IoSession)this.session, message));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushScheduledEvents() {
        IoFilterEvent e;
        if (Thread.holdsLock(this)) {
            return;
        }
        SslHandler sslHandler = this;
        synchronized (sslHandler) {
            while ((e = this.filterWriteEventQueue.poll()) != null) {
                e.getNextFilter().filterWrite((IoSession)this.session, (WriteRequest)e.getParameter());
            }
        }
        if (this.messageReceivedEventQueueConcurrentGuard.getAndIncrement() == 0) {
            while ((e = this.messageReceivedEventQueue.poll()) != null) {
                e.getNextFilter().messageReceived((IoSession)this.session, e.getParameter());
            }
        }
        if (this.messageReceivedEventQueueConcurrentGuard.decrementAndGet() == 0) {
            while ((e = this.messageReceivedEventQueue.poll()) != null) {
                e.getNextFilter().messageReceived((IoSession)this.session, e.getParameter());
            }
        }
    }

    public void messageReceived(IoFilter.NextFilter nextFilter, ByteBuffer buf) throws SSLException {
        if (this.inNetBuffer == null) {
            this.inNetBuffer = this.allocator.wrap(this.allocator.allocate(buf.remaining())).setAutoExpander(this.allocator);
        }
        this.inNetBuffer.put(buf);
        if (!this.handshakeComplete) {
            this.handshake(nextFilter);
        }
        if (this.handshakeComplete) {
            this.decrypt(nextFilter);
        }
        if (this.isInboundDone()) {
            int inNetBufferPosition = this.inNetBuffer == null ? 0 : this.inNetBuffer.position();
            buf.position(buf.position() - inNetBufferPosition);
            this.inNetBuffer = null;
        }
    }

    public IoBuffer fetchAppBuffer() {
        IoBufferEx appBuffer = this.appBuffer.flip();
        this.appBuffer = null;
        return (IoBuffer)appBuffer;
    }

    public IoBuffer fetchOutNetBuffer() {
        IoBufferEx answer = this.outNetBuffer;
        if (answer == null) {
            return (IoBuffer)this.emptyBuffer;
        }
        this.outNetBuffer = null;
        return (IoBuffer)answer.shrink(this.allocator);
    }

    public void encrypt(ByteBuffer src) throws SSLException {
        if (!this.handshakeComplete) {
            throw new IllegalStateException();
        }
        if (!src.hasRemaining()) {
            if (this.outNetBuffer == null) {
                this.outNetBuffer = this.emptyBuffer;
            }
            return;
        }
        this.createOutNetBuffer(src.remaining());
        while (src.hasRemaining()) {
            SSLEngineResult result = this.sslEngine.wrap(src, this.outNetBuffer.buf());
            if (result.getStatus() == SSLEngineResult.Status.OK) {
                if (result.getHandshakeStatus() != SSLEngineResult.HandshakeStatus.NEED_TASK) continue;
                this.doTasks();
                continue;
            }
            if (result.getStatus() == SSLEngineResult.Status.BUFFER_OVERFLOW) {
                this.outNetBuffer.capacity(this.outNetBuffer.capacity() << 1, this.allocator);
                this.outNetBuffer.limit(this.outNetBuffer.capacity());
                continue;
            }
            throw new SSLException("SSLEngine error during encrypt: " + (Object)((Object)result.getStatus()) + " src: " + src + "outNetBuffer: " + this.outNetBuffer);
        }
        this.outNetBuffer.flip();
    }

    public boolean closeOutbound() throws SSLException {
        SSLEngineResult result;
        if (this.sslEngine == null || !this.isHandshakeComplete() || this.sslEngine.isOutboundDone()) {
            return false;
        }
        this.sslEngine.closeOutbound();
        this.createOutNetBuffer(0);
        while ((result = this.sslEngine.wrap(this.emptyBuffer.buf(), this.outNetBuffer.buf())).getStatus() == SSLEngineResult.Status.BUFFER_OVERFLOW) {
            this.outNetBuffer.capacity(this.outNetBuffer.capacity() << 1, this.allocator);
            this.outNetBuffer.limit(this.outNetBuffer.capacity());
        }
        if (result.getStatus() != SSLEngineResult.Status.CLOSED) {
            throw new SSLException("Improper close state: " + result);
        }
        this.outNetBuffer.flip();
        return true;
    }

    private void decrypt(IoFilter.NextFilter nextFilter) throws SSLException {
        if (!this.handshakeComplete) {
            throw new IllegalStateException();
        }
        this.unwrap(nextFilter);
    }

    private void checkStatus(SSLEngineResult res) throws SSLException {
        SSLEngineResult.Status status = res.getStatus();
        if (status != SSLEngineResult.Status.OK && status != SSLEngineResult.Status.CLOSED && status != SSLEngineResult.Status.BUFFER_UNDERFLOW) {
            throw new SSLException("SSLEngine error during decrypt: " + (Object)((Object)status) + " inNetBuffer: " + this.inNetBuffer + "appBuffer: " + this.appBuffer);
        }
    }

    public void handshake(IoFilter.NextFilter nextFilter) throws SSLException {
        block6: while (true) {
            switch (this.handshakeStatus) {
                case FINISHED: {
                    this.session.setAttribute((Object)SslFilter.SSL_SESSION, (Object)this.sslEngine.getSession());
                    this.handshakeComplete = true;
                    if (this.logger.isDebugEnabled()) {
                        SSLSession sslSession = this.sslEngine.getSession();
                        this.logger.debug(String.format("SSL session ID %s on transport session #%d %s: cipher %s, app buffer size %d, packet buffer size %d", sslSession.getId(), this.session.getId(), this.session, sslSession.getCipherSuite(), sslSession.getApplicationBufferSize(), sslSession.getPacketBufferSize()));
                    }
                    if (!this.initialHandshakeComplete && this.session.containsAttribute((Object)SslFilter.USE_NOTIFICATION)) {
                        this.initialHandshakeComplete = true;
                        this.scheduleMessageReceived(nextFilter, SslFilter.SESSION_SECURED);
                    }
                    return;
                }
                case NEED_TASK: {
                    this.handshakeStatus = this.doTasks();
                    continue block6;
                }
                case NEED_UNWRAP: {
                    SSLEngineResult.Status status = this.unwrapHandshake(nextFilter);
                    if ((status != SSLEngineResult.Status.BUFFER_UNDERFLOW || this.handshakeStatus == SSLEngineResult.HandshakeStatus.FINISHED) && !this.isInboundDone()) continue block6;
                    return;
                }
                case NEED_WRAP: {
                    SSLEngineResult result;
                    if (this.outNetBuffer != null && this.outNetBuffer.hasRemaining()) {
                        return;
                    }
                    this.createOutNetBuffer(0);
                    while ((result = this.sslEngine.wrap(this.emptyBuffer.buf(), this.outNetBuffer.buf())).getStatus() == SSLEngineResult.Status.BUFFER_OVERFLOW) {
                        this.outNetBuffer.capacity(this.outNetBuffer.capacity() << 1, this.allocator);
                        this.outNetBuffer.limit(this.outNetBuffer.capacity());
                    }
                    this.outNetBuffer.flip();
                    this.handshakeStatus = result.getHandshakeStatus();
                    this.writeNetBuffer(nextFilter);
                    continue block6;
                }
            }
            break;
        }
        throw new IllegalStateException("Invalid Handshaking State" + (Object)((Object)this.handshakeStatus));
    }

    private void createOutNetBuffer(int expectedRemaining) {
        int capacity = Math.max(expectedRemaining, this.sslEngine.getSession().getPacketBufferSize());
        if (this.outNetBuffer != null) {
            this.outNetBuffer.capacity(capacity, this.allocator);
        } else {
            this.outNetBuffer = this.allocator.wrap(this.allocator.allocate(capacity)).minimumCapacity(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WriteFuture writeNetBuffer(IoFilter.NextFilter nextFilter) throws SSLException {
        if (this.outNetBuffer == null || !this.outNetBuffer.hasRemaining()) {
            return null;
        }
        this.writingEncryptedData = true;
        DefaultWriteFutureEx writeFuture = null;
        try {
            IoBuffer writeBuffer = this.fetchOutNetBuffer();
            writeFuture = new DefaultWriteFutureEx((IoSession)this.session);
            this.parent.filterWrite(nextFilter, (IoSession)this.session, (WriteRequest)new DefaultWriteRequestEx((Object)writeBuffer, (WriteFutureEx)writeFuture));
            while (this.needToCompleteHandshake()) {
                try {
                    this.handshake(nextFilter);
                }
                catch (SSLException ssle) {
                    SSLHandshakeException newSsle = new SSLHandshakeException("SSL handshake failed.");
                    newSsle.initCause(ssle);
                    throw newSsle;
                }
                IoBuffer outNetBuffer = this.fetchOutNetBuffer();
                if (outNetBuffer == null || !outNetBuffer.hasRemaining()) continue;
                writeFuture = new DefaultWriteFutureEx((IoSession)this.session);
                this.parent.filterWrite(nextFilter, (IoSession)this.session, (WriteRequest)new DefaultWriteRequestEx((Object)outNetBuffer, (WriteFutureEx)writeFuture));
            }
        }
        finally {
            this.writingEncryptedData = false;
        }
        return writeFuture;
    }

    private void unwrap(IoFilter.NextFilter nextFilter) throws SSLException {
        if (this.inNetBuffer != null) {
            this.inNetBuffer.flip();
        }
        if (this.inNetBuffer == null || !this.inNetBuffer.hasRemaining()) {
            return;
        }
        SSLEngineResult res = this.unwrap0();
        if (this.inNetBuffer.hasRemaining()) {
            this.inNetBuffer.compact();
        } else {
            this.inNetBuffer = null;
        }
        this.checkStatus(res);
        this.renegotiateIfNeeded(nextFilter, res);
    }

    private SSLEngineResult.Status unwrapHandshake(IoFilter.NextFilter nextFilter) throws SSLException {
        if (this.inNetBuffer != null) {
            this.inNetBuffer.flip();
        }
        if (this.inNetBuffer == null || !this.inNetBuffer.hasRemaining()) {
            return SSLEngineResult.Status.BUFFER_UNDERFLOW;
        }
        SSLEngineResult res = this.unwrap0();
        this.handshakeStatus = res.getHandshakeStatus();
        this.checkStatus(res);
        if (this.handshakeStatus == SSLEngineResult.HandshakeStatus.FINISHED && res.getStatus() == SSLEngineResult.Status.OK && this.inNetBuffer.hasRemaining()) {
            res = this.unwrap0();
            if (this.inNetBuffer.hasRemaining()) {
                this.inNetBuffer.compact();
            } else {
                this.inNetBuffer = null;
            }
            this.renegotiateIfNeeded(nextFilter, res);
        } else if (this.inNetBuffer.hasRemaining()) {
            this.inNetBuffer.compact();
        } else {
            this.inNetBuffer = null;
        }
        return res.getStatus();
    }

    private void renegotiateIfNeeded(IoFilter.NextFilter nextFilter, SSLEngineResult res) throws SSLException {
        if (res.getStatus() != SSLEngineResult.Status.CLOSED && res.getStatus() != SSLEngineResult.Status.BUFFER_UNDERFLOW && res.getHandshakeStatus() != SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING) {
            this.handshakeComplete = false;
            this.handshakeStatus = res.getHandshakeStatus();
            this.handshake(nextFilter);
        }
    }

    private SSLEngineResult unwrap0() throws SSLException {
        SSLEngineResult res;
        if (this.appBuffer == null) {
            this.appBuffer = this.allocator.wrap(this.allocator.allocate(this.inNetBuffer.remaining()));
        } else {
            this.appBuffer.expand(this.inNetBuffer.remaining(), this.allocator);
        }
        do {
            if ((res = this.sslEngine.unwrap(this.inNetBuffer.buf(), this.appBuffer.buf())).getStatus() != SSLEngineResult.Status.BUFFER_OVERFLOW) continue;
            this.appBuffer.capacity(this.appBuffer.capacity() << 1, this.allocator);
            this.appBuffer.limit(this.appBuffer.capacity());
        } while ((res.getStatus() == SSLEngineResult.Status.OK || res.getStatus() == SSLEngineResult.Status.BUFFER_OVERFLOW) && (this.handshakeComplete && res.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING || res.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.NEED_UNWRAP));
        return res;
    }

    private SSLEngineResult.HandshakeStatus doTasks() {
        Runnable runnable;
        while ((runnable = this.sslEngine.getDelegatedTask()) != null) {
            runnable.run();
        }
        return this.sslEngine.getHandshakeStatus();
    }

    private List<String> toCipherList(String[] names) {
        if (names == null || names.length == 0) {
            return null;
        }
        ArrayList<String> list = new ArrayList<String>(names.length);
        Collections.addAll(list, names);
        return list;
    }

    private String toCipherString(List<String> names) {
        if (names == null || names.size() == 0) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (String name : names) {
            sb.append("  ").append(name).append("\n");
        }
        String cipherString = sb.toString().trim();
        return cipherString;
    }

    private String[] removeSslProtocols(String[] protocols) {
        ArrayList<String> protocolList = new ArrayList<String>();
        for (String protocol : protocols) {
            if (protocol.equals("SSLv3") || protocol.equals("SSLv2")) continue;
            protocolList.add(protocol);
        }
        return protocolList.toArray(new String[protocolList.size()]);
    }

    private boolean isSslv3Enabled(String[] protocols) {
        for (String protocol : protocols) {
            if (!protocol.equals("SSLv3")) continue;
            return true;
        }
        return false;
    }
}

