/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.transport.ssl.bridge.filter;

enum SslVersion {
    SSL_3_0(3, 0),
    TLS_1_0(3, 1),
    TLS_1_1(3, 2),
    TLS_1_2(3, 3);

    private final int major;
    private final int minor;

    private SslVersion(int major, int minor) {
        this.major = major;
        this.minor = minor;
    }

    public int major() {
        return this.major;
    }

    public int minor() {
        return this.minor;
    }

    public static SslVersion decode(int version) {
        int majorVersion = version >> 8 & 0xFF;
        int minorVersion = version >> 0 & 0xFF;
        switch (majorVersion) {
            case 3: {
                switch (minorVersion) {
                    case 0: {
                        return SSL_3_0;
                    }
                    case 1: {
                        return TLS_1_0;
                    }
                    case 2: {
                        return TLS_1_1;
                    }
                    case 3: {
                        return TLS_1_2;
                    }
                }
                throw new IllegalArgumentException("Unrecognized minor version: " + minorVersion);
            }
        }
        throw new IllegalArgumentException("Unrecognized major version: " + majorVersion);
    }
}

