/**
 * Copyright 2007-2016, Kaazing Corporation. All rights reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.kaazing.gateway.transport.test;

import org.jmock.api.Invocation;
import org.jmock.lib.action.CustomAction;

public final class ReadBytes extends CustomAction {
    private final byte[] srcBytes;

    ReadBytes(String description, byte[] srcBytes) {
        super(description);
        this.srcBytes = srcBytes;
    }

    @Override
    public Object invoke(Invocation invocation) throws Throwable {
        byte[] destBytes = (byte[]) invocation.getParameter(0);
        int bytesCopied = Math.min(destBytes.length, srcBytes.length);
        System.arraycopy(srcBytes, 0, destBytes, 0, bytesCopied);
        return bytesCopied;
    }
}
