/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.k3po.control.internal;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.kaazing.k3po.control.internal.command.AbortCommand;
import org.kaazing.k3po.control.internal.command.AwaitCommand;
import org.kaazing.k3po.control.internal.command.Command;
import org.kaazing.k3po.control.internal.command.NotifyCommand;
import org.kaazing.k3po.control.internal.command.PrepareCommand;
import org.kaazing.k3po.control.internal.command.StartCommand;
import org.kaazing.k3po.control.internal.event.CommandEvent;
import org.kaazing.k3po.control.internal.event.ErrorEvent;
import org.kaazing.k3po.control.internal.event.FinishedEvent;
import org.kaazing.k3po.control.internal.event.NotifiedEvent;
import org.kaazing.k3po.control.internal.event.PreparedEvent;
import org.kaazing.k3po.control.internal.event.StartedEvent;

public final class Control {
    private static final String FINISHED_EVENT = "FINISHED";
    private static final String ERROR_EVENT = "ERROR";
    private static final String STARTED_EVENT = "STARTED";
    private static final String PREPARED_EVENT = "PREPARED";
    private static final String NOTIFIED_EVENT = "NOTIFIED";
    private static final Pattern HEADER_PATTERN = Pattern.compile("([a-z\\-]+):([^\n]+)");
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    private final URL location;
    private URLConnection connection;
    BufferedReader textIn;

    public Control(URL location) {
        this.location = location;
    }

    public void connect() throws Exception {
        URLConnection newConnection = this.location.openConnection();
        newConnection.connect();
        this.connection = newConnection;
        InputStream bytesIn = this.connection.getInputStream();
        CharsetDecoder decoder = UTF_8.newDecoder();
        this.textIn = new BufferedReader(new InputStreamReader(bytesIn, decoder));
    }

    public void disconnect() throws Exception {
        block9: {
            if (this.connection != null) {
                try {
                    if (this.connection instanceof Closeable) {
                        ((Closeable)((Object)this.connection)).close();
                        break block9;
                    }
                    try {
                        this.connection.getInputStream().close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    try {
                        this.connection.getOutputStream().close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                finally {
                    this.connection = null;
                }
            }
        }
    }

    public void writeCommand(Command command) throws Exception {
        this.checkConnected();
        switch (command.getKind()) {
            case PREPARE: {
                this.writeCommand((PrepareCommand)command);
                break;
            }
            case START: {
                this.writeCommand((StartCommand)command);
                break;
            }
            case ABORT: {
                this.writeCommand((AbortCommand)command);
                break;
            }
            case AWAIT: {
                this.writeCommand((AwaitCommand)command);
                break;
            }
            case NOTIFY: {
                this.writeCommand((NotifyCommand)command);
                break;
            }
            default: {
                throw new IllegalArgumentException("Urecognized command kind: " + (Object)((Object)command.getKind()));
            }
        }
    }

    public CommandEvent readEvent() throws Exception {
        return this.readEvent(0, TimeUnit.MILLISECONDS);
    }

    public CommandEvent readEvent(int timeout, TimeUnit unit) throws Exception {
        this.checkConnected();
        this.connection.setReadTimeout((int)unit.toMillis(timeout));
        String eventType = this.textIn.readLine();
        if (eventType != null) {
            switch (eventType) {
                case "PREPARED": {
                    return this.readPreparedEvent();
                }
                case "STARTED": {
                    return this.readStartedEvent();
                }
                case "ERROR": {
                    return this.readErrorEvent();
                }
                case "FINISHED": {
                    return this.readFinishedEvent();
                }
                case "NOTIFIED": {
                    return this.readNotifiedEvent();
                }
            }
        }
        throw new IllegalStateException("Invalid protocol frame: " + eventType);
    }

    private void checkConnected() throws Exception {
        if (this.connection == null) {
            throw new IllegalStateException("Not connected");
        }
    }

    public boolean isConnected() {
        return this.connection != null;
    }

    private void writeCommand(PrepareCommand prepare) throws Exception {
        OutputStream bytesOut = this.connection.getOutputStream();
        CharsetEncoder encoder = UTF_8.newEncoder();
        OutputStreamWriter textOut = new OutputStreamWriter(bytesOut, encoder);
        List<String> names = prepare.getNames();
        List<String> overriddenScriptProperties = prepare.getOverriddenScriptProperties();
        int contentLength = 0;
        StringBuilder content = new StringBuilder();
        if (overriddenScriptProperties != null) {
            for (String property : overriddenScriptProperties) {
                content.append(String.format("property %s\n", property));
            }
            contentLength = content.length();
        }
        ((Writer)textOut).append("PREPARE\n");
        ((Writer)textOut).append("version:2.0\n");
        ((Writer)textOut).append(String.format("content-length:%s\n", contentLength));
        for (String name : names) {
            ((Writer)textOut).append(String.format("name:%s\n", name));
        }
        ((Writer)textOut).append("\n");
        ((Writer)textOut).append(content.toString());
        ((Writer)textOut).flush();
    }

    private void writeCommand(StartCommand start) throws Exception {
        OutputStream bytesOut = this.connection.getOutputStream();
        CharsetEncoder encoder = UTF_8.newEncoder();
        OutputStreamWriter textOut = new OutputStreamWriter(bytesOut, encoder);
        ((Writer)textOut).append("START\n");
        ((Writer)textOut).append("\n");
        ((Writer)textOut).flush();
    }

    private void writeCommand(AbortCommand abort) throws IOException, CharacterCodingException {
        OutputStream bytesOut = this.connection.getOutputStream();
        CharsetEncoder encoder = UTF_8.newEncoder();
        OutputStreamWriter textOut = new OutputStreamWriter(bytesOut, encoder);
        ((Writer)textOut).append("ABORT\n");
        ((Writer)textOut).append("\n");
        ((Writer)textOut).flush();
    }

    private void writeCommand(NotifyCommand notify) throws IOException, CharacterCodingException {
        OutputStream bytesOut = this.connection.getOutputStream();
        CharsetEncoder encoder = UTF_8.newEncoder();
        OutputStreamWriter textOut = new OutputStreamWriter(bytesOut, encoder);
        ((Writer)textOut).append("NOTIFY\n");
        ((Writer)textOut).append(String.format("barrier:%s\n", notify.getBarrier()));
        ((Writer)textOut).append("\n");
        ((Writer)textOut).flush();
    }

    private void writeCommand(AwaitCommand await) throws IOException, CharacterCodingException {
        OutputStream bytesOut = this.connection.getOutputStream();
        CharsetEncoder encoder = UTF_8.newEncoder();
        OutputStreamWriter textOut = new OutputStreamWriter(bytesOut, encoder);
        ((Writer)textOut).append("AWAIT\n");
        ((Writer)textOut).append(String.format("barrier:%s\n", await.getBarrier()));
        ((Writer)textOut).append("\n");
        ((Writer)textOut).flush();
    }

    private PreparedEvent readPreparedEvent() throws IOException {
        String line;
        PreparedEvent prepared = new PreparedEvent();
        int length = -1;
        do {
            Matcher matcher;
            if (!(matcher = HEADER_PATTERN.matcher(line = this.textIn.readLine())).matches()) continue;
            String headerName = matcher.group(1);
            String headerValue = matcher.group(2);
            switch (headerName) {
                case "content-length": {
                    length = Integer.parseInt(headerValue);
                    break;
                }
                case "name": {
                    break;
                }
                case "barrier": {
                    prepared.getBarriers().add(headerValue);
                    break;
                }
            }
        } while (!line.isEmpty());
        if (length >= 0) {
            prepared.setScript(this.readContent(length));
        }
        return prepared;
    }

    private StartedEvent readStartedEvent() throws IOException {
        String line;
        StartedEvent started = new StartedEvent();
        do {
            String headerName;
            Matcher matcher;
            if (!(matcher = HEADER_PATTERN.matcher(line = this.textIn.readLine())).matches()) continue;
            switch (headerName = matcher.group(1)) {
                case "name": {
                    break;
                }
            }
        } while (!line.isEmpty());
        return started;
    }

    private FinishedEvent readFinishedEvent() throws IOException {
        String line;
        FinishedEvent finished = new FinishedEvent();
        int length = -1;
        do {
            Matcher matcher;
            if (!(matcher = HEADER_PATTERN.matcher(line = this.textIn.readLine())).matches()) continue;
            String headerName = matcher.group(1);
            String headerValue = matcher.group(2);
            switch (headerName) {
                case "content-length": {
                    length = Integer.parseInt(headerValue);
                    break;
                }
                case "name": {
                    break;
                }
                case "notified": {
                    finished.getCompletedBarriers().add(headerValue);
                    break;
                }
                case "awaiting": {
                    finished.getIncompleteBarriers().add(headerValue);
                    break;
                }
            }
        } while (!line.isEmpty());
        if (length >= 0) {
            finished.setScript(this.readContent(length));
        }
        return finished;
    }

    private NotifiedEvent readNotifiedEvent() throws IOException {
        String line;
        NotifiedEvent notified = new NotifiedEvent();
        do {
            Matcher matcher;
            if (!(matcher = HEADER_PATTERN.matcher(line = this.textIn.readLine())).matches()) continue;
            String headerName = matcher.group(1);
            String headerValue = matcher.group(2);
            switch (headerName) {
                case "barrier": {
                    notified.setBarrier(headerValue);
                    break;
                }
            }
        } while (!line.isEmpty());
        return notified;
    }

    private ErrorEvent readErrorEvent() throws IOException {
        String line;
        ErrorEvent error = new ErrorEvent();
        int length = 0;
        do {
            Matcher matcher;
            if (!(matcher = HEADER_PATTERN.matcher(line = this.textIn.readLine())).matches()) continue;
            String headerName = matcher.group(1);
            String headerValue = matcher.group(2);
            switch (headerName) {
                case "content-length": {
                    length = Integer.parseInt(headerValue);
                    break;
                }
                case "summary": {
                    error.setSummary(headerValue);
                    break;
                }
                case "name": {
                    break;
                }
            }
        } while (!line.isEmpty());
        if (length > 0) {
            error.setDescription(this.readContent(length));
        }
        return error;
    }

    private String readContent(int length) throws IOException {
        int result;
        char[] content = new char[length];
        int bytesRead = 0;
        do {
            if ((result = this.textIn.read(content, bytesRead, length - bytesRead)) != -1) continue;
            throw new EOFException("EOF detected before all content read");
        } while ((bytesRead += result) != length);
        return new String(content);
    }

    public void notifyBarrier(String barrierName) throws Exception {
        NotifyCommand notifyCommand = new NotifyCommand();
        notifyCommand.setBarrier(barrierName);
        this.writeCommand(notifyCommand);
    }

    public void sendAwaitBarrier(String barrierName) throws Exception {
        AwaitCommand awaitCommand = new AwaitCommand();
        awaitCommand.setBarrier(barrierName);
        this.writeCommand(awaitCommand);
    }
}

