/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.k3po.driver.internal.behavior;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.el.ExpressionFactory;
import org.jboss.netty.channel.ChannelPipeline;
import org.kaazing.k3po.driver.internal.behavior.Barrier;
import org.kaazing.k3po.driver.internal.resolver.ClientBootstrapResolver;
import org.kaazing.k3po.driver.internal.resolver.ServerBootstrapResolver;
import org.kaazing.k3po.lang.internal.RegionInfo;

public class Configuration {
    private List<ServerBootstrapResolver> serverResolvers;
    private List<ClientBootstrapResolver> clientResolvers;
    private List<ChannelPipeline> pipelines;
    private Set<Barrier> barriers;
    private ExpressionFactory factory;
    private Map<RegionInfo, List<ChannelPipeline>> serverPipelinesByRegion;
    private List<AutoCloseable> resources;

    public List<ChannelPipeline> getClientAndServerPipelines() {
        if (this.pipelines == null) {
            this.pipelines = new ArrayList<ChannelPipeline>();
        }
        return this.pipelines;
    }

    public List<ChannelPipeline> getServerPipelines(RegionInfo regionInfo) {
        List<ChannelPipeline> serverPipelines;
        if (this.serverPipelinesByRegion == null) {
            this.serverPipelinesByRegion = new HashMap<RegionInfo, List<ChannelPipeline>>();
        }
        if ((serverPipelines = this.serverPipelinesByRegion.get(regionInfo)) == null) {
            serverPipelines = new ArrayList<ChannelPipeline>();
            this.serverPipelinesByRegion.put(regionInfo, serverPipelines);
        }
        return serverPipelines;
    }

    public ExpressionFactory getExpressionFactory() {
        if (this.factory == null) {
            this.factory = ExpressionFactory.newInstance();
        }
        return this.factory;
    }

    public List<ServerBootstrapResolver> getServerResolvers() {
        if (this.serverResolvers == null) {
            this.serverResolvers = new ArrayList<ServerBootstrapResolver>();
        }
        return this.serverResolvers;
    }

    public List<ClientBootstrapResolver> getClientResolvers() {
        if (this.clientResolvers == null) {
            this.clientResolvers = new ArrayList<ClientBootstrapResolver>();
        }
        return this.clientResolvers;
    }

    public Set<Barrier> getBarriers() {
        if (this.barriers == null) {
            this.barriers = new HashSet<Barrier>();
        }
        return this.barriers;
    }

    public List<AutoCloseable> getResources() {
        if (this.resources == null) {
            this.resources = new ArrayList<AutoCloseable>();
        }
        return this.resources;
    }
}

