/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.k3po.driver.internal.behavior;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.kaazing.k3po.lang.internal.RegionInfo;

public class ScriptProgress {
    private final String expectedScript;
    private final RegionInfo scriptInfo;
    private final Map<RegionInfo, String> failureInfos;
    private String observeredScript;

    public ScriptProgress(RegionInfo scriptInfo, String expectedScript) {
        this.expectedScript = expectedScript;
        this.scriptInfo = Objects.requireNonNull(scriptInfo);
        this.failureInfos = new ConcurrentHashMap<RegionInfo, String>();
    }

    public void addScriptFailure(RegionInfo regionInfo) {
        this.failureInfos.put(regionInfo, "");
    }

    public void addScriptFailure(RegionInfo regionInfo, String message) {
        this.failureInfos.put(regionInfo, message);
    }

    public String getExpectedScript() {
        return this.expectedScript;
    }

    public RegionInfo getScriptInfo() {
        return this.scriptInfo;
    }

    public String getObservedScript() {
        if (this.observeredScript == null) {
            int numberOfFailures = this.failureInfos.size();
            if (numberOfFailures == 0) {
                this.observeredScript = this.expectedScript;
            } else {
                StringBuilder builder = new StringBuilder();
                this.processRegion(builder, this.scriptInfo, this.failureInfos);
                if (numberOfFailures <= this.failureInfos.size()) {
                    throw new RuntimeException("Script failure detected but not located");
                }
                this.observeredScript = builder.toString();
            }
        }
        return this.observeredScript;
    }

    private boolean processRegion(StringBuilder builder, RegionInfo regionInfo, Map<RegionInfo, String> failureInfos) {
        String failure = failureInfos.remove(regionInfo);
        if (failure != null) {
            builder.append(failure);
            return regionInfo.kind == RegionInfo.Kind.PARALLEL;
        }
        List childInfos = regionInfo.children;
        int previousEnd = regionInfo.start;
        Iterator $i = childInfos.iterator();
        while ($i.hasNext()) {
            RegionInfo childInfo = (RegionInfo)$i.next();
            builder.append(this.expectedScript.substring(previousEnd, childInfo.start));
            previousEnd = childInfo.end;
            boolean status = this.processRegion(builder, childInfo, failureInfos);
            if (status) continue;
            if (regionInfo.kind == RegionInfo.Kind.PARALLEL) {
                while ($i.hasNext()) {
                    childInfo = (RegionInfo)$i.next();
                    previousEnd = childInfo.end;
                }
                break;
            }
            return false;
        }
        builder.append(this.expectedScript.substring(previousEnd, regionInfo.end));
        return true;
    }
}

