/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.k3po.driver.internal.behavior.handler;

import java.util.concurrent.atomic.AtomicBoolean;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelEvent;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.DefaultChannelFuture;
import org.jboss.netty.channel.LifeCycleAwareChannelHandler;
import org.kaazing.k3po.driver.internal.behavior.ScriptProgressException;
import org.kaazing.k3po.driver.internal.behavior.handler.prepare.PreparationEvent;
import org.kaazing.k3po.driver.internal.behavior.handler.prepare.SimplePrepareUpstreamHandler;
import org.kaazing.k3po.driver.internal.channel.Channels;
import org.kaazing.k3po.driver.internal.netty.channel.ChannelFutures;
import org.kaazing.k3po.lang.internal.RegionInfo;

public class ExecutionHandler
extends SimplePrepareUpstreamHandler
implements LifeCycleAwareChannelHandler {
    private ChannelFuture handlerFuture;
    private ChannelFuture pipelineFuture;
    private RegionInfo regionInfo;
    private final AtomicBoolean preparationLatch = new AtomicBoolean();
    private Channel channel;

    public RegionInfo getRegionInfo() {
        return this.regionInfo;
    }

    public void setRegionInfo(RegionInfo regionInfo) {
        this.regionInfo = regionInfo;
    }

    public Channel getChannel() {
        return this.channel;
    }

    @Override
    public void prepareRequested(ChannelHandlerContext ctx, PreparationEvent evt) {
        this.channel = ctx.getChannel();
        this.preparationLatch.set(true);
        this.pipelineFuture = evt.checkpoint(this.handlerFuture);
        super.prepareRequested(ctx, evt);
    }

    public void beforeAdd(final ChannelHandlerContext ctx) throws Exception {
        assert (this.handlerFuture == null);
        this.handlerFuture = new DefaultChannelFuture(null, false){

            public Channel getChannel() {
                return ctx.getChannel();
            }

            public String toString() {
                return ExecutionHandler.this.toString();
            }
        };
    }

    public void afterAdd(ChannelHandlerContext ctx) throws Exception {
        assert (this.handlerFuture != null);
    }

    public void beforeRemove(ChannelHandlerContext ctx) throws Exception {
        assert (this.handlerFuture != null);
    }

    public void afterRemove(ChannelHandlerContext ctx) throws Exception {
        assert (this.handlerFuture != null);
        if (!this.handlerFuture.isDone()) {
            ScriptProgressException exception = new ScriptProgressException(this.getRegionInfo(), "");
            exception.fillInStackTrace();
            this.handlerFuture.setFailure((Throwable)exception);
        }
        this.handlerFuture = null;
    }

    public ChannelFuture getHandlerFuture() {
        if (this.handlerFuture == null) {
            throw new IllegalStateException("ChannelHandler not added to pipeline yet");
        }
        return this.handlerFuture;
    }

    public ChannelFuture getPipelineFuture() {
        if (this.pipelineFuture == null) {
            throw new IllegalStateException("ChannelHandler not prepared yet");
        }
        return this.pipelineFuture;
    }

    @Override
    protected final void handleUpstream0(ChannelHandlerContext ctx, ChannelEvent e) throws Exception {
        if (this.preparationLatch.compareAndSet(false, true)) {
            Channels.prepare(ctx.getChannel());
        }
        this.handleUpstream1(ctx, e);
    }

    protected void handleUpstream1(ChannelHandlerContext ctx, ChannelEvent e) throws Exception {
        super.handleUpstream0(ctx, e);
    }

    public final String toString() {
        return this.describe(new StringBuilder()).append(" (").append(ChannelFutures.describeFuture(this.getHandlerFuture())).append(')').toString();
    }

    protected StringBuilder describe(StringBuilder sb) {
        return sb.append("execution");
    }
}

