/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.k3po.driver.internal.behavior.handler.barrier;

import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.jboss.netty.channel.ChannelDownstreamHandler;
import org.jboss.netty.channel.ChannelEvent;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.kaazing.k3po.driver.internal.behavior.Barrier;
import org.kaazing.k3po.driver.internal.behavior.handler.barrier.AbstractBarrierHandler;
import org.kaazing.k3po.driver.internal.behavior.handler.prepare.PreparationEvent;
import org.kaazing.k3po.driver.internal.netty.channel.ChannelFutureListeners;

public class AwaitBarrierDownstreamHandler
extends AbstractBarrierHandler
implements ChannelDownstreamHandler {
    private Queue<ChannelEvent> queue;

    public AwaitBarrierDownstreamHandler(Barrier barrier) {
        super(barrier);
    }

    @Override
    public void prepareRequested(final ChannelHandlerContext ctx, PreparationEvent evt) {
        super.prepareRequested(ctx, evt);
        final ChannelFuture handlerFuture = this.getHandlerFuture();
        ChannelFuture pipelineFuture = this.getPipelineFuture();
        pipelineFuture.addListener(new ChannelFutureListener(){

            public void operationComplete(ChannelFuture f) throws Exception {
                if (!f.isSuccess()) {
                    if (f.isCancelled()) {
                        handlerFuture.cancel();
                    } else {
                        handlerFuture.setFailure(f.getCause());
                    }
                } else {
                    Barrier barrier = AwaitBarrierDownstreamHandler.this.getBarrier();
                    ChannelFuture barrierFuture = barrier.getFuture();
                    barrierFuture.addListener(ChannelFutureListeners.chainedFuture(handlerFuture));
                }
            }
        });
        this.queue = new ConcurrentLinkedQueue<ChannelEvent>();
        handlerFuture.addListener(new ChannelFutureListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void operationComplete(ChannelFuture future) throws Exception {
                if (future.isSuccess()) {
                    ChannelHandlerContext channelHandlerContext = ctx;
                    synchronized (channelHandlerContext) {
                        Queue pending = AwaitBarrierDownstreamHandler.this.queue;
                        AwaitBarrierDownstreamHandler.this.queue = null;
                        for (ChannelEvent evt : pending) {
                            ctx.sendDownstream(evt);
                        }
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleDownstream(ChannelHandlerContext ctx, ChannelEvent evt) throws Exception {
        ChannelFuture pipelineFuture = this.getPipelineFuture();
        ChannelFuture handlerFuture = this.getHandlerFuture();
        if (this.queue != null && pipelineFuture.isDone() && !handlerFuture.isDone()) {
            this.queue.add(evt);
        } else {
            ChannelHandlerContext channelHandlerContext = ctx;
            synchronized (channelHandlerContext) {
                ctx.sendDownstream(evt);
            }
        }
    }

    @Override
    protected StringBuilder describe(StringBuilder sb) {
        return sb.append(String.format("write await %s", this.getBarrier()));
    }

    boolean hasQueuedChannelEvents() {
        return this.queue != null && !this.queue.isEmpty();
    }
}

