/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.k3po.driver.internal.behavior.handler.codec;

import javax.el.ELContext;
import javax.el.ValueExpression;
import org.jboss.netty.buffer.ChannelBuffer;
import org.kaazing.k3po.driver.internal.behavior.handler.codec.Masker;
import org.kaazing.k3po.lang.internal.el.ExpressionContext;

public final class Maskers {
    public static Masker newMasker(byte[] maskingKey) {
        for (byte aMaskingKey : maskingKey) {
            if (aMaskingKey == 0) continue;
            return new ExactBytesMasker(maskingKey);
        }
        return Masker.IDENTITY_MASKER;
    }

    public static Masker newMasker(ValueExpression expression, ExpressionContext environment) {
        return new ExpressionMasker(expression, environment);
    }

    private Maskers() {
    }

    private static abstract class AbstractMasker
    extends Masker {
        private int offset;

        private AbstractMasker() {
        }

        protected final ChannelBuffer applyMask(ChannelBuffer buffer, byte[] maskingKey) throws Exception {
            int readerIndex = buffer.readerIndex();
            int writerIndex = buffer.writerIndex();
            for (int index = readerIndex; index < writerIndex; ++index) {
                int maskIndex = (index + this.offset) % maskingKey.length;
                byte mask = maskingKey[maskIndex];
                if (mask == 0) continue;
                byte value = buffer.getByte(index);
                value = (byte)(value ^ mask);
                buffer.setByte(index, (int)value);
            }
            this.offset = (this.offset + writerIndex - readerIndex) % maskingKey.length;
            return buffer;
        }

        protected final ChannelBuffer undoMask(ChannelBuffer buffer, byte[] maskingKey) throws Exception {
            int readerIndex = buffer.readerIndex();
            int writerIndex = buffer.writerIndex();
            this.offset = (this.offset - (writerIndex - readerIndex)) % maskingKey.length;
            if (this.offset < 0) {
                this.offset += maskingKey.length;
            }
            for (int index = readerIndex; index < writerIndex; ++index) {
                int maskIndex = (index + this.offset) % maskingKey.length;
                byte mask = maskingKey[maskIndex];
                if (mask == 0) continue;
                byte value = buffer.getByte(index);
                value = (byte)(value ^ mask);
                buffer.setByte(index, (int)value);
            }
            return buffer;
        }
    }

    private static class ExpressionMasker
    extends AbstractMasker {
        private final ValueExpression expression;
        private final ExpressionContext environment;

        public ExpressionMasker(ValueExpression expression, ExpressionContext environment) {
            this.expression = expression;
            this.environment = environment;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ChannelBuffer applyMask(ChannelBuffer buffer) throws Exception {
            byte[] maskingKey;
            ExpressionContext expressionContext = this.environment;
            synchronized (expressionContext) {
                maskingKey = (byte[])this.expression.getValue((ELContext)this.environment);
            }
            return this.applyMask(buffer, maskingKey);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ChannelBuffer undoMask(ChannelBuffer buffer) throws Exception {
            byte[] maskingKey;
            ExpressionContext expressionContext = this.environment;
            synchronized (expressionContext) {
                maskingKey = (byte[])this.expression.getValue((ELContext)this.environment);
            }
            return this.undoMask(buffer, maskingKey);
        }
    }

    private static class ExactBytesMasker
    extends AbstractMasker {
        private final byte[] maskingKey;

        public ExactBytesMasker(byte[] maskingKey) {
            this.maskingKey = maskingKey;
        }

        @Override
        public ChannelBuffer applyMask(ChannelBuffer buffer) throws Exception {
            return this.applyMask(buffer, this.maskingKey);
        }

        @Override
        public ChannelBuffer undoMask(ChannelBuffer buffer) throws Exception {
            return this.undoMask(buffer, this.maskingKey);
        }
    }
}

