/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.k3po.driver.internal.behavior.handler.codec;

import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.kaazing.k3po.driver.internal.behavior.ScriptProgressException;
import org.kaazing.k3po.driver.internal.behavior.handler.codec.MessageDecoder;
import org.kaazing.k3po.driver.internal.util.Utils;
import org.kaazing.k3po.lang.internal.RegionInfo;

public class ReadExactBytesDecoder
extends MessageDecoder {
    private final ChannelBuffer expected;

    public ReadExactBytesDecoder(RegionInfo regionInfo, byte[] expected) {
        super(regionInfo);
        this.expected = ChannelBuffers.copiedBuffer((byte[])expected);
    }

    @Override
    protected Object decodeBuffer(ChannelBuffer buffer) throws Exception {
        if (buffer.readableBytes() < this.expected.readableBytes()) {
            return null;
        }
        ChannelBuffer observed = buffer.readSlice(this.expected.readableBytes());
        if (!observed.equals((Object)this.expected)) {
            throw new ScriptProgressException(this.getRegionInfo(), Utils.format(observed));
        }
        return buffer;
    }

    public String toString() {
        return Utils.format(this.expected.array());
    }

    ReadExactBytesDecoder(byte[] expected) {
        this(RegionInfo.newSequential((int)0, (int)0), expected);
    }
}

