/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.k3po.driver.internal.behavior.handler.codec;

import java.nio.charset.Charset;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.util.CharsetUtil;
import org.kaazing.k3po.driver.internal.behavior.ScriptProgressException;
import org.kaazing.k3po.driver.internal.behavior.handler.codec.MessageDecoder;
import org.kaazing.k3po.lang.internal.RegionInfo;

public class ReadExactTextDecoder
extends MessageDecoder {
    private final ChannelBuffer expected;
    private final Charset charset;

    public ReadExactTextDecoder(RegionInfo regionInfo, String expected, Charset charset) {
        super(regionInfo);
        this.expected = ChannelBuffers.copiedBuffer((CharSequence)expected, (Charset)charset);
        this.charset = charset;
    }

    @Override
    protected Object decodeBufferLast(ChannelBuffer buffer) throws Exception {
        if (buffer.readableBytes() < this.expected.readableBytes()) {
            String observedText = buffer.toString(this.charset);
            throw new ScriptProgressException(this.getRegionInfo(), String.format("\"%s\"", observedText));
        }
        return super.decodeBufferLast(buffer);
    }

    @Override
    protected Object decodeBuffer(ChannelBuffer buffer) throws Exception {
        if (buffer.readableBytes() < this.expected.readableBytes()) {
            return null;
        }
        ChannelBuffer observed = buffer.readSlice(this.expected.readableBytes());
        if (!observed.equals((Object)this.expected)) {
            String observedText = observed.toString(this.charset);
            observedText = observedText.replace("\r", "\\r");
            observedText = observedText.replace("\n", "\\n");
            observedText = observedText.replace("\t", "\\t");
            throw new ScriptProgressException(this.getRegionInfo(), String.format("\"%s\"", observedText));
        }
        return buffer;
    }

    public String toString() {
        return String.format("\"%s\"", this.expected.toString(CharsetUtil.UTF_8));
    }

    ReadExactTextDecoder(String expected, Charset charset) {
        this(RegionInfo.newSequential((int)0, (int)0), expected, charset);
    }
}

