/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.k3po.driver.internal.behavior.handler.codec;

import javax.el.ELContext;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.logging.InternalLogger;
import org.jboss.netty.logging.InternalLoggerFactory;
import org.kaazing.k3po.driver.internal.behavior.handler.codec.MessageDecoder;
import org.kaazing.k3po.lang.internal.RegionInfo;
import org.kaazing.k3po.lang.internal.ast.value.AstLiteralBytesValue;
import org.kaazing.k3po.lang.internal.el.ExpressionContext;
import org.kaazing.k3po.lang.internal.parser.ScriptParseException;

public abstract class ReadFixedLengthBytesDecoder<T>
extends MessageDecoder {
    private static final InternalLogger LOGGER = InternalLoggerFactory.getInstance(ReadFixedLengthBytesDecoder.class);
    private final int length;
    private final ExpressionContext environment;
    private final String captureName;

    public ReadFixedLengthBytesDecoder(RegionInfo regionInfo, int length) {
        this(regionInfo, length, null, null);
    }

    public ReadFixedLengthBytesDecoder(RegionInfo regionInfo, int length, ExpressionContext environment, String captureName) {
        super(regionInfo);
        this.length = length;
        this.environment = environment;
        this.captureName = captureName;
    }

    protected abstract T readBuffer(ChannelBuffer var1);

    public int getLength() {
        return this.length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Object decodeBufferLast(ChannelBuffer buffer) throws Exception {
        if (buffer.readableBytes() < this.length) {
            throw new ScriptParseException("Not enough bytes");
        }
        if (this.captureName == null) {
            buffer.readSlice(this.length);
        } else {
            T value = this.readBuffer(buffer);
            ExpressionContext expressionContext = this.environment;
            synchronized (expressionContext) {
                this.environment.getELResolver().setValue((ELContext)this.environment, null, (Object)this.captureName, value);
            }
            if (LOGGER.isDebugEnabled()) {
                T formatValue = value instanceof byte[] ? AstLiteralBytesValue.toString((byte[])((byte[])value)) : value;
                LOGGER.debug(String.format("Setting value for ${%s} to %s", this.captureName, formatValue));
            }
        }
        return buffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Object decodeBuffer(ChannelBuffer buffer) throws Exception {
        if (buffer.readableBytes() < this.length) {
            return null;
        }
        if (this.captureName == null) {
            buffer.readSlice(this.length);
        } else {
            T value = this.readBuffer(buffer);
            ExpressionContext expressionContext = this.environment;
            synchronized (expressionContext) {
                this.environment.getELResolver().setValue((ELContext)this.environment, null, (Object)this.captureName, value);
            }
            if (LOGGER.isDebugEnabled()) {
                T formatValue = value instanceof byte[] ? AstLiteralBytesValue.toString((byte[])((byte[])value)) : value;
                LOGGER.debug(String.format("Setting value for ${%s} to %s", this.captureName, formatValue));
            }
        }
        return buffer;
    }

    public String toString() {
        return String.format("%d bytes", this.length);
    }
}

