/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.k3po.driver.internal.behavior.handler.codec;

import java.nio.charset.Charset;
import javax.el.ELContext;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.logging.InternalLogger;
import org.jboss.netty.logging.InternalLoggerFactory;
import org.kaazing.k3po.driver.internal.behavior.ScriptProgressException;
import org.kaazing.k3po.driver.internal.behavior.handler.codec.MessageDecoder;
import org.kaazing.k3po.lang.internal.RegionInfo;
import org.kaazing.k3po.lang.internal.el.ExpressionContext;
import org.kaazing.k3po.lang.internal.regex.NamedGroupMatcher;
import org.kaazing.k3po.lang.internal.regex.NamedGroupPattern;

public class ReadRegexDecoder
extends MessageDecoder {
    private static final InternalLogger LOGGER = InternalLoggerFactory.getInstance(ReadRegexDecoder.class);
    private final NamedGroupPattern pattern;
    private final Charset charset;
    private final ExpressionContext environment;

    public ReadRegexDecoder(RegionInfo regionInfo, NamedGroupPattern pattern, Charset charset, ExpressionContext environment) {
        super(regionInfo);
        this.pattern = pattern;
        this.environment = environment;
        this.charset = charset;
    }

    public String toString() {
        return String.format("/%s/", this.pattern);
    }

    @Override
    protected Object decodeBufferLast(ChannelBuffer buffer) throws Exception {
        return this.decodeBuffer(buffer, true);
    }

    @Override
    protected Object decodeBuffer(ChannelBuffer buffer) throws Exception {
        return this.decodeBuffer(buffer, false);
    }

    ReadRegexDecoder(NamedGroupPattern pattern, Charset charset, ExpressionContext environment) {
        this(RegionInfo.newSequential((int)0, (int)0), pattern, charset, environment);
    }

    private Object decodeBuffer(ChannelBuffer buffer, boolean isLast) throws Exception {
        boolean noMatchMayMatchLater;
        ChannelBuffer observedBytes = buffer.slice();
        String observed = observedBytes.toString(this.charset);
        NamedGroupMatcher matcher = this.pattern.matcher((CharSequence)observed);
        boolean allInputMatched = matcher.matches();
        boolean prefixMatched = allInputMatched || matcher.lookingAt();
        boolean bl = noMatchMayMatchLater = !prefixMatched && matcher.hitEnd();
        if ((allInputMatched || !isLast) && noMatchMayMatchLater) {
            return null;
        }
        if (!prefixMatched) {
            throw new ScriptProgressException(this.getRegionInfo(), String.format("\"%s\"", observed));
        }
        this.captureGroups(matcher);
        buffer.skipBytes(matcher.end());
        return buffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void captureGroups(NamedGroupMatcher matcher) {
        for (String captureName : matcher.groupNames()) {
            String captured = matcher.group(captureName);
            ExpressionContext expressionContext = this.environment;
            synchronized (expressionContext) {
                this.environment.getELResolver().setValue((ELContext)this.environment, null, (Object)captureName, (Object)captured);
            }
            if (!LOGGER.isDebugEnabled()) continue;
            LOGGER.debug(String.format("Setting value for ${%s} to %s", captureName, captured));
        }
    }
}

