/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.k3po.driver.internal.behavior.handler.codec.http;

import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.handler.codec.http.QueryStringDecoder;
import org.jboss.netty.util.CharsetUtil;
import org.kaazing.k3po.driver.internal.behavior.ScriptProgressException;
import org.kaazing.k3po.driver.internal.behavior.handler.codec.AbstractConfigDecoder;
import org.kaazing.k3po.driver.internal.behavior.handler.codec.MessageDecoder;
import org.kaazing.k3po.driver.internal.netty.bootstrap.http.HttpChannelConfig;

public class HttpParameterDecoder
extends AbstractConfigDecoder {
    private String name;
    private List<MessageDecoder> valueDecoders;

    public HttpParameterDecoder(String name, List<MessageDecoder> valueDecoders) {
        this.name = name;
        this.valueDecoders = valueDecoders;
    }

    @Override
    public void decode(Channel channel) throws Exception {
        HttpChannelConfig httpConfig = (HttpChannelConfig)channel.getConfig();
        QueryStringDecoder query = httpConfig.getReadQuery();
        Map parameters = query.getParameters();
        List parameterValues = (List)parameters.get(this.name);
        if (this.valueDecoders.size() == 1) {
            MessageDecoder valueDecoder = this.valueDecoders.get(0);
            this.decodeParameterValue(parameters, parameterValues, valueDecoder);
        } else {
            for (MessageDecoder valueDecoder : this.valueDecoders) {
                this.decodeParameterValue(parameters, parameterValues, valueDecoder);
            }
        }
    }

    public String toString() {
        return String.format("http:parameter %s %s", this.name, this.valueDecoders);
    }

    private void decodeParameterValue(Map<String, List<String>> parameters, List<String> parameterValues, MessageDecoder valueDecoder) throws Exception {
        int parameterValueCount = parameterValues.size();
        if (parameterValueCount == 0) {
            throw new ScriptProgressException(this.getRegionInfo(), String.format("Missing HTTP query parameter: %s", this.name));
        }
        if (parameterValueCount == 1) {
            String parameterValue = parameterValues.get(0);
            valueDecoder.decodeLast(ChannelBuffers.copiedBuffer((CharSequence)parameterValue, (Charset)CharsetUtil.UTF_8));
        } else {
            Exception decodeFailure = null;
            Iterator<String> $i = parameterValues.iterator();
            while ($i.hasNext()) {
                String parameterValue = $i.next();
                try {
                    valueDecoder.decodeLast(ChannelBuffers.copiedBuffer((CharSequence)parameterValue, (Charset)CharsetUtil.UTF_8));
                    $i.remove();
                    break;
                }
                catch (Exception e) {
                    decodeFailure = e;
                }
            }
            if (parameterValues.size() != parameterValueCount) {
                parameters.put(this.name, parameterValues);
            } else {
                assert (decodeFailure != null);
                throw decodeFailure;
            }
        }
    }
}

