/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.k3po.driver.internal.behavior.handler.codec.http;

import java.nio.charset.Charset;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;
import org.jboss.netty.util.CharsetUtil;
import org.kaazing.k3po.driver.internal.behavior.handler.codec.AbstractConfigDecoder;
import org.kaazing.k3po.driver.internal.behavior.handler.codec.MessageDecoder;
import org.kaazing.k3po.driver.internal.netty.bootstrap.http.HttpChannelConfig;

public class HttpStatusDecoder
extends AbstractConfigDecoder {
    private final MessageDecoder codeDecoder;
    private final MessageDecoder reasonDecoder;

    public HttpStatusDecoder(MessageDecoder codeDecoder, MessageDecoder reasonDecoder) {
        this.codeDecoder = codeDecoder;
        this.reasonDecoder = reasonDecoder;
    }

    @Override
    public void decode(Channel channel) throws Exception {
        HttpChannelConfig httpConfig = (HttpChannelConfig)channel.getConfig();
        HttpResponseStatus status = httpConfig.getStatus();
        String code = Integer.toString(status.getCode());
        String reason = status.getReasonPhrase();
        ChannelBuffer buffer = ChannelBuffers.copiedBuffer((CharSequence)code, (Charset)CharsetUtil.UTF_8);
        this.codeDecoder.decode(buffer);
        buffer = ChannelBuffers.copiedBuffer((CharSequence)reason, (Charset)CharsetUtil.UTF_8);
        this.reasonDecoder.decode(buffer);
    }

    public String toString() {
        return String.format("http:status %s %s", this.codeDecoder, this.reasonDecoder);
    }
}

