/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.k3po.driver.internal.behavior.handler.command;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.Channels;
import org.kaazing.k3po.driver.internal.behavior.handler.codec.ConfigDecoder;
import org.kaazing.k3po.driver.internal.behavior.handler.command.AbstractCommandHandler;

public class ReadConfigHandler
extends AbstractCommandHandler {
    private final List<ConfigDecoder> decoders;
    private ChannelFuture readableFuture;

    public ReadConfigHandler(ConfigDecoder decoder) {
        this(Collections.singletonList(decoder));
    }

    public ReadConfigHandler(List<ConfigDecoder> decoders) {
        Objects.requireNonNull(decoders, "decoders");
        if (decoders.size() == 0) {
            throw new IllegalArgumentException("must have at least one decoder");
        }
        this.decoders = decoders;
        this.readableFuture = Channels.future(null);
    }

    public void channelInterestChanged(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        Channel channel = ctx.getChannel();
        int interestOps = channel.getInterestOps();
        if ((interestOps & 1) != 0) {
            this.readableFuture.setSuccess();
        }
    }

    @Override
    protected void invokeCommand(final ChannelHandlerContext ctx) throws Exception {
        Channel channel = ctx.getChannel();
        if (channel.isReadable()) {
            this.invokeCommandWhenReadable(ctx);
        } else {
            this.readableFuture.addListener(new ChannelFutureListener(){

                public void operationComplete(ChannelFuture future) throws Exception {
                    if (future.isSuccess()) {
                        ReadConfigHandler.this.invokeCommandWhenReadable(ctx);
                    }
                }
            });
        }
    }

    private void invokeCommandWhenReadable(ChannelHandlerContext ctx) {
        Channel channel = ctx.getChannel();
        try {
            for (ConfigDecoder decoder : this.decoders) {
                decoder.decode(channel);
            }
            this.getHandlerFuture().setSuccess();
        }
        catch (Exception e) {
            this.getHandlerFuture().setFailure((Throwable)e);
        }
    }

    @Override
    protected StringBuilder describe(StringBuilder sb) {
        return sb.append(String.format("read config %s", this.decoders));
    }
}

