/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.k3po.driver.internal.behavior.handler.command;

import org.jboss.netty.channel.ChannelEvent;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.logging.InternalLogger;
import org.jboss.netty.logging.InternalLoggerFactory;
import org.kaazing.k3po.driver.internal.behavior.handler.command.AbstractCommandHandler;
import org.kaazing.k3po.driver.internal.netty.bootstrap.file.FileChannel;

public class ReadOptionOffsetHandler
extends AbstractCommandHandler {
    private static final InternalLogger LOGGER = InternalLoggerFactory.getInstance(ReadOptionOffsetHandler.class);
    private final int offset;

    public ReadOptionOffsetHandler(int offset) {
        this.offset = offset;
    }

    @Override
    protected void handleUpstream1(ChannelHandlerContext ctx, ChannelEvent e) throws Exception {
        if (!(e instanceof MessageEvent)) {
            super.handleUpstream1(ctx, e);
        }
    }

    @Override
    protected void invokeCommand(ChannelHandlerContext ctx) throws Exception {
        FileChannel channel = (FileChannel)ctx.getChannel();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(String.format("Adjusting the file %s channel for read option offset %d", new Object[]{channel, this.offset}));
        }
        try {
            channel.setReadOffset(this.offset);
            this.getHandlerFuture().setSuccess();
        }
        catch (Throwable t) {
            this.getHandlerFuture().setFailure(t);
        }
        channel.fireMessageReceived(ctx);
    }

    @Override
    protected StringBuilder describe(StringBuilder sb) {
        return sb.append(String.format("read option offset %d", this.offset));
    }
}

