/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.k3po.driver.internal.behavior.handler.command;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.kaazing.k3po.driver.internal.behavior.handler.codec.ConfigEncoder;
import org.kaazing.k3po.driver.internal.behavior.handler.command.AbstractCommandHandler;

public class WriteConfigHandler
extends AbstractCommandHandler {
    private final List<ConfigEncoder> encoders;

    public WriteConfigHandler(ConfigEncoder encoder) {
        this(Collections.singletonList(encoder));
    }

    public WriteConfigHandler(List<ConfigEncoder> encoders) {
        Objects.requireNonNull(encoders, "encoders");
        if (encoders.size() == 0) {
            throw new IllegalArgumentException("must have at least one encoder");
        }
        this.encoders = encoders;
    }

    @Override
    protected void invokeCommand(ChannelHandlerContext ctx) throws Exception {
        try {
            Channel channel = ctx.getChannel();
            for (ConfigEncoder encoder : this.encoders) {
                encoder.encode(channel);
            }
            this.getHandlerFuture().setSuccess();
        }
        catch (Exception e) {
            this.getHandlerFuture().setFailure((Throwable)e);
        }
    }

    @Override
    protected StringBuilder describe(StringBuilder sb) {
        return sb.append(String.format("write config %s", this.encoders));
    }
}

