/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.k3po.driver.internal.behavior.handler.event;

import java.net.SocketAddress;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import javax.el.ELException;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelEvent;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.UpstreamMessageEvent;
import org.jboss.netty.util.CharsetUtil;
import org.kaazing.k3po.driver.internal.behavior.ScriptProgressException;
import org.kaazing.k3po.driver.internal.behavior.handler.codec.Masker;
import org.kaazing.k3po.driver.internal.behavior.handler.codec.MessageDecoder;
import org.kaazing.k3po.driver.internal.behavior.handler.event.AbstractEventHandler;

public class ReadHandler
extends AbstractEventHandler {
    private final List<MessageDecoder> decoders;
    private final Masker unmasker;
    private final List<MessageDecoder> consumedDecoders;

    public ReadHandler(List<MessageDecoder> decoders, Masker unmasker) {
        super(EnumSet.of(AbstractEventHandler.ChannelEventKind.MESSAGE));
        if (decoders == null) {
            throw new NullPointerException("decoders");
        }
        if (decoders.size() == 0) {
            throw new IllegalArgumentException("must have at least one decoder");
        }
        this.decoders = decoders;
        this.unmasker = unmasker;
        this.consumedDecoders = new ArrayList<MessageDecoder>(decoders);
    }

    public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
        this.messageReceived(ctx, e, false);
    }

    @Override
    protected StringBuilder describe(StringBuilder sb) {
        sb.append("read ");
        for (MessageDecoder decoder : this.decoders) {
            sb.append(decoder).append(' ');
        }
        sb.setLength(sb.length() - 1);
        return sb;
    }

    @Override
    protected void handleUnexpectedEvent(ChannelHandlerContext ctx, ChannelEvent evt) throws Exception {
        Channel channel = evt.getChannel();
        UpstreamMessageEvent msg = new UpstreamMessageEvent(channel, (Object)ChannelBuffers.copiedBuffer((CharSequence)"", (Charset)CharsetUtil.UTF_8), channel.getRemoteAddress());
        this.messageReceived(ctx, (MessageEvent)msg, true);
        if (!this.getHandlerFuture().isDone()) {
            super.handleUnexpectedEvent(ctx, evt);
        }
    }

    private void messageReceived(ChannelHandlerContext ctx, MessageEvent e, boolean isLast) throws Exception {
        ChannelBuffer buf = (ChannelBuffer)e.getMessage();
        buf = this.unmasker.applyMask(buf);
        ChannelFuture handlerFuture = this.getHandlerFuture();
        assert (handlerFuture != null);
        Iterator<MessageDecoder> iterator = this.consumedDecoders.iterator();
        while (iterator.hasNext()) {
            MessageDecoder decoder = iterator.next();
            try {
                buf = isLast ? decoder.decodeLast(buf) : decoder.decode(buf);
            }
            catch (ELException ele) {
                ScriptProgressException exception = new ScriptProgressException(this.getRegionInfo(), ele.getMessage());
                exception.initCause(ele);
                exception.fillInStackTrace();
                handlerFuture.setFailure((Throwable)exception);
                return;
            }
            catch (Exception mme) {
                handlerFuture.setFailure((Throwable)mme);
                return;
            }
            if (buf == null) {
                return;
            }
            iterator.remove();
        }
        handlerFuture.setSuccess();
        if (buf.readable()) {
            buf = this.unmasker.undoMask(buf);
            Channels.fireMessageReceived((ChannelHandlerContext)ctx, (Object)buf, (SocketAddress)ctx.getChannel().getRemoteAddress());
        }
    }
}

