/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.k3po.driver.internal.channel;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.URI;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelEvent;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.socket.nio.NioDatagramChannel;
import org.kaazing.k3po.driver.internal.behavior.handler.prepare.UpstreamPreparationEvent;
import org.kaazing.k3po.driver.internal.netty.channel.ChannelAddress;

public final class Channels {
    public static ChannelFuture prepare(Channel channel) {
        ChannelPipeline pipeline = channel.getPipeline();
        ChannelFuture future = org.jboss.netty.channel.Channels.future((Channel)channel);
        pipeline.sendUpstream((ChannelEvent)new UpstreamPreparationEvent(channel, future));
        return future;
    }

    public static InetSocketAddress toInetSocketAddress(SocketAddress localAddress) {
        if (localAddress instanceof ChannelAddress) {
            return Channels.toInetSocketAddress((ChannelAddress)localAddress);
        }
        return (InetSocketAddress)localAddress;
    }

    public static InetSocketAddress toInetSocketAddress(ChannelAddress channelAddress) {
        if (channelAddress == null) {
            return null;
        }
        URI location = channelAddress.getLocation();
        String hostname = location.getHost();
        int port = location.getPort();
        return new InetSocketAddress(hostname, port);
    }

    public static ChannelAddress localAddress(Channel channel) {
        SocketAddress localAddress = channel.getLocalAddress();
        return Channels.channelAddress(channel, localAddress);
    }

    public static ChannelAddress remoteAddress(Channel channel) {
        SocketAddress remoteAddress = channel.getRemoteAddress();
        return Channels.channelAddress(channel, remoteAddress);
    }

    public static ChannelAddress channelAddress(Channel channel, SocketAddress address) {
        if (address instanceof ChannelAddress) {
            return (ChannelAddress)address;
        }
        if (address instanceof InetSocketAddress) {
            String scheme = channel instanceof NioDatagramChannel ? "udp" : "tcp";
            InetSocketAddress inetAddress = (InetSocketAddress)address;
            String hostname = inetAddress.getHostString();
            int port = inetAddress.getPort();
            URI location = URI.create(String.format("%s://%s:%d", scheme, hostname, port));
            return new ChannelAddress(location);
        }
        throw new IllegalArgumentException();
    }

    private Channels() {
    }

    public static void chainFutures(ChannelFuture sourceFuture, final ChannelFuture targetFuture) {
        if (sourceFuture.isDone()) {
            if (sourceFuture.isSuccess()) {
                targetFuture.setSuccess();
            } else {
                targetFuture.setFailure(sourceFuture.getCause());
            }
        } else {
            sourceFuture.addListener(new ChannelFutureListener(){

                public void operationComplete(ChannelFuture sourceFuture) throws Exception {
                    if (sourceFuture.isSuccess()) {
                        targetFuture.setSuccess();
                    } else {
                        targetFuture.setFailure(sourceFuture.getCause());
                    }
                }
            });
        }
    }

    public static void chainWriteCompletes(ChannelFuture sourceFuture, final ChannelFuture targetFuture, final long amountWritten) {
        if (sourceFuture.isDone()) {
            if (sourceFuture.isSuccess()) {
                org.jboss.netty.channel.Channels.fireWriteComplete((Channel)targetFuture.getChannel(), (long)amountWritten);
                targetFuture.setSuccess();
            } else {
                targetFuture.setFailure(sourceFuture.getCause());
            }
        } else {
            sourceFuture.addListener(new ChannelFutureListener(){

                public void operationComplete(ChannelFuture sourceFuture) throws Exception {
                    if (sourceFuture.isSuccess()) {
                        org.jboss.netty.channel.Channels.fireWriteComplete((Channel)targetFuture.getChannel(), (long)amountWritten);
                        targetFuture.setSuccess();
                    } else {
                        targetFuture.setFailure(sourceFuture.getCause());
                    }
                }
            });
        }
    }
}

