/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.k3po.driver.internal.control.handler;

import java.util.ArrayList;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.handler.codec.replay.ReplayingDecoder;
import org.jboss.netty.util.CharsetUtil;
import org.kaazing.k3po.driver.internal.control.AbortMessage;
import org.kaazing.k3po.driver.internal.control.AwaitMessage;
import org.kaazing.k3po.driver.internal.control.ControlMessage;
import org.kaazing.k3po.driver.internal.control.DisposeMessage;
import org.kaazing.k3po.driver.internal.control.ErrorMessage;
import org.kaazing.k3po.driver.internal.control.FinishedMessage;
import org.kaazing.k3po.driver.internal.control.NotifyMessage;
import org.kaazing.k3po.driver.internal.control.PrepareMessage;
import org.kaazing.k3po.driver.internal.control.PreparedMessage;
import org.kaazing.k3po.driver.internal.control.StartMessage;
import org.kaazing.k3po.lang.internal.parser.ScriptParseException;
import org.kaazing.k3po.lang.internal.parser.ScriptParseStrategy;
import org.kaazing.k3po.lang.internal.parser.ScriptParserImpl;

public class ControlDecoder
extends ReplayingDecoder<State> {
    private final int maxInitialLineLength;
    private final int maxHeaderLineLength;
    private final int maxContentLength;
    private ControlMessage message;
    private int contentLength;

    public ControlDecoder() {
        this(1024, 1024, 32768);
    }

    public ControlDecoder(int maxInitialLineLength, int maxHeaderLineLength, int maxContentLength) {
        super(false);
        this.maxInitialLineLength = maxInitialLineLength;
        this.maxHeaderLineLength = maxHeaderLineLength;
        this.maxContentLength = maxContentLength;
        this.setState(State.READ_INITIAL);
    }

    protected Object decode(ChannelHandlerContext ctx, Channel channel, ChannelBuffer buffer, State state) throws Exception {
        switch (state) {
            case READ_INITIAL: {
                String initialLine = ControlDecoder.readLine(buffer, this.maxInitialLineLength);
                if (initialLine != null) {
                    this.message = this.createMessage(initialLine);
                    this.contentLength = 0;
                    this.checkpoint(State.READ_HEADER);
                }
                return null;
            }
            case READ_HEADER: {
                State nextState = this.readHeader(buffer);
                this.checkpoint(nextState);
                if (nextState == State.READ_INITIAL) {
                    return this.message;
                }
                return null;
            }
            case READ_CONTENT: {
                State nextState = this.readContent(buffer);
                this.checkpoint(nextState);
                if (nextState != State.READ_CONTENT) {
                    return this.message;
                }
                return null;
            }
        }
        throw new IllegalArgumentException(String.format("Unrecognized decoder state: %s", new Object[]{state}));
    }

    private static String readLine(ChannelBuffer buffer, int maxLineLength) {
        int readableBytes = buffer.readableBytes();
        if (readableBytes == 0) {
            return null;
        }
        int readerIndex = buffer.readerIndex();
        int endOfLineAt = buffer.indexOf(readerIndex, Math.min(readableBytes, maxLineLength) + 1, (byte)10);
        if (endOfLineAt == -1) {
            if (readableBytes >= maxLineLength) {
                throw new IllegalArgumentException("Initial line too long");
            }
            return null;
        }
        StringBuilder sb = new StringBuilder(endOfLineAt);
        for (int i = readerIndex; i < endOfLineAt; ++i) {
            sb.append((char)buffer.readByte());
        }
        byte endOfLine = buffer.readByte();
        assert (endOfLine == 10);
        return sb.toString();
    }

    private ControlMessage createMessage(String initialLine) {
        ControlMessage.Kind messageKind = ControlMessage.Kind.valueOf(initialLine);
        switch (messageKind) {
            case PREPARE: {
                return new PrepareMessage();
            }
            case START: {
                return new StartMessage();
            }
            case ABORT: {
                return new AbortMessage();
            }
            case NOTIFY: {
                return new NotifyMessage();
            }
            case AWAIT: {
                return new AwaitMessage();
            }
            case DISPOSE: {
                return new DisposeMessage();
            }
        }
        throw new IllegalArgumentException(String.format("Unrecognized message kind: %s", new Object[]{messageKind}));
    }

    private State readHeader(ChannelBuffer buffer) {
        int colonSearchTo;
        int endOfLineSearchTo;
        int readableBytes = buffer.readableBytes();
        if (readableBytes == 0) {
            return null;
        }
        int endOfLineSearchFrom = buffer.readerIndex();
        int endOfLineAt = buffer.indexOf(endOfLineSearchFrom, (endOfLineSearchTo = Math.min(readableBytes, this.maxHeaderLineLength)) + 1, (byte)10);
        if (endOfLineAt == -1) {
            if (readableBytes >= this.maxHeaderLineLength) {
                throw new IllegalArgumentException("Header line too long");
            }
            return null;
        }
        if (endOfLineAt == endOfLineSearchFrom) {
            byte endOfLine = buffer.readByte();
            assert (endOfLine == 10);
            if (this.contentLength == 0) {
                return State.READ_INITIAL;
            }
            switch (this.message.getKind()) {
                case PREPARE: 
                case FINISHED: 
                case ERROR: {
                    return State.READ_CONTENT;
                }
            }
            return State.READ_INITIAL;
        }
        int colonSearchFrom = buffer.readerIndex();
        int colonAt = buffer.indexOf(colonSearchFrom, (colonSearchTo = Math.min(readableBytes, endOfLineAt)) + 1, (byte)58);
        if (colonAt == -1) {
            throw new IllegalArgumentException("Colon not found in header line");
        }
        int headerNameLength = colonAt - colonSearchFrom;
        StringBuilder headerNameBuilder = new StringBuilder(headerNameLength);
        for (int i = 0; i < headerNameLength; ++i) {
            headerNameBuilder.append((char)buffer.readByte());
        }
        String headerName = headerNameBuilder.toString();
        byte colon = buffer.readByte();
        assert (colon == 58);
        int headerValueLength = endOfLineAt - colonAt - 1;
        StringBuilder headerValueBuilder = new StringBuilder(headerValueLength);
        for (int i = 0; i < headerValueLength; ++i) {
            headerValueBuilder.append((char)buffer.readByte());
        }
        String headerValue = headerValueBuilder.toString();
        switch (this.message.getKind()) {
            case PREPARE: {
                PrepareMessage prepareMessage = (PrepareMessage)this.message;
                switch (headerName) {
                    case "version": {
                        prepareMessage.setVersion(headerValue);
                        break;
                    }
                    case "name": {
                        prepareMessage.getNames().add(headerValue);
                        break;
                    }
                    case "origin": {
                        prepareMessage.setOrigin(headerValue);
                        break;
                    }
                    case "content-length": {
                        this.contentLength = Integer.parseInt(headerValue);
                        if (this.contentLength <= this.maxContentLength) break;
                        throw new IllegalArgumentException("Content too long");
                    }
                }
                break;
            }
            case FINISHED: 
            case ERROR: 
            case PREPARED: {
                switch (headerName) {
                    case "content-length": {
                        this.contentLength = Integer.parseInt(headerValue);
                        if (this.contentLength <= this.maxContentLength) break;
                        throw new IllegalArgumentException("Content too long");
                    }
                }
                break;
            }
            case NOTIFY: {
                NotifyMessage notifyMessage = (NotifyMessage)this.message;
                switch (headerName) {
                    case "barrier": {
                        notifyMessage.setBarrier(headerValue);
                    }
                }
                break;
            }
            case AWAIT: {
                AwaitMessage awaitMessage = (AwaitMessage)this.message;
                switch (headerName) {
                    case "barrier": {
                        awaitMessage.setBarrier(headerValue);
                    }
                }
                break;
            }
        }
        byte endOfLine = buffer.readByte();
        assert (endOfLine == 10);
        return State.READ_HEADER;
    }

    private State readContent(ChannelBuffer buffer) throws ScriptParseException {
        assert (this.contentLength > 0);
        if (buffer.readableBytes() < this.contentLength) {
            return State.READ_CONTENT;
        }
        String content = buffer.readBytes(this.contentLength).toString(CharsetUtil.UTF_8);
        switch (this.message.getKind()) {
            case PREPARE: {
                PrepareMessage prepareMessage = (PrepareMessage)this.message;
                ScriptParserImpl parser = new ScriptParserImpl();
                ArrayList<String> properties = new ArrayList<String>();
                for (String scriptFragment : content.split("\\r?\\n")) {
                    parser.parseWithStrategy(scriptFragment, ScriptParseStrategy.PROPERTY_NODE);
                    properties.add(scriptFragment);
                }
                prepareMessage.setProperties(properties);
                break;
            }
            case PREPARED: {
                PreparedMessage preparedMessage = (PreparedMessage)this.message;
                preparedMessage.setScript(content);
                break;
            }
            case FINISHED: {
                FinishedMessage finishedMessage = (FinishedMessage)this.message;
                finishedMessage.setScript(content);
                break;
            }
            case ERROR: {
                ErrorMessage errorMessage = (ErrorMessage)this.message;
                errorMessage.setDescription(content);
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected message kind: " + (Object)((Object)this.message.getKind()));
            }
        }
        return State.READ_INITIAL;
    }

    static enum State {
        READ_INITIAL,
        READ_HEADER,
        READ_CONTENT;

    }
}

