/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.k3po.driver.internal.control.handler;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Pattern;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelEvent;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.logging.InternalLogger;
import org.jboss.netty.logging.InternalLoggerFactory;
import org.kaazing.k3po.driver.internal.Robot;
import org.kaazing.k3po.driver.internal.control.AwaitMessage;
import org.kaazing.k3po.driver.internal.control.DisposedMessage;
import org.kaazing.k3po.driver.internal.control.ErrorMessage;
import org.kaazing.k3po.driver.internal.control.FinishedMessage;
import org.kaazing.k3po.driver.internal.control.NotifiedMessage;
import org.kaazing.k3po.driver.internal.control.NotifyMessage;
import org.kaazing.k3po.driver.internal.control.PrepareMessage;
import org.kaazing.k3po.driver.internal.control.PreparedMessage;
import org.kaazing.k3po.driver.internal.control.StartedMessage;
import org.kaazing.k3po.driver.internal.control.handler.ControlUpstreamHandler;
import org.kaazing.k3po.driver.internal.control.handler.OriginScript;
import org.kaazing.k3po.lang.internal.ast.AstPropertyNode;
import org.kaazing.k3po.lang.internal.parser.ScriptParseException;
import org.kaazing.k3po.lang.internal.parser.ScriptParseStrategy;
import org.kaazing.k3po.lang.internal.parser.ScriptParserImpl;

public class ControlServerHandler
extends ControlUpstreamHandler {
    private static final Map<String, Object> EMPTY_ENVIRONMENT = Collections.emptyMap();
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(ControlServerHandler.class);
    private Robot robot;
    private ChannelFutureListener whenAbortedOrFinished;
    private BlockingQueue<CountDownLatch> notifiedLatches = new LinkedBlockingQueue<CountDownLatch>();
    private final ChannelFuture channelClosedFuture = Channels.future(null);
    private ClassLoader scriptLoader;

    public void setScriptLoader(ClassLoader scriptLoader) {
        this.scriptLoader = scriptLoader;
    }

    public ChannelFuture getChannelClosedFuture() {
        return this.channelClosedFuture;
    }

    public void channelClosed(final ChannelHandlerContext ctx, final ChannelStateEvent e) throws Exception {
        if (this.robot != null) {
            this.robot.dispose().addListener(new ChannelFutureListener(){

                public void operationComplete(ChannelFuture future) throws Exception {
                    ControlServerHandler.this.channelClosedFuture.setSuccess();
                    ctx.sendUpstream((ChannelEvent)e);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void prepareReceived(final ChannelHandlerContext ctx, MessageEvent evt) throws Exception {
        PrepareMessage prepare = (PrepareMessage)evt.getMessage();
        String version = prepare.getVersion();
        if (!"2.0".equals(version)) {
            this.sendVersionError(ctx);
            return;
        }
        List<String> scriptNames = prepare.getNames();
        if (logger.isDebugEnabled()) {
            logger.debug("preparing script(s) " + scriptNames);
        }
        this.robot = new Robot();
        this.whenAbortedOrFinished = this.whenAbortedOrFinished(ctx);
        String originScript = "";
        String origin = prepare.getOrigin();
        if (origin != null) {
            try {
                originScript = OriginScript.get(origin);
            }
            catch (URISyntaxException e) {
                throw new Exception("Could not find origin: ", e);
            }
        }
        try {
            ChannelFuture prepareFuture;
            String aggregatedScript = originScript + ControlServerHandler.aggregateScript(scriptNames, this.scriptLoader);
            List<String> properyOverrides = prepare.getProperties();
            if (!"2.0".equals(version)) {
                this.sendVersionError(ctx);
            }
            aggregatedScript = this.injectOverridenProperties(aggregatedScript, properyOverrides);
            if (this.scriptLoader != null) {
                Thread currentThread = Thread.currentThread();
                ClassLoader contextClassLoader = currentThread.getContextClassLoader();
                try {
                    currentThread.setContextClassLoader(this.scriptLoader);
                    prepareFuture = this.robot.prepare(aggregatedScript);
                }
                finally {
                    currentThread.setContextClassLoader(contextClassLoader);
                }
            } else {
                prepareFuture = this.robot.prepare(aggregatedScript);
            }
            final String scriptToRun = aggregatedScript;
            prepareFuture.addListener(new ChannelFutureListener(){

                public void operationComplete(ChannelFuture f) {
                    PreparedMessage prepared = new PreparedMessage();
                    prepared.setScript(scriptToRun);
                    prepared.getBarriers().addAll(ControlServerHandler.this.robot.getBarriersByName().keySet());
                    Channels.write((ChannelHandlerContext)ctx, (ChannelFuture)Channels.future(null), (Object)prepared);
                }
            });
        }
        catch (Exception e) {
            this.sendErrorMessage(ctx, e);
            return;
        }
    }

    private String injectOverridenProperties(String aggregatedScript, List<String> scriptProperties) throws Exception, ScriptParseException {
        ScriptParserImpl parser = new ScriptParserImpl();
        for (String propertyToInject : scriptProperties) {
            String propertyName = ((AstPropertyNode)parser.parseWithStrategy(propertyToInject, ScriptParseStrategy.PROPERTY_NODE)).getPropertyName();
            StringBuilder replacementScript = new StringBuilder();
            Pattern pattern = Pattern.compile("property\\s+" + propertyName + "\\s+.+");
            boolean matchFound = false;
            for (String scriptLine : aggregatedScript.split("\\r?\\n")) {
                if (pattern.matcher(scriptLine).matches()) {
                    matchFound = true;
                    replacementScript.append(propertyToInject + "\n");
                    continue;
                }
                replacementScript.append(scriptLine + "\n");
            }
            if (!matchFound) {
                String errorMsg = "Received " + propertyToInject + " in PREPARE but found no where to substitute it";
                logger.error(errorMsg);
                throw new Exception(errorMsg);
            }
            aggregatedScript = replacementScript.toString();
        }
        return aggregatedScript;
    }

    public static String aggregateScript(List<String> scriptNames, ClassLoader scriptLoader) throws URISyntaxException, IOException {
        StringBuilder aggregatedScript = new StringBuilder();
        for (String scriptName : scriptNames) {
            URL resource;
            String scriptNameWithExtension = String.format("%s.rpt", scriptName);
            Path scriptPath = Paths.get(scriptNameWithExtension, new String[0]);
            scriptNameWithExtension = URI.create(scriptNameWithExtension).normalize().getPath();
            String script = null;
            assert (!scriptPath.isAbsolute());
            if (scriptLoader != null && (resource = scriptLoader.getResource(scriptNameWithExtension)) != null) {
                URI resourceURI = resource.toURI();
                if ("file".equals(resourceURI.getScheme())) {
                    Path resourcePath = Paths.get(resourceURI);
                    script = ControlServerHandler.readScript(resourcePath);
                } else {
                    try (FileSystem fileSystem = FileSystems.newFileSystem(resourceURI, EMPTY_ENVIRONMENT);){
                        Path resourcePath = Paths.get(resourceURI);
                        script = ControlServerHandler.readScript(resourcePath);
                    }
                }
            }
            if (script == null) {
                throw new RuntimeException("Script not found: " + scriptPath);
            }
            aggregatedScript.append(script);
        }
        return aggregatedScript.toString();
    }

    private static String readScript(Path scriptPath) throws IOException {
        List<String> lines = Files.readAllLines(scriptPath, StandardCharsets.UTF_8);
        StringBuilder sb = new StringBuilder();
        for (String line : lines) {
            sb.append(line);
            sb.append("\n");
        }
        String script = sb.toString();
        return script;
    }

    @Override
    public void startReceived(final ChannelHandlerContext ctx, MessageEvent evt) throws Exception {
        try {
            ChannelFuture startFuture = this.robot.start();
            startFuture.addListener(new ChannelFutureListener(){

                public void operationComplete(ChannelFuture f) {
                    if (f.isSuccess()) {
                        StartedMessage started = new StartedMessage();
                        Channels.write((ChannelHandlerContext)ctx, (ChannelFuture)Channels.future(null), (Object)started);
                    } else {
                        ControlServerHandler.this.sendErrorMessage(ctx, f.getCause());
                    }
                }
            });
        }
        catch (Exception e) {
            this.sendErrorMessage(ctx, e);
            return;
        }
        assert (this.whenAbortedOrFinished != null);
        this.robot.finish().addListener(this.whenAbortedOrFinished);
    }

    @Override
    public void abortReceived(ChannelHandlerContext ctx, MessageEvent evt) throws Exception {
        if (logger.isInfoEnabled()) {
            logger.info("ABORT");
        }
        assert (this.whenAbortedOrFinished != null);
        this.robot.abort().addListener(this.whenAbortedOrFinished);
    }

    @Override
    public void notifyReceived(ChannelHandlerContext ctx, MessageEvent evt) throws Exception {
        NotifyMessage notifyMessage = (NotifyMessage)evt.getMessage();
        String barrier = notifyMessage.getBarrier();
        if (logger.isDebugEnabled()) {
            logger.debug("NOTIFY: " + barrier);
        }
        this.writeNotifiedOnBarrier(barrier, ctx);
        this.robot.notifyBarrier(barrier);
    }

    @Override
    public void awaitReceived(ChannelHandlerContext ctx, MessageEvent evt) throws Exception {
        AwaitMessage awaitMessage = (AwaitMessage)evt.getMessage();
        String barrier = awaitMessage.getBarrier();
        if (logger.isDebugEnabled()) {
            logger.debug("AWAIT: " + barrier);
        }
        this.writeNotifiedOnBarrier(barrier, ctx);
    }

    private void writeNotifiedOnBarrier(final String barrier, final ChannelHandlerContext ctx) throws Exception {
        final CountDownLatch latch = new CountDownLatch(1);
        this.notifiedLatches.add(latch);
        this.robot.awaitBarrier(barrier).addListener(new ChannelFutureListener(){

            public void operationComplete(ChannelFuture future) throws Exception {
                try {
                    if (future.isSuccess()) {
                        logger.debug("sending NOTIFIED: " + barrier);
                        NotifiedMessage notified = new NotifiedMessage();
                        notified.setBarrier(barrier);
                        Channels.write((ChannelHandlerContext)ctx, (ChannelFuture)Channels.future(null), (Object)notified);
                    }
                }
                finally {
                    latch.countDown();
                }
            }
        });
    }

    @Override
    public void disposeReceived(final ChannelHandlerContext ctx, MessageEvent evt) throws Exception {
        this.robot.dispose().addListener(new ChannelFutureListener(){

            public void operationComplete(ChannelFuture future) throws Exception {
                ControlServerHandler.this.writeDisposed(ctx);
            }
        });
    }

    private void writeDisposed(ChannelHandlerContext ctx) {
        Channel channel = ctx.getChannel();
        DisposedMessage disposedMessage = new DisposedMessage();
        channel.write((Object)disposedMessage);
    }

    private ChannelFutureListener whenAbortedOrFinished(final ChannelHandlerContext ctx) {
        final AtomicBoolean oneTimeOnly = new AtomicBoolean();
        return new ChannelFutureListener(){

            public void operationComplete(ChannelFuture future) throws Exception {
                if (oneTimeOnly.compareAndSet(false, true)) {
                    for (CountDownLatch latch : ControlServerHandler.this.notifiedLatches) {
                        latch.await();
                    }
                    ControlServerHandler.this.sendFinishedMessage(ctx);
                }
            }
        };
    }

    private void sendFinishedMessage(ChannelHandlerContext ctx) {
        Channel channel = ctx.getChannel();
        String observedScript = this.robot.getObservedScript();
        FinishedMessage finished = new FinishedMessage();
        finished.setScript(observedScript);
        channel.write((Object)finished);
    }

    private void sendVersionError(ChannelHandlerContext ctx) {
        Channel channel = ctx.getChannel();
        ErrorMessage error = new ErrorMessage();
        error.setSummary("Bad control protocol version");
        error.setDescription("Robot requires control protocol version 2.0");
        channel.write((Object)error);
    }

    private void sendErrorMessage(ChannelHandlerContext ctx, Throwable throwable) {
        ErrorMessage error = new ErrorMessage();
        error.setDescription(throwable.getMessage());
        if (throwable instanceof ScriptParseException) {
            if (logger.isDebugEnabled()) {
                logger.error("Caught exception trying to parse script. Sending error to client", throwable);
            } else {
                logger.error("Caught exception trying to parse script. Sending error to client. Due to " + throwable);
            }
            error.setSummary("Parse Error");
            Channels.write((ChannelHandlerContext)ctx, (ChannelFuture)Channels.future(null), (Object)error);
        } else {
            logger.error("Internal Error. Sending error to client", throwable);
            error.setSummary("Internal Error");
            Channels.write((ChannelHandlerContext)ctx, (ChannelFuture)Channels.future(null), (Object)error);
        }
    }
}

