/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.k3po.driver.internal.control.handler;

import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelUpstreamHandler;
import org.jboss.netty.logging.InternalLogger;
import org.jboss.netty.logging.InternalLoggerFactory;
import org.kaazing.k3po.driver.internal.control.ControlMessage;

public class ControlUpstreamHandler
extends SimpleChannelUpstreamHandler {
    private static final InternalLogger LOGGER = InternalLoggerFactory.getInstance(ControlUpstreamHandler.class);

    public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
        ControlMessage message = (ControlMessage)e.getMessage();
        switch (message.getKind()) {
            case PREPARE: {
                this.prepareReceived(ctx, e);
                break;
            }
            case START: {
                this.startReceived(ctx, e);
                break;
            }
            case ABORT: {
                this.abortReceived(ctx, e);
                break;
            }
            case NOTIFY: {
                this.notifyReceived(ctx, e);
                break;
            }
            case AWAIT: {
                this.awaitReceived(ctx, e);
                break;
            }
            case DISPOSE: {
                this.disposeReceived(ctx, e);
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("Unexpected control message: %s", new Object[]{message.getKind()}));
            }
        }
    }

    public void prepareReceived(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
        super.messageReceived(ctx, e);
    }

    public void startReceived(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
        super.messageReceived(ctx, e);
    }

    public void abortReceived(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
        super.messageReceived(ctx, e);
    }

    public void notifyReceived(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
        super.messageReceived(ctx, e);
    }

    public void awaitReceived(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
        super.messageReceived(ctx, e);
    }

    public void disposeReceived(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
        super.messageReceived(ctx, e);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) {
        String msg = "Control channel caught exception event: ";
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(msg, e.getCause());
        } else {
            LOGGER.info(msg + e.getCause());
        }
    }
}

