/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.k3po.driver.internal.netty.bootstrap.agrona;

import java.net.SocketAddress;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.MessageEvent;
import org.kaazing.k3po.driver.internal.netty.bootstrap.agrona.AgronaChannel;
import org.kaazing.k3po.driver.internal.netty.bootstrap.agrona.AgronaClientChannel;
import org.kaazing.k3po.driver.internal.netty.bootstrap.channel.AbstractChannelSink;
import org.kaazing.k3po.driver.internal.netty.channel.FlushEvent;
import org.kaazing.k3po.driver.internal.netty.channel.ShutdownOutputEvent;
import org.kaazing.k3po.driver.internal.netty.channel.agrona.AgronaChannelAddress;

public class AgronaClientChannelSink
extends AbstractChannelSink {
    @Override
    protected void connectRequested(ChannelPipeline pipeline, ChannelStateEvent evt) throws Exception {
        AgronaClientChannel channel = (AgronaClientChannel)evt.getChannel();
        AgronaChannelAddress remoteAddress = (AgronaChannelAddress)evt.getValue();
        if (!channel.isBound()) {
            AgronaChannelAddress localAddress = remoteAddress;
            channel.setLocalAddress(localAddress);
            channel.setBound();
            Channels.fireChannelBound((Channel)channel, (SocketAddress)localAddress);
        }
        ChannelFuture future = evt.getFuture();
        channel.boss.connect(channel, remoteAddress, future);
    }

    @Override
    protected void writeRequested(ChannelPipeline pipeline, MessageEvent evt) throws Exception {
        ChannelBuffer channelBuffer = (ChannelBuffer)evt.getMessage();
        AgronaChannel channel = (AgronaChannel)evt.getChannel();
        ChannelFuture future = evt.getFuture();
        channel.worker.write(channel, channelBuffer, future);
    }

    @Override
    protected void flushRequested(ChannelPipeline pipeline, FlushEvent evt) throws Exception {
        AgronaChannel channel = (AgronaChannel)evt.getChannel();
        ChannelFuture future = evt.getFuture();
        channel.worker.flush(channel, future);
    }

    @Override
    protected void shutdownOutputRequested(ChannelPipeline pipeline, ShutdownOutputEvent evt) throws Exception {
        AgronaChannel channel = (AgronaChannel)evt.getChannel();
        ChannelFuture future = evt.getFuture();
        channel.worker.shutdownOutput(channel, future);
    }

    @Override
    protected void closeRequested(ChannelPipeline pipeline, ChannelStateEvent evt) throws Exception {
        AgronaChannel channel = (AgronaChannel)evt.getChannel();
        ChannelFuture future = evt.getFuture();
        channel.worker.close(channel, future);
    }
}

