/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.k3po.driver.internal.netty.bootstrap.agrona;

import java.net.SocketAddress;
import java.util.Deque;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.agrona.concurrent.BackoffIdleStrategy;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.ChannelSink;
import org.jboss.netty.channel.Channels;
import org.kaazing.k3po.driver.internal.netty.bootstrap.agrona.AgronaChannelConfig;
import org.kaazing.k3po.driver.internal.netty.bootstrap.agrona.AgronaChildChannel;
import org.kaazing.k3po.driver.internal.netty.bootstrap.agrona.AgronaChildChannelSink;
import org.kaazing.k3po.driver.internal.netty.bootstrap.agrona.AgronaServerChannel;
import org.kaazing.k3po.driver.internal.netty.channel.agrona.AgronaChannelAddress;

public final class AgronaServerBoss
implements Runnable {
    private static final long MAX_PARK_NS = TimeUnit.MILLISECONDS.toNanos(100L);
    private static final long MIN_PARK_NS = TimeUnit.MILLISECONDS.toNanos(1L);
    private static final int MAX_YIELDS = 30;
    private static final int MAX_SPINS = 20;
    private final Deque<Runnable> taskQueue;
    private final CountDownLatch shutdownLatch = new CountDownLatch(1);
    private volatile boolean shutdown;

    AgronaServerBoss() {
        this.taskQueue = new ConcurrentLinkedDeque<Runnable>();
    }

    void bind(AgronaServerChannel channel, AgronaChannelAddress localAddress, ChannelFuture future) {
        this.registerTask(new BindTask(channel, localAddress, future));
    }

    void unbind(AgronaServerChannel channel, ChannelFuture future) {
        this.registerTask(new UnbindTask(channel, future));
    }

    void close(AgronaServerChannel channel) {
        this.registerTask(new CloseTask(channel));
    }

    @Override
    public void run() {
        BackoffIdleStrategy idleStrategy = new BackoffIdleStrategy(20L, 30L, MIN_PARK_NS, MAX_PARK_NS);
        while (!this.shutdown) {
            int workCount = 0;
            idleStrategy.idle(workCount += this.executeTasks());
        }
        this.shutdownLatch.countDown();
    }

    public void shutdown() {
        this.shutdown = true;
        try {
            this.shutdownLatch.await();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    private int executeTasks() {
        Runnable task;
        int workCount = 0;
        while ((task = this.taskQueue.poll()) != null) {
            task.run();
            ++workCount;
        }
        return workCount;
    }

    private void registerTask(Runnable task) {
        this.taskQueue.offer(task);
    }

    private static final class CloseTask
    implements Runnable {
        private final AgronaServerChannel serverChannel;

        public CloseTask(AgronaServerChannel serverChannel) {
            this.serverChannel = serverChannel;
        }

        @Override
        public void run() {
            this.serverChannel.setClosed();
            Channels.fireChannelUnbound((Channel)this.serverChannel);
            Channels.fireChannelClosed((Channel)this.serverChannel);
            this.serverChannel.getCloseFuture().setSuccess();
        }
    }

    private static final class UnbindTask
    implements Runnable {
        private final AgronaServerChannel serverChannel;
        private final ChannelFuture unbindFuture;

        public UnbindTask(AgronaServerChannel serverChannel, ChannelFuture unbindFuture) {
            this.serverChannel = serverChannel;
            this.unbindFuture = unbindFuture;
        }

        @Override
        public void run() {
            Channels.fireChannelUnbound((Channel)this.serverChannel);
            this.unbindFuture.setSuccess();
        }
    }

    private static final class BindTask
    implements Runnable {
        private final AgronaServerChannel serverChannel;
        private final AgronaChannelAddress localAddress;
        private final ChannelFuture bindFuture;

        public BindTask(AgronaServerChannel serverChannel, AgronaChannelAddress localAddress, ChannelFuture bindFuture) {
            this.serverChannel = serverChannel;
            this.bindFuture = bindFuture;
            this.localAddress = localAddress;
        }

        @Override
        public void run() {
            this.serverChannel.setLocalAddress(this.localAddress);
            this.serverChannel.setBound();
            Channels.fireChannelBound((Channel)this.serverChannel, (SocketAddress)this.serverChannel.getLocalAddress());
            try {
                ChannelPipelineFactory pipelineFactory = ((AgronaChannelConfig)this.serverChannel.getConfig()).getPipelineFactory();
                ChannelPipeline pipeline = pipelineFactory.getPipeline();
                this.bindFuture.setSuccess();
                ChannelFactory channelFactory = this.serverChannel.getFactory();
                AgronaChildChannelSink channelSink = new AgronaChildChannelSink();
                AgronaChildChannel childChannel = new AgronaChildChannel(this.serverChannel, channelFactory, pipeline, (ChannelSink)channelSink, this.serverChannel.worker);
                childChannel.setLocalAddress(this.serverChannel.getLocalAddress());
                Channels.fireChannelBound((Channel)childChannel, (SocketAddress)childChannel.getLocalAddress());
                childChannel.setRemoteAddress(childChannel.getLocalAddress());
                Channels.fireChannelConnected((Channel)childChannel, (SocketAddress)childChannel.getRemoteAddress());
                childChannel.worker.register(childChannel);
            }
            catch (Exception e) {
                this.bindFuture.setFailure((Throwable)e);
            }
        }
    }
}

