/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.k3po.driver.internal.netty.bootstrap.agrona;

import java.util.Deque;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.agrona.DirectBuffer;
import org.agrona.concurrent.BackoffIdleStrategy;
import org.agrona.concurrent.UnsafeBuffer;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelException;
import org.jboss.netty.channel.ChannelFuture;
import org.kaazing.k3po.driver.internal.netty.bootstrap.agrona.AgronaChannel;
import org.kaazing.k3po.driver.internal.netty.channel.Channels;
import org.kaazing.k3po.driver.internal.netty.channel.agrona.AgronaChannelAddress;
import org.kaazing.k3po.driver.internal.netty.channel.agrona.ChannelReader;
import org.kaazing.k3po.driver.internal.netty.channel.agrona.ChannelWriter;

public final class AgronaWorker
implements Runnable {
    private static final long MAX_PARK_NS = TimeUnit.MILLISECONDS.toNanos(100L);
    private static final long MIN_PARK_NS = TimeUnit.MILLISECONDS.toNanos(1L);
    private static final int MAX_YIELDS = 30;
    private static final int MAX_SPINS = 20;
    private final Deque<Runnable> taskQueue;
    private final Set<AgronaChannel> readableChannels;
    private final CountDownLatch shutdownLatch = new CountDownLatch(1);
    private volatile boolean shutdown;

    AgronaWorker() {
        this.taskQueue = new ConcurrentLinkedDeque<Runnable>();
        this.readableChannels = new ConcurrentSkipListSet<AgronaChannel>();
    }

    public void register(AgronaChannel channel) {
        this.readableChannels.add(channel);
    }

    public void write(AgronaChannel channel, ChannelBuffer channelBuffer, ChannelFuture future) {
        this.registerTask(new WriteTask(channel, channelBuffer, future));
    }

    public void flush(AgronaChannel channel, ChannelFuture future) {
        this.registerTask(new FlushTask(channel, future));
    }

    public void shutdownOutput(AgronaChannel channel, ChannelFuture future) {
        this.registerTask(new ShutdownOutputTask(channel, future));
    }

    public void close(AgronaChannel channel, ChannelFuture future) {
        this.readableChannels.remove((Object)channel);
        this.registerTask(new CloseTask(channel, future));
    }

    @Override
    public void run() {
        BackoffIdleStrategy idleStrategy = new BackoffIdleStrategy(20L, 30L, MIN_PARK_NS, MAX_PARK_NS);
        while (!this.shutdown) {
            int workCount = 0;
            workCount += this.executeTasks();
            idleStrategy.idle(workCount += this.readMessges());
        }
        this.shutdownLatch.countDown();
    }

    public void shutdown() {
        this.shutdown = true;
        try {
            this.shutdownLatch.await();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    private int executeTasks() {
        Runnable task;
        int workCount = 0;
        while ((task = this.taskQueue.poll()) != null) {
            task.run();
            ++workCount;
        }
        return workCount;
    }

    private int readMessges() {
        int workCount = 0;
        for (AgronaChannel channel : this.readableChannels) {
            AgronaChannelAddress remoteAddress = channel.getRemoteAddress();
            ChannelReader reader = remoteAddress.getReader();
            workCount += reader.read(channel.messageHandler);
        }
        return workCount;
    }

    private void registerTask(Runnable task) {
        this.taskQueue.offer(task);
    }

    private static boolean flushWriteBufferIfNecessary(AgronaChannel channel) {
        ChannelBuffer writeBuffer = channel.writeBuffer;
        int readableBytes = writeBuffer.readableBytes();
        if (readableBytes == 0) {
            return false;
        }
        if (readableBytes < 4) {
            String message = String.format("Minimum %d bytes needed for message type id", 4);
            throw new ChannelException(message);
        }
        UnsafeBuffer srcBuffer = new UnsafeBuffer(new byte[readableBytes - 4]);
        int msgTypeId = writeBuffer.getInt(0);
        writeBuffer.getBytes(4, srcBuffer.byteArray());
        writeBuffer.writerIndex(0);
        AgronaChannelAddress remoteAddress = channel.getRemoteAddress();
        ChannelWriter writer = remoteAddress.getWriter();
        writer.write(msgTypeId, (DirectBuffer)srcBuffer, 0, srcBuffer.capacity());
        return true;
    }

    private static final class CloseTask
    implements Runnable {
        private final AgronaChannel channel;
        private final ChannelFuture future;

        public CloseTask(AgronaChannel channel, ChannelFuture future) {
            this.channel = channel;
            this.future = future;
        }

        @Override
        public void run() {
            try {
                AgronaWorker.flushWriteBufferIfNecessary(this.channel);
                this.future.setSuccess();
                if (this.channel.setClosed()) {
                    org.jboss.netty.channel.Channels.fireChannelDisconnected((Channel)this.channel);
                    org.jboss.netty.channel.Channels.fireChannelUnbound((Channel)this.channel);
                    org.jboss.netty.channel.Channels.fireChannelClosed((Channel)this.channel);
                }
            }
            catch (ChannelException ex) {
                this.future.setFailure((Throwable)ex);
            }
        }
    }

    private static final class ShutdownOutputTask
    implements Runnable {
        private final AgronaChannel channel;
        private final ChannelFuture future;

        public ShutdownOutputTask(AgronaChannel channel, ChannelFuture future) {
            this.channel = channel;
            this.future = future;
        }

        @Override
        public void run() {
            try {
                AgronaWorker.flushWriteBufferIfNecessary(this.channel);
                this.future.setSuccess();
                Channels.fireOutputShutdown((Channel)this.channel);
            }
            catch (ChannelException ex) {
                this.future.setFailure((Throwable)ex);
            }
        }
    }

    private static final class FlushTask
    implements Runnable {
        private final AgronaChannel channel;
        private final ChannelFuture future;

        public FlushTask(AgronaChannel channel, ChannelFuture future) {
            this.channel = channel;
            this.future = future;
        }

        @Override
        public void run() {
            try {
                AgronaWorker.flushWriteBufferIfNecessary(this.channel);
                this.future.setSuccess();
                Channels.fireFlushed((Channel)this.channel);
            }
            catch (ChannelException ex) {
                this.future.setFailure((Throwable)ex);
            }
        }
    }

    private static final class WriteTask
    implements Runnable {
        private final AgronaChannel channel;
        private final ChannelBuffer buffer;
        private final ChannelFuture future;

        public WriteTask(AgronaChannel channel, ChannelBuffer buffer, ChannelFuture future) {
            this.channel = channel;
            this.buffer = buffer;
            this.future = future;
        }

        @Override
        public void run() {
            try {
                ChannelBuffer writeBuffer = this.channel.writeBuffer;
                int readableBytes = this.buffer.readableBytes();
                writeBuffer.writeBytes(this.buffer);
                this.future.setSuccess();
                org.jboss.netty.channel.Channels.fireWriteComplete((Channel)this.channel, (long)readableBytes);
            }
            catch (ChannelException ex) {
                this.future.setFailure((Throwable)ex);
            }
        }
    }
}

