/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.k3po.driver.internal.netty.bootstrap.file;

import java.net.SocketAddress;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.logging.InternalLogger;
import org.jboss.netty.logging.InternalLoggerFactory;
import org.kaazing.k3po.driver.internal.netty.bootstrap.channel.AbstractChannelSink;
import org.kaazing.k3po.driver.internal.netty.bootstrap.file.FileChannel;
import org.kaazing.k3po.driver.internal.netty.channel.ChannelAddress;

public class FileChannelSink
extends AbstractChannelSink {
    private static final InternalLogger LOGGER = InternalLoggerFactory.getInstance(FileChannelSink.class);

    @Override
    protected void connectRequested(ChannelPipeline pipeline, ChannelStateEvent evt) throws Exception {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("connectRequested pipeline = " + pipeline + " evt = " + evt);
        }
        FileChannel fileChannel = (FileChannel)evt.getChannel();
        ChannelAddress fileAddress = (ChannelAddress)evt.getValue();
        if (!fileChannel.isBound()) {
            fileChannel.setLocalAddress(fileAddress);
            fileChannel.setBound();
            Channels.fireChannelBound((Channel)fileChannel, (SocketAddress)fileAddress);
        }
        ChannelFuture connectFuture = evt.getFuture();
        try {
            fileChannel.mapFile();
            connectFuture.setSuccess();
        }
        catch (Throwable t) {
            connectFuture.setFailure(t);
        }
        fileChannel.setConnected();
        Channels.fireChannelConnected((Channel)fileChannel, (SocketAddress)fileAddress);
        fileChannel.fireMessageReceived(fileChannel, fileAddress);
    }

    @Override
    protected void writeRequested(ChannelPipeline pipeline, MessageEvent evt) throws Exception {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("writeRequested pipeline = " + pipeline + " evt = " + evt);
        }
        ChannelBuffer channelBuffer = (ChannelBuffer)evt.getMessage();
        FileChannel fileChannel = (FileChannel)evt.getChannel();
        ChannelFuture writeFuture = evt.getFuture();
        try {
            fileChannel.write(channelBuffer);
            writeFuture.setSuccess();
        }
        catch (Throwable t) {
            writeFuture.setFailure(t);
        }
    }

    @Override
    protected void closeRequested(ChannelPipeline pipeline, ChannelStateEvent evt) throws Exception {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("closeRequested pipeline = " + pipeline + " evt = " + evt);
        }
        FileChannel fileChannel = (FileChannel)evt.getChannel();
        ChannelFuture closeFuture = evt.getFuture();
        fileChannel.setClosed();
        closeFuture.setSuccess();
    }
}

