/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.k3po.driver.internal.netty.bootstrap.http;

import java.util.Objects;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.handler.codec.http.DefaultHttpChunk;
import org.jboss.netty.handler.codec.http.DefaultHttpChunkTrailer;
import org.jboss.netty.handler.codec.http.DefaultHttpResponse;
import org.jboss.netty.handler.codec.http.HttpHeaders;
import org.jboss.netty.handler.codec.http.HttpMessage;
import org.jboss.netty.handler.codec.http.HttpRequestDecoder;
import org.jboss.netty.handler.codec.http.HttpResponse;
import org.jboss.netty.handler.codec.http.HttpResponseEncoder;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;
import org.jboss.netty.handler.codec.http.HttpVersion;
import org.kaazing.k3po.driver.internal.channel.Channels;
import org.kaazing.k3po.driver.internal.netty.bootstrap.channel.AbstractChannelSink;
import org.kaazing.k3po.driver.internal.netty.bootstrap.http.HttpChannelConfig;
import org.kaazing.k3po.driver.internal.netty.bootstrap.http.HttpChildChannel;
import org.kaazing.k3po.driver.internal.netty.channel.AbortEvent;
import org.kaazing.k3po.driver.internal.netty.channel.FlushEvent;
import org.kaazing.k3po.driver.internal.netty.channel.ShutdownOutputEvent;

public class HttpChildChannelSink
extends AbstractChannelSink {
    private final Channel transport;
    private HttpResponse httpBufferedResponse;

    public HttpChildChannelSink(Channel transport) {
        this.transport = Objects.requireNonNull(transport);
    }

    public ChannelFuture execute(ChannelPipeline httpPipeline, Runnable task) {
        ChannelPipeline pipeline = this.transport.getPipeline();
        ChannelFuture future = pipeline.execute(task);
        Channel httpChannel = pipeline.getChannel();
        ChannelFuture httpFuture = org.jboss.netty.channel.Channels.future((Channel)httpChannel);
        Channels.chainFutures(future, httpFuture);
        return httpFuture;
    }

    @Override
    protected void setInterestOpsRequested(ChannelPipeline pipeline, ChannelStateEvent evt) throws Exception {
    }

    @Override
    protected void writeRequested(ChannelPipeline httpPipeline, MessageEvent e) throws Exception {
        HttpChildChannel httpChildChannel = (HttpChildChannel)httpPipeline.getChannel();
        HttpChannelConfig httpChildConfig = (HttpChannelConfig)httpChildChannel.getConfig();
        ChannelFuture httpFuture = e.getFuture();
        ChannelBuffer httpContent = (ChannelBuffer)e.getMessage();
        int httpReadableBytes = httpContent.readableBytes();
        switch (httpChildChannel.writeState()) {
            case RESPONSE: {
                HttpVersion version = httpChildConfig.getVersion();
                HttpResponseStatus status = httpChildConfig.getStatus();
                HttpHeaders headers = httpChildConfig.getWriteHeaders();
                DefaultHttpResponse httpResponse = new DefaultHttpResponse(version, status);
                if (headers != null) {
                    httpResponse.headers().add(headers);
                }
                if (httpResponse.getStatus().getCode() == HttpResponseStatus.SWITCHING_PROTOCOLS.getCode()) {
                    httpResponse.setContent(ChannelBuffers.EMPTY_BUFFER);
                    ChannelPipeline pipeline = this.transport.getPipeline();
                    pipeline.remove(HttpRequestDecoder.class);
                    this.transport.write((Object)httpResponse);
                    pipeline.remove(HttpResponseEncoder.class);
                    ChannelFuture future = this.transport.write((Object)httpContent);
                    httpChildChannel.writeState(HttpChildChannel.HttpWriteState.UPGRADED);
                    Channels.chainWriteCompletes(future, httpFuture, httpReadableBytes);
                    break;
                }
                if (HttpHeaders.isContentLengthSet((HttpMessage)httpResponse) && (long)httpReadableBytes == HttpHeaders.getContentLength((HttpMessage)httpResponse)) {
                    httpResponse.setContent(httpContent);
                    ChannelFuture future = this.transport.write((Object)httpResponse);
                    httpChildChannel.writeState(HttpChildChannel.HttpWriteState.CONTENT_COMPLETE);
                    Channels.chainWriteCompletes(future, httpFuture, httpReadableBytes);
                    break;
                }
                if (HttpHeaders.isTransferEncodingChunked((HttpMessage)httpResponse)) {
                    httpResponse.setChunked(true);
                    this.transport.write((Object)httpResponse);
                    httpChildChannel.writeState(HttpChildChannel.HttpWriteState.CONTENT_CHUNKED);
                    DefaultHttpChunk httpChunk = new DefaultHttpChunk(httpContent);
                    ChannelFuture future = this.transport.write((Object)httpChunk);
                    Channels.chainWriteCompletes(future, httpFuture, httpReadableBytes);
                    break;
                }
                if (httpResponse.headers().getAll("Connection").contains("close")) {
                    httpResponse.setContent(httpContent);
                    ChannelFuture future = this.transport.write((Object)httpResponse);
                    httpChildChannel.writeState(HttpChildChannel.HttpWriteState.CONTENT_CLOSE);
                    Channels.chainWriteCompletes(future, httpFuture, httpReadableBytes);
                    break;
                }
                if (httpChildConfig.getMaximumBufferedContentLength() >= httpReadableBytes) {
                    httpResponse.setContent(httpContent);
                    this.httpBufferedResponse = httpResponse;
                    httpChildChannel.writeState(HttpChildChannel.HttpWriteState.CONTENT_BUFFERED);
                    httpFuture.setSuccess();
                    break;
                }
                throw new IllegalStateException("Missing Content-Length, Transfer-Encoding: chunked, or Connection: close");
            }
            case CONTENT_BUFFERED: {
                ChannelBuffer httpBufferedContent = this.httpBufferedResponse.getContent();
                int httpBufferedBytes = httpBufferedContent.readableBytes();
                if (httpChildConfig.getMaximumBufferedContentLength() >= httpBufferedBytes + httpReadableBytes) {
                    this.httpBufferedResponse.setContent(ChannelBuffers.copiedBuffer((ChannelBuffer[])new ChannelBuffer[]{httpBufferedContent, httpContent}));
                    httpFuture.setSuccess();
                    break;
                }
                throw new IllegalStateException("Exceeded maximum buffered content to calculate content length");
            }
            case CONTENT_CHUNKED: 
            case CONTENT_CLOSE: {
                DefaultHttpChunk httpChunk = new DefaultHttpChunk(httpContent);
                ChannelFuture future = this.transport.write((Object)httpChunk);
                Channels.chainWriteCompletes(future, httpFuture, httpReadableBytes);
                break;
            }
            case UPGRADED: {
                ChannelFuture future = this.transport.write((Object)httpContent);
                Channels.chainWriteCompletes(future, httpFuture, httpReadableBytes);
                break;
            }
            case CONTENT_COMPLETE: {
                throw new IllegalStateException();
            }
        }
    }

    @Override
    protected void flushRequested(ChannelPipeline pipeline, FlushEvent evt) throws Exception {
        HttpChildChannel httpChildChannel = (HttpChildChannel)pipeline.getChannel();
        ChannelFuture httpFuture = evt.getFuture();
        this.flushRequested(httpChildChannel, httpFuture);
    }

    @Override
    protected void abortRequested(ChannelPipeline pipeline, final AbortEvent evt) throws Exception {
        this.transport.close().addListener(new ChannelFutureListener(){

            public void operationComplete(ChannelFuture future) throws Exception {
                evt.getFuture().setSuccess();
            }
        });
    }

    @Override
    protected void shutdownOutputRequested(ChannelPipeline pipeline, ShutdownOutputEvent evt) throws Exception {
        HttpChildChannel httpChildChannel = (HttpChildChannel)pipeline.getChannel();
        ChannelFuture httpFuture = evt.getFuture();
        this.closeRequested(httpChildChannel, httpFuture);
    }

    @Override
    protected void closeRequested(ChannelPipeline pipeline, ChannelStateEvent evt) throws Exception {
        HttpChildChannel httpChildChannel = (HttpChildChannel)pipeline.getChannel();
        ChannelFuture httpFuture = evt.getFuture();
        this.closeRequested(httpChildChannel, httpFuture);
    }

    private void closeRequested(final HttpChildChannel httpChildChannel, ChannelFuture httpFuture) {
        if (!httpChildChannel.isOpen()) {
            httpFuture.setSuccess();
            return;
        }
        ChannelFuture httpCloseFuture = httpChildChannel.getCloseFuture();
        if (httpFuture != httpCloseFuture) {
            Channels.chainFutures(httpCloseFuture, httpFuture);
        }
        ChannelFuture httpFlushed = org.jboss.netty.channel.Channels.future((Channel)httpChildChannel);
        this.flushRequested(httpChildChannel, httpFlushed);
        switch (httpChildChannel.writeState()) {
            case CONTENT_CLOSE: 
            case UPGRADED: {
                this.transport.close();
                break;
            }
            case CONTENT_CHUNKED: {
                DefaultHttpChunkTrailer trailingChunk = new DefaultHttpChunkTrailer();
                trailingChunk.trailingHeaders().add(((HttpChannelConfig)httpChildChannel.getConfig()).getWriteTrailers());
                ChannelFuture future = this.transport.write((Object)trailingChunk);
                httpChildChannel.writeState(HttpChildChannel.HttpWriteState.CONTENT_COMPLETE);
                future.addListener(new ChannelFutureListener(){

                    public void operationComplete(ChannelFuture future) throws Exception {
                        if (httpChildChannel.setWriteClosed()) {
                            org.jboss.netty.channel.Channels.fireChannelDisconnected((Channel)httpChildChannel);
                            org.jboss.netty.channel.Channels.fireChannelUnbound((Channel)httpChildChannel);
                            org.jboss.netty.channel.Channels.fireChannelClosed((Channel)httpChildChannel);
                        }
                    }
                });
                break;
            }
            case CONTENT_COMPLETE: {
                if (!httpChildChannel.setWriteClosed()) break;
                org.jboss.netty.channel.Channels.fireChannelDisconnected((Channel)httpChildChannel);
                org.jboss.netty.channel.Channels.fireChannelUnbound((Channel)httpChildChannel);
                org.jboss.netty.channel.Channels.fireChannelClosed((Channel)httpChildChannel);
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected state after flushRequested: " + (Object)((Object)httpChildChannel.writeState()));
            }
        }
    }

    private void flushRequested(HttpChildChannel httpChildChannel, ChannelFuture httpFuture) {
        switch (httpChildChannel.writeState()) {
            case RESPONSE: {
                HttpResponseStatus httpStatus;
                int httpStatusCode;
                HttpChannelConfig httpChildConfig = (HttpChannelConfig)httpChildChannel.getConfig();
                HttpVersion version = httpChildConfig.getVersion();
                HttpResponseStatus status = httpChildConfig.getStatus();
                HttpHeaders headers = httpChildConfig.getWriteHeaders();
                DefaultHttpResponse httpResponse = new DefaultHttpResponse(version, status);
                if (headers != null) {
                    httpResponse.headers().add(headers);
                }
                int n = httpStatusCode = (httpStatus = httpResponse.getStatus()) != null ? httpStatus.getCode() : 0;
                if (httpStatusCode == HttpResponseStatus.SWITCHING_PROTOCOLS.getCode()) {
                    ChannelFuture future = this.transport.write((Object)httpResponse);
                    httpChildChannel.writeState(HttpChildChannel.HttpWriteState.UPGRADED);
                    ChannelPipeline pipeline = this.transport.getPipeline();
                    pipeline.remove(HttpRequestDecoder.class);
                    pipeline.remove(HttpResponseEncoder.class);
                    Channels.chainFutures(future, httpFuture);
                    break;
                }
                if (HttpHeaders.isTransferEncodingChunked((HttpMessage)httpResponse)) {
                    httpResponse.setChunked(true);
                    ChannelFuture future = this.transport.write((Object)httpResponse);
                    httpChildChannel.writeState(HttpChildChannel.HttpWriteState.CONTENT_CHUNKED);
                    Channels.chainFutures(future, httpFuture);
                    break;
                }
                if (httpResponse.headers().getAll("Connection").contains("close")) {
                    ChannelFuture future = this.transport.write((Object)httpResponse);
                    httpChildChannel.writeState(HttpChildChannel.HttpWriteState.CONTENT_CLOSE);
                    Channels.chainFutures(future, httpFuture);
                    break;
                }
                if (httpStatusCode >= 200 && httpChildConfig.getMaximumBufferedContentLength() > 0) {
                    switch (httpStatusCode) {
                        case 204: 
                        case 205: 
                        case 304: {
                            break;
                        }
                        default: {
                            HttpHeaders.setContentLength((HttpMessage)httpResponse, (long)0L);
                        }
                    }
                }
                ChannelFuture future = this.transport.write((Object)httpResponse);
                httpChildChannel.writeState(HttpChildChannel.HttpWriteState.CONTENT_COMPLETE);
                Channels.chainFutures(future, httpFuture);
                break;
            }
            case CONTENT_BUFFERED: {
                HttpResponse httpBufferedResponse = this.httpBufferedResponse;
                this.httpBufferedResponse = null;
                ChannelBuffer httpBufferedContent = httpBufferedResponse.getContent();
                int httpReadableBytes = httpBufferedContent.readableBytes();
                HttpHeaders.setContentLength((HttpMessage)httpBufferedResponse, (long)httpReadableBytes);
                ChannelFuture future = this.transport.write((Object)httpBufferedResponse);
                httpChildChannel.writeState(HttpChildChannel.HttpWriteState.CONTENT_COMPLETE);
                Channels.chainWriteCompletes(future, httpFuture, httpReadableBytes);
                break;
            }
            case CONTENT_CHUNKED: 
            case CONTENT_CLOSE: 
            case UPGRADED: 
            case CONTENT_COMPLETE: {
                httpFuture.setSuccess();
                break;
            }
        }
    }
}

