/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.k3po.driver.internal.netty.bootstrap.http;

import java.net.SocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.handler.codec.http.DefaultHttpChunk;
import org.jboss.netty.handler.codec.http.DefaultHttpChunkTrailer;
import org.jboss.netty.handler.codec.http.DefaultHttpRequest;
import org.jboss.netty.handler.codec.http.HttpHeaders;
import org.jboss.netty.handler.codec.http.HttpMessage;
import org.jboss.netty.handler.codec.http.HttpMethod;
import org.jboss.netty.handler.codec.http.HttpRequest;
import org.jboss.netty.handler.codec.http.HttpVersion;
import org.kaazing.k3po.driver.internal.behavior.handler.codec.http.QueryStringEncoder;
import org.kaazing.k3po.driver.internal.channel.Channels;
import org.kaazing.k3po.driver.internal.netty.bootstrap.BootstrapFactory;
import org.kaazing.k3po.driver.internal.netty.bootstrap.ClientBootstrap;
import org.kaazing.k3po.driver.internal.netty.bootstrap.channel.AbstractChannelSink;
import org.kaazing.k3po.driver.internal.netty.bootstrap.http.HttpChannelConfig;
import org.kaazing.k3po.driver.internal.netty.bootstrap.http.HttpClientChannel;
import org.kaazing.k3po.driver.internal.netty.bootstrap.http.HttpClientChannelSource;
import org.kaazing.k3po.driver.internal.netty.bootstrap.http.HttpRequestForm;
import org.kaazing.k3po.driver.internal.netty.channel.AbortEvent;
import org.kaazing.k3po.driver.internal.netty.channel.ChannelAddress;
import org.kaazing.k3po.driver.internal.netty.channel.FlushEvent;
import org.kaazing.k3po.driver.internal.netty.channel.ShutdownOutputEvent;

public class HttpClientChannelSink
extends AbstractChannelSink {
    private final ChannelPipelineFactory pipelineFactory;
    private final BootstrapFactory bootstrapFactory;
    private Channel transport;
    private HttpRequest httpBufferedRequest;

    public HttpClientChannelSink(BootstrapFactory bootstrapFactory, ChannelPipelineFactory pipelineFactory) {
        this.bootstrapFactory = bootstrapFactory;
        this.pipelineFactory = pipelineFactory;
    }

    public ChannelFuture execute(ChannelPipeline httpPipeline, Runnable task) {
        if (this.transport != null) {
            ChannelPipeline pipeline = this.transport.getPipeline();
            ChannelFuture future = pipeline.execute(task);
            Channel httpChannel = pipeline.getChannel();
            ChannelFuture httpFuture = org.jboss.netty.channel.Channels.future((Channel)httpChannel);
            Channels.chainFutures(future, httpFuture);
            return httpFuture;
        }
        return super.execute(httpPipeline, task);
    }

    @Override
    protected void setInterestOpsRequested(ChannelPipeline pipeline, ChannelStateEvent evt) throws Exception {
        ChannelFuture httpFuture = evt.getFuture();
        HttpClientChannel httpClientChannel = (HttpClientChannel)evt.getChannel();
        httpClientChannel.setInterestOpsNow((Integer)evt.getValue());
        httpFuture.setSuccess();
    }

    @Override
    protected void bindRequested(ChannelPipeline pipeline, ChannelStateEvent evt) throws Exception {
        ChannelFuture httpBindFuture = evt.getFuture();
        HttpClientChannel httpConnectChannel = (HttpClientChannel)evt.getChannel();
        ChannelAddress httpLocalAddress = (ChannelAddress)evt.getValue();
        httpConnectChannel.setLocalAddress(httpLocalAddress);
        httpConnectChannel.setBound();
        org.jboss.netty.channel.Channels.fireChannelBound((Channel)httpConnectChannel, (SocketAddress)httpLocalAddress);
        httpBindFuture.setSuccess();
    }

    @Override
    protected void connectRequested(ChannelPipeline pipeline, ChannelStateEvent evt) throws Exception {
        final HttpClientChannel httpConnectChannel = (HttpClientChannel)evt.getChannel();
        final ChannelFuture httpConnectFuture = evt.getFuture();
        final ChannelAddress httpRemoteAddress = (ChannelAddress)evt.getValue();
        ChannelAddress address = httpRemoteAddress.getTransport();
        String schemeName = address.getLocation().getScheme();
        String httpSchemeName = httpRemoteAddress.getLocation().getScheme();
        ClientBootstrap bootstrap = this.bootstrapFactory.newClientBootstrap(schemeName);
        bootstrap.setPipelineFactory(this.pipelineFactory);
        bootstrap.setOption(String.format("%s.nextProtocol", schemeName), httpSchemeName);
        ChannelFuture connectFuture = bootstrap.connect(address);
        connectFuture.addListener(new ChannelFutureListener(){

            public void operationComplete(ChannelFuture connectFuture) throws Exception {
                if (connectFuture.isSuccess()) {
                    HttpClientChannelSink.this.transport = connectFuture.getChannel();
                    ChannelPipeline pipeline = HttpClientChannelSink.this.transport.getPipeline();
                    ChannelHandlerContext ctx = pipeline.getContext(HttpClientChannelSource.class);
                    HttpClientChannelSource channelSource = (HttpClientChannelSource)ctx.getHandler();
                    if (!httpConnectChannel.isBound()) {
                        ChannelAddress httpLocalAddress = httpRemoteAddress;
                        httpConnectChannel.setLocalAddress(httpLocalAddress);
                        httpConnectChannel.setBound();
                        org.jboss.netty.channel.Channels.fireChannelBound((Channel)httpConnectChannel, (SocketAddress)httpLocalAddress);
                    }
                    channelSource.setHttpChannel(httpConnectChannel);
                    httpConnectChannel.setRemoteAddress(httpRemoteAddress);
                    httpConnectChannel.setConnected();
                    httpConnectFuture.setSuccess();
                    org.jboss.netty.channel.Channels.fireChannelConnected((Channel)httpConnectChannel, (SocketAddress)httpRemoteAddress);
                } else {
                    httpConnectFuture.setFailure(connectFuture.getCause());
                }
            }
        });
    }

    @Override
    protected void writeRequested(ChannelPipeline pipeline, MessageEvent e) throws Exception {
        HttpClientChannel httpClientChannel = (HttpClientChannel)pipeline.getChannel();
        HttpChannelConfig httpClientConfig = (HttpChannelConfig)httpClientChannel.getConfig();
        ChannelFuture httpFuture = e.getFuture();
        ChannelBuffer httpContent = (ChannelBuffer)e.getMessage();
        int httpReadableBytes = httpContent.readableBytes();
        switch (httpClientChannel.state()) {
            case REQUEST: {
                HttpVersion version = httpClientConfig.getVersion();
                HttpMethod method = httpClientConfig.getMethod();
                HttpHeaders headers = httpClientConfig.getWriteHeaders();
                String targetURI = HttpClientChannelSink.getTargetURI(httpClientChannel);
                DefaultHttpRequest httpRequest = new DefaultHttpRequest(version, method, targetURI);
                HttpHeaders httpRequestHeaders = httpRequest.headers();
                if (httpClientConfig.hasWriteHeaders()) {
                    httpRequestHeaders.add(headers);
                }
                if (HttpHeaders.isContentLengthSet((HttpMessage)httpRequest)) {
                    httpRequest.setContent(httpContent);
                    ChannelFuture future = this.transport.write((Object)httpRequest);
                    if ((long)httpReadableBytes == HttpHeaders.getContentLength((HttpMessage)httpRequest)) {
                        httpClientChannel.state(HttpClientChannel.HttpState.CONTENT_COMPLETE);
                    } else {
                        httpClientChannel.state(HttpClientChannel.HttpState.CONTENT_STREAMED);
                    }
                    Channels.chainWriteCompletes(future, httpFuture, httpReadableBytes);
                    break;
                }
                if (HttpHeaders.isTransferEncodingChunked((HttpMessage)httpRequest)) {
                    httpRequest.setChunked(true);
                    this.transport.write((Object)httpRequest);
                    httpClientChannel.state(HttpClientChannel.HttpState.CONTENT_CHUNKED);
                    DefaultHttpChunk httpChunk = new DefaultHttpChunk(httpContent);
                    ChannelFuture future = this.transport.write((Object)httpChunk);
                    Channels.chainWriteCompletes(future, httpFuture, httpReadableBytes);
                    break;
                }
                if (httpRequest.headers().contains("Upgrade")) {
                    httpRequest.setContent(httpContent);
                    ChannelFuture future = this.transport.write((Object)httpRequest);
                    httpClientChannel.state(HttpClientChannel.HttpState.UPGRADEABLE);
                    Channels.chainWriteCompletes(future, httpFuture, httpReadableBytes);
                    break;
                }
                if (httpClientConfig.getMaximumBufferedContentLength() >= httpReadableBytes) {
                    httpRequest.setContent(httpContent);
                    this.httpBufferedRequest = httpRequest;
                    httpClientChannel.state(HttpClientChannel.HttpState.CONTENT_BUFFERED);
                    httpFuture.setSuccess();
                    break;
                }
                throw new IllegalStateException("Missing Upgrade, Content-Length, Transfer-Encoding: chunked");
            }
            case CONTENT_BUFFERED: {
                ChannelBuffer httpBufferedContent = this.httpBufferedRequest.getContent();
                int httpBufferedBytes = httpBufferedContent.readableBytes();
                if (httpClientConfig.getMaximumBufferedContentLength() >= httpBufferedBytes + httpReadableBytes) {
                    this.httpBufferedRequest.setContent(ChannelBuffers.copiedBuffer((ChannelBuffer[])new ChannelBuffer[]{httpBufferedContent, httpContent}));
                    httpFuture.setSuccess();
                    break;
                }
                throw new IllegalStateException("Exceeded maximum buffered content to calculate content length");
            }
            case CONTENT_CHUNKED: {
                DefaultHttpChunk httpChunk = new DefaultHttpChunk(httpContent);
                ChannelFuture future = this.transport.write((Object)httpChunk);
                Channels.chainWriteCompletes(future, httpFuture, httpReadableBytes);
                break;
            }
            case CONTENT_STREAMED: {
                DefaultHttpChunk httpChunk = new DefaultHttpChunk(httpContent);
                ChannelFuture future = this.transport.write((Object)httpChunk);
                Channels.chainWriteCompletes(future, httpFuture, httpReadableBytes);
                break;
            }
            case UPGRADEABLE: {
                ChannelFuture future = this.transport.write((Object)httpContent);
                Channels.chainWriteCompletes(future, httpFuture, httpReadableBytes);
                break;
            }
            case CONTENT_COMPLETE: {
                throw new IllegalStateException("attempted write after request content complete");
            }
        }
    }

    @Override
    protected void shutdownOutputRequested(ChannelPipeline pipeline, ShutdownOutputEvent evt) throws Exception {
        HttpClientChannel httpClientChannel = (HttpClientChannel)pipeline.getChannel();
        ChannelFuture httpFuture = evt.getFuture();
        this.shutdownOutputRequested(httpClientChannel, httpFuture);
    }

    @Override
    protected void flushRequested(ChannelPipeline pipeline, FlushEvent evt) throws Exception {
        HttpClientChannel httpClientChannel = (HttpClientChannel)pipeline.getChannel();
        ChannelFuture httpFuture = evt.getFuture();
        this.flushRequested(httpClientChannel, httpFuture);
    }

    @Override
    protected void abortRequested(ChannelPipeline pipeline, final AbortEvent evt) throws Exception {
        HttpClientChannel channel = (HttpClientChannel)pipeline.getChannel();
        ChannelFuture flushFuture = org.jboss.netty.channel.Channels.future((Channel)channel);
        this.flushRequested(channel, flushFuture);
        flushFuture.addListener(new ChannelFutureListener(){

            public void operationComplete(ChannelFuture future) throws Exception {
                ChannelFuture disconnect = HttpClientChannelSink.this.transport.disconnect();
                Channels.chainFutures(disconnect, evt.getFuture());
            }
        });
    }

    @Override
    protected void closeRequested(ChannelPipeline pipeline, ChannelStateEvent evt) throws Exception {
        HttpClientChannel httpClientChannel = (HttpClientChannel)pipeline.getChannel();
        ChannelFuture httpFuture = evt.getFuture();
        httpFuture.setSuccess();
        switch (httpClientChannel.state()) {
            case UPGRADEABLE: {
                this.transport.close();
                break;
            }
            default: {
                ChannelFuture inputShutdown = org.jboss.netty.channel.Channels.future((Channel)httpClientChannel);
                this.shutdownOutputRequested(httpClientChannel, inputShutdown);
            }
        }
        boolean wasConnected = httpClientChannel.isConnected();
        boolean wasBound = httpClientChannel.isBound();
        if (httpClientChannel.setClosed()) {
            if (wasConnected) {
                org.jboss.netty.channel.Channels.fireChannelDisconnected((Channel)httpClientChannel);
            }
            if (wasBound) {
                org.jboss.netty.channel.Channels.fireChannelUnbound((Channel)httpClientChannel);
            }
            org.jboss.netty.channel.Channels.fireChannelClosed((Channel)httpClientChannel);
        }
    }

    private void shutdownOutputRequested(HttpClientChannel httpClientChannel, ChannelFuture httpFuture) throws Exception {
        switch (httpClientChannel.state()) {
            case CONTENT_CHUNKED: {
                DefaultHttpChunkTrailer trailingChunk = new DefaultHttpChunkTrailer();
                HttpHeaders writeTrailers = ((HttpChannelConfig)httpClientChannel.getConfig()).getWriteTrailers();
                trailingChunk.trailingHeaders().add(writeTrailers);
                ChannelFuture future = this.transport.write((Object)trailingChunk);
                httpClientChannel.state(HttpClientChannel.HttpState.CONTENT_COMPLETE);
                Channels.chainFutures(future, httpFuture);
                break;
            }
            default: {
                this.flushRequested(httpClientChannel, httpFuture);
            }
        }
    }

    private void flushRequested(HttpClientChannel httpClientChannel, ChannelFuture httpFuture) throws Exception {
        switch (httpClientChannel.state()) {
            case REQUEST: {
                HttpChannelConfig httpClientConfig = (HttpChannelConfig)httpClientChannel.getConfig();
                HttpVersion version = httpClientConfig.getVersion();
                HttpMethod method = httpClientConfig.getMethod();
                HttpHeaders headers = httpClientConfig.getWriteHeaders();
                String targetURI = HttpClientChannelSink.getTargetURI(httpClientChannel);
                DefaultHttpRequest httpRequest = new DefaultHttpRequest(version, method, targetURI);
                HttpHeaders httpRequestHeaders = httpRequest.headers();
                if (httpClientConfig.hasWriteHeaders()) {
                    httpRequestHeaders.add(headers);
                }
                if (HttpHeaders.isContentLengthSet((HttpMessage)httpRequest)) {
                    ChannelFuture future = this.transport.write((Object)httpRequest);
                    if (HttpHeaders.getContentLength((HttpMessage)httpRequest) == 0L) {
                        httpClientChannel.state(HttpClientChannel.HttpState.CONTENT_COMPLETE);
                    } else {
                        httpClientChannel.state(HttpClientChannel.HttpState.CONTENT_STREAMED);
                    }
                    Channels.chainFutures(future, httpFuture);
                    break;
                }
                if (HttpHeaders.isTransferEncodingChunked((HttpMessage)httpRequest)) {
                    httpRequest.setChunked(true);
                    ChannelFuture future = this.transport.write((Object)httpRequest);
                    httpClientChannel.state(HttpClientChannel.HttpState.CONTENT_CHUNKED);
                    Channels.chainFutures(future, httpFuture);
                    break;
                }
                if (httpRequestHeaders.contains("Upgrade")) {
                    ChannelFuture future = this.transport.write((Object)httpRequest);
                    httpClientChannel.state(HttpClientChannel.HttpState.UPGRADEABLE);
                    Channels.chainFutures(future, httpFuture);
                    break;
                }
                if ("GET".equalsIgnoreCase(method.getName()) || "HEAD".equalsIgnoreCase(method.getName())) {
                    ChannelFuture future = this.transport.write((Object)httpRequest);
                    httpClientChannel.state(HttpClientChannel.HttpState.CONTENT_COMPLETE);
                    Channels.chainFutures(future, httpFuture);
                    break;
                }
                if (httpClientConfig.getMaximumBufferedContentLength() > 0) {
                    HttpHeaders.setContentLength((HttpMessage)httpRequest, (long)0L);
                    ChannelFuture future = this.transport.write((Object)httpRequest);
                    httpClientChannel.state(HttpClientChannel.HttpState.CONTENT_COMPLETE);
                    Channels.chainFutures(future, httpFuture);
                    break;
                }
                throw new IllegalStateException("Missing Upgrade, Content-Length, or Transfer-Encoding: chunked");
            }
            case CONTENT_BUFFERED: {
                HttpRequest httpBufferedRequest = this.httpBufferedRequest;
                this.httpBufferedRequest = null;
                if (httpBufferedRequest != null) {
                    ChannelBuffer httpBufferedContent = httpBufferedRequest.getContent();
                    int httpReadableBytes = httpBufferedContent.readableBytes();
                    HttpHeaders.setContentLength((HttpMessage)httpBufferedRequest, (long)httpReadableBytes);
                    ChannelFuture future = this.transport.write((Object)httpBufferedRequest);
                    httpClientChannel.state(HttpClientChannel.HttpState.CONTENT_COMPLETE);
                    Channels.chainWriteCompletes(future, httpFuture, httpReadableBytes);
                    break;
                }
                throw new IllegalStateException("No buffered content");
            }
            case UPGRADEABLE: 
            case CONTENT_COMPLETE: {
                httpFuture.setSuccess();
                break;
            }
        }
    }

    private static String getTargetURI(HttpClientChannel httpClientChannel) throws URISyntaxException {
        HttpChannelConfig httpClientConfig = (HttpChannelConfig)httpClientChannel.getConfig();
        HttpRequestForm requestForm = httpClientConfig.getRequestForm();
        if (requestForm == null) {
            requestForm = httpClientConfig.hasWriteHeaders() && httpClientConfig.getWriteHeaders().contains("Host") ? HttpRequestForm.ORIGIN_FORM : HttpRequestForm.ABSOLUTE_FORM;
        }
        QueryStringEncoder query = httpClientConfig.getWriteQuery();
        ChannelAddress httpRemoteAddress = httpClientChannel.getRemoteAddress();
        URI httpRemoteURI = query != null ? query.toUri() : httpRemoteAddress.getLocation();
        switch (requestForm) {
            case ORIGIN_FORM: {
                String requestPath = httpRemoteURI.getPath();
                String requestQuery = httpRemoteURI.getQuery();
                return requestQuery != null ? String.format("%s?%s", requestPath, requestQuery) : requestPath;
            }
        }
        return httpRemoteURI.toString();
    }
}

