/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.k3po.driver.internal.netty.bootstrap.http;

import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelException;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelHandler;
import org.jboss.netty.handler.codec.http.HttpChunk;
import org.jboss.netty.handler.codec.http.HttpChunkTrailer;
import org.jboss.netty.handler.codec.http.HttpHeaders;
import org.jboss.netty.handler.codec.http.HttpRequestEncoder;
import org.jboss.netty.handler.codec.http.HttpResponse;
import org.jboss.netty.handler.codec.http.HttpResponseDecoder;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;
import org.kaazing.k3po.driver.internal.netty.bootstrap.http.HttpChannelConfig;
import org.kaazing.k3po.driver.internal.netty.bootstrap.http.HttpChannelHandler;
import org.kaazing.k3po.driver.internal.netty.bootstrap.http.HttpClientChannel;
import org.kaazing.k3po.driver.internal.netty.channel.Channels;

public class HttpClientChannelSource
extends HttpChannelHandler {
    private HttpClientChannel httpClientChannel;
    private static final ChannelHandler NOOP_HANDLER = new NoopChannelHandler();

    public void setHttpChannel(HttpClientChannel httpClientChannel) {
        assert (this.httpClientChannel == null);
        this.httpClientChannel = httpClientChannel;
    }

    @Override
    protected void httpMessageReceived(ChannelHandlerContext ctx, MessageEvent e, HttpResponse httpResponse) throws Exception {
        HttpChannelConfig httpChildConfig = (HttpChannelConfig)this.httpClientChannel.getConfig();
        httpChildConfig.setStatus(httpResponse.getStatus());
        httpChildConfig.setVersion(httpResponse.getProtocolVersion());
        httpChildConfig.getReadHeaders().set(httpResponse.headers());
        if (httpResponse.getStatus().getCode() == HttpResponseStatus.SWITCHING_PROTOCOLS.getCode()) {
            Channel transport = ctx.getChannel();
            ChannelPipeline pipeline = transport.getPipeline();
            pipeline.remove(HttpRequestEncoder.class);
            boolean readable = this.httpClientChannel.isReadable();
            if (!readable) {
                this.httpClientChannel.setReadable(true);
                org.jboss.netty.channel.Channels.fireChannelInterestChanged((Channel)this.httpClientChannel);
            }
            ChannelHandlerContext httpDecoderCtx = pipeline.getContext(HttpResponseDecoder.class);
            HttpResponseDecoder httpDecoder = (HttpResponseDecoder)httpDecoderCtx.getHandler();
            httpDecoder.replace(String.format("%s.noop", httpDecoderCtx.getName()), NOOP_HANDLER);
        } else {
            ChannelBuffer content = httpResponse.getContent();
            boolean readable = this.httpClientChannel.isReadable();
            if (!readable) {
                this.httpClientChannel.setReadable(true);
                org.jboss.netty.channel.Channels.fireChannelInterestChanged((Channel)this.httpClientChannel);
            }
            if (content.readable()) {
                org.jboss.netty.channel.Channels.fireMessageReceived((Channel)this.httpClientChannel, (Object)content);
            }
            if (!httpResponse.isChunked()) {
                HttpClientChannel httpClientChannel = this.httpClientChannel;
                this.httpClientChannel = null;
                Channels.fireInputShutdown((Channel)httpClientChannel);
                boolean wasConnected = httpClientChannel.isConnected();
                boolean wasBound = httpClientChannel.isBound();
                if (httpClientChannel.setClosed()) {
                    if (wasConnected) {
                        org.jboss.netty.channel.Channels.fireChannelDisconnected((Channel)httpClientChannel);
                    }
                    if (wasBound) {
                        org.jboss.netty.channel.Channels.fireChannelUnbound((Channel)httpClientChannel);
                    }
                    org.jboss.netty.channel.Channels.fireChannelClosed((Channel)httpClientChannel);
                }
            }
        }
    }

    @Override
    protected void httpMessageReceived(ChannelHandlerContext ctx, MessageEvent e, HttpChunk httpChunk) throws Exception {
        boolean last;
        ChannelBuffer content = httpChunk.getContent();
        if (content.readable()) {
            org.jboss.netty.channel.Channels.fireMessageReceived((Channel)this.httpClientChannel, (Object)content);
        }
        if (last = httpChunk.isLast()) {
            HttpClientChannel httpClientChannel = this.httpClientChannel;
            if (httpChunk instanceof HttpChunkTrailer) {
                HttpHeaders trailingHeaders = ((HttpChunkTrailer)httpChunk).trailingHeaders();
                ((HttpChannelConfig)httpClientChannel.getConfig()).getReadTrailers().set(trailingHeaders);
            }
            this.httpClientChannel = null;
            Channels.fireInputShutdown((Channel)httpClientChannel);
            if (httpClientChannel.setClosed()) {
                org.jboss.netty.channel.Channels.fireChannelDisconnected((Channel)httpClientChannel);
                org.jboss.netty.channel.Channels.fireChannelUnbound((Channel)httpClientChannel);
                org.jboss.netty.channel.Channels.fireChannelClosed((Channel)httpClientChannel);
            }
        }
    }

    @Override
    protected void httpMessageReceived(ChannelHandlerContext ctx, MessageEvent e, ChannelBuffer message) throws Exception {
        if (message.readable()) {
            org.jboss.netty.channel.Channels.fireMessageReceived((Channel)this.httpClientChannel, (Object)message);
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) throws Exception {
        if (this.httpClientChannel != null) {
            HttpClientChannel httpClientChannel = this.httpClientChannel;
            this.httpClientChannel = null;
            if (httpClientChannel.setClosed()) {
                org.jboss.netty.channel.Channels.fireExceptionCaught((Channel)httpClientChannel, (Throwable)e.getCause());
                org.jboss.netty.channel.Channels.fireChannelClosed((Channel)httpClientChannel);
            }
        }
        Channel channel = ctx.getChannel();
        channel.close();
    }

    public void channelClosed(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        if (this.httpClientChannel != null) {
            int httpStatusCode;
            HttpChannelConfig httpClientConfig = (HttpChannelConfig)this.httpClientChannel.getConfig();
            HttpResponseStatus httpStatus = httpClientConfig.getStatus();
            int n = httpStatusCode = httpStatus != null ? httpStatus.getCode() : 0;
            if (httpStatusCode == HttpResponseStatus.SWITCHING_PROTOCOLS.getCode()) {
                if (this.httpClientChannel.setClosed()) {
                    org.jboss.netty.channel.Channels.fireChannelDisconnected((Channel)this.httpClientChannel);
                    org.jboss.netty.channel.Channels.fireChannelUnbound((Channel)this.httpClientChannel);
                    org.jboss.netty.channel.Channels.fireChannelClosed((Channel)this.httpClientChannel);
                }
            } else {
                ChannelException exception = new ChannelException("transport closed unexpectedly");
                exception.fillInStackTrace();
                org.jboss.netty.channel.Channels.fireExceptionCaught((Channel)this.httpClientChannel, (Throwable)exception);
            }
        }
    }

    @ChannelHandler.Sharable
    private static class NoopChannelHandler
    extends SimpleChannelHandler {
        private NoopChannelHandler() {
        }
    }
}

