/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.k3po.driver.internal.netty.bootstrap.udp;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.socket.nio.NioDatagramChannel;
import org.kaazing.k3po.driver.internal.channel.Channels;
import org.kaazing.k3po.driver.internal.netty.bootstrap.channel.AbstractChannelSink;
import org.kaazing.k3po.driver.internal.netty.bootstrap.udp.UdpChildChannel;
import org.kaazing.k3po.driver.internal.netty.bootstrap.udp.UdpChildChannelSource;
import org.kaazing.k3po.driver.internal.netty.channel.ChannelAddress;

class UdpChildChannelSink
extends AbstractChannelSink {
    private final NioDatagramChannel serverChannel;
    private final UdpChildChannelSource childChannelSource;

    UdpChildChannelSink(UdpChildChannelSource childChannelSource) {
        this.childChannelSource = childChannelSource;
        this.serverChannel = childChannelSource.serverChannel.getTransport();
    }

    @Override
    protected void writeRequested(ChannelPipeline pipeline, MessageEvent e) throws Exception {
        assert (e.getChannel() instanceof UdpChildChannel);
        assert (e.getRemoteAddress() != null);
        InetSocketAddress toAddress = Channels.toInetSocketAddress((ChannelAddress)e.getChannel().getRemoteAddress());
        this.serverChannel.write(e.getMessage(), (SocketAddress)toAddress);
        e.getFuture().setSuccess();
    }

    @Override
    protected void closeRequested(ChannelPipeline pipeline, ChannelStateEvent evt) throws Exception {
        org.jboss.netty.channel.Channels.fireChannelDisconnected((Channel)evt.getChannel());
        org.jboss.netty.channel.Channels.fireChannelUnbound((Channel)evt.getChannel());
        org.jboss.netty.channel.Channels.fireChannelClosed((Channel)evt.getChannel());
        this.childChannelSource.closeChildChannel((UdpChildChannel)evt.getChannel());
        evt.getFuture().setSuccess();
    }
}

