/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.k3po.driver.internal.netty.bootstrap.udp;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelConfig;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.ChannelSink;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.DefaultChannelConfig;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.ServerChannel;
import org.jboss.netty.channel.socket.nio.NioDatagramChannel;
import org.jboss.netty.handler.timeout.IdleStateHandler;
import org.jboss.netty.util.Timer;
import org.kaazing.k3po.driver.internal.channel.Channels;
import org.kaazing.k3po.driver.internal.netty.bootstrap.udp.UdpChildChannel;
import org.kaazing.k3po.driver.internal.netty.bootstrap.udp.UdpChildChannelSink;
import org.kaazing.k3po.driver.internal.netty.bootstrap.udp.UdpIdleHandler;
import org.kaazing.k3po.driver.internal.netty.bootstrap.udp.UdpServerChannel;
import org.kaazing.k3po.driver.internal.netty.channel.ChannelAddress;
import org.kaazing.k3po.driver.internal.netty.channel.SimpleChannelHandler;
import org.kaazing.k3po.driver.internal.netty.channel.udp.UdpChannelAddress;

class UdpChildChannelSource
extends SimpleChannelHandler {
    private final Map<SocketAddress, UdpChildChannel> childChannels = new ConcurrentHashMap<SocketAddress, UdpChildChannel>();
    final UdpServerChannel serverChannel;
    private final Timer timer;

    UdpChildChannelSource(UdpServerChannel serverChannel, Timer timer) {
        this.serverChannel = serverChannel;
        this.timer = timer;
    }

    void closeChildChannel(UdpChildChannel childChannel) {
        InetSocketAddress socketAddress = Channels.toInetSocketAddress(childChannel.getRemoteAddress());
        this.childChannels.remove(socketAddress);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) throws Exception {
        this.childChannels.forEach((socketAddress, udpChildChannel) -> {
            org.jboss.netty.channel.Channels.fireExceptionCaught((Channel)udpChildChannel, (Throwable)e.getCause());
            org.jboss.netty.channel.Channels.fireChannelClosed((Channel)udpChildChannel);
        });
        this.childChannels.clear();
        Channel channel = ctx.getChannel();
        channel.close();
    }

    public void channelClosed(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        this.childChannels.forEach((socketAddress, udpChildChannel) -> udpChildChannel.close());
        e.getFuture().setSuccess();
        this.childChannels.clear();
    }

    public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
        SocketAddress remoteAddress = e.getRemoteAddress();
        NioDatagramChannel datagramChannel = (NioDatagramChannel)e.getChannel();
        UdpChannelAddress localAddress = this.serverChannel.getLocalAddress();
        long timeout = localAddress.timeout();
        UdpChildChannel udpChildChannel = this.childChannels.computeIfAbsent(remoteAddress, x -> {
            ChannelPipeline pipeline;
            ChannelPipelineFactory pipelineFactory = this.serverChannel.getConfig().getPipelineFactory();
            try {
                pipeline = pipelineFactory.getPipeline();
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
            if (timeout != 0L) {
                IdleStateHandler idleStateHandler = new IdleStateHandler(this.timer, 0L, 0L, timeout, TimeUnit.MILLISECONDS);
                pipeline.addFirst("idleHandler", (ChannelHandler)new UdpIdleHandler());
                pipeline.addFirst("idleStateHandler", (ChannelHandler)idleStateHandler);
            }
            DefaultChannelConfig config = new DefaultChannelConfig();
            UdpChildChannelSink sink = new UdpChildChannelSink(this);
            UdpChildChannel childChannel = new UdpChildChannel((ServerChannel)this.serverChannel, null, pipeline, (ChannelSink)sink, (ChannelConfig)config);
            org.jboss.netty.channel.Channels.fireChannelOpen((Channel)childChannel);
            childChannel.setLocalAddress(this.serverChannel.getLocalAddress());
            childChannel.setBound();
            org.jboss.netty.channel.Channels.fireChannelBound((Channel)childChannel, (SocketAddress)e.getRemoteAddress());
            ChannelAddress address = Channels.channelAddress((Channel)datagramChannel, e.getRemoteAddress());
            childChannel.setRemoteAddress(address);
            childChannel.setConnected();
            org.jboss.netty.channel.Channels.fireChannelConnected((Channel)childChannel, (SocketAddress)e.getRemoteAddress());
            return childChannel;
        });
        org.jboss.netty.channel.Channels.fireMessageReceived((Channel)udpChildChannel, (Object)e.getMessage());
    }
}

