/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.k3po.driver.internal.netty.bootstrap.udp;

import java.net.SocketAddress;
import org.jboss.netty.bootstrap.ConnectionlessBootstrap;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.socket.nio.NioDatagramChannel;
import org.jboss.netty.channel.socket.nio.NioDatagramChannelFactory;
import org.jboss.netty.channel.socket.nio.NioDatagramWorkerPool;
import org.jboss.netty.channel.socket.nio.WorkerPool;
import org.jboss.netty.util.Timer;
import org.kaazing.k3po.driver.internal.channel.Channels;
import org.kaazing.k3po.driver.internal.netty.bootstrap.channel.AbstractServerChannelSink;
import org.kaazing.k3po.driver.internal.netty.bootstrap.udp.DatagramChannelPipelineFactory;
import org.kaazing.k3po.driver.internal.netty.bootstrap.udp.UdpServerChannel;
import org.kaazing.k3po.driver.internal.netty.channel.ChannelAddress;

class UdpServerChannelSink
extends AbstractServerChannelSink<UdpServerChannel> {
    private final NioDatagramChannelFactory serverChannelFactory;
    private final Timer timer;

    UdpServerChannelSink(NioDatagramWorkerPool workerPool, Timer timer) {
        this.serverChannelFactory = new NioDatagramChannelFactory((WorkerPool)workerPool);
        this.timer = timer;
    }

    @Override
    protected void bindRequested(ChannelPipeline pipeline, ChannelStateEvent evt) throws Exception {
        ChannelAddress localAddress = (ChannelAddress)evt.getValue();
        UdpServerChannel serverChannel = (UdpServerChannel)evt.getChannel();
        ConnectionlessBootstrap bootstrap = new ConnectionlessBootstrap((ChannelFactory)this.serverChannelFactory);
        DatagramChannelPipelineFactory pipelineFactory = new DatagramChannelPipelineFactory(serverChannel, this.timer);
        bootstrap.setPipelineFactory((ChannelPipelineFactory)pipelineFactory);
        NioDatagramChannel datagramChannel = (NioDatagramChannel)bootstrap.bind((SocketAddress)Channels.toInetSocketAddress(localAddress));
        serverChannel.setLocalAddress(localAddress);
        serverChannel.setTransport((Channel)datagramChannel);
        serverChannel.setBound();
        evt.getFuture().setSuccess();
    }

    @Override
    protected void unbindRequested(ChannelPipeline pipeline, ChannelStateEvent evt) throws Exception {
        UdpServerChannel serverChannel = (UdpServerChannel)evt.getChannel();
        serverChannel.getTransport().unbind();
        org.jboss.netty.channel.Channels.fireChannelUnbound((Channel)serverChannel);
        evt.getFuture().setSuccess();
    }

    @Override
    protected void closeRequested(ChannelPipeline pipeline, ChannelStateEvent evt) throws Exception {
        UdpServerChannel serverChannel = (UdpServerChannel)evt.getChannel();
        serverChannel.getTransport().close();
        serverChannel.setClosed();
        org.jboss.netty.channel.Channels.fireChannelDisconnected((Channel)serverChannel);
        org.jboss.netty.channel.Channels.fireChannelUnbound((Channel)serverChannel);
        org.jboss.netty.channel.Channels.fireChannelClosed((Channel)serverChannel);
    }
}

